/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.refactoring.JptJpaCoreRefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaMoveMappingFileParticipant
extends MoveParticipant
implements ISharableParticipant {
    protected final Map<IFile, MoveArguments> originalMappingFiles = new HashMap<IFile, MoveArguments>();
    protected final Map<IFile, Iterable<ReplaceEdit>> persistenceXmlMappingFileReplaceEdits = new HashMap<IFile, Iterable<ReplaceEdit>>();

    public String getName() {
        return JptJpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_PARTICIPANT_NAME;
    }

    protected boolean initialize(Object element) {
        if (!this.getArguments().getUpdateReferences()) {
            return false;
        }
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return true;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        this.originalMappingFiles.put((IFile)element, (MoveArguments)arguments);
    }

    protected MoveArguments getArguments(IFile element) {
        return this.originalMappingFiles.get(element);
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        monitor.subTask(JptJpaCoreRefactoringMessages.JPA_REFACORING_PARTICIPANT_LOADING_JPA_PROJECTS_SUB_TASK_NAME);
        Iterable<JpaProject> jpaProjects = this.getJpaProjects();
        int size = IterableTools.size(jpaProjects);
        if (size == 0) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(size * 10 + 1));
        sm.subTask(JptJpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_SUB_TASK_NAME);
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        for (JpaProject jpaProject : jpaProjects) {
            this.createReplaceEdits(jpaProject);
            sm.worked(10);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IFile persistenceXmlFile : this.persistenceXmlMappingFileReplaceEdits.keySet()) {
            deltaFactory.change(persistenceXmlFile);
        }
        sm.worked(1);
        return null;
    }

    protected Iterable<JpaProject> getJpaProjects() throws OperationCanceledException {
        try {
            JpaProjectManager jpaProjectManager = this.getJpaProjectManager();
            return jpaProjectManager != null ? jpaProjectManager.waitToGetJpaProjects() : IterableTools.emptyIterable();
        }
        catch (InterruptedException ex) {
            throw new OperationCanceledException(ex.getMessage());
        }
    }

    protected JpaProjectManager getJpaProjectManager() {
        return (JpaProjectManager)ResourcesPlugin.getWorkspace().getAdapter(JpaProjectManager.class);
    }

    protected void createReplaceEdits(JpaProject jpaProject) throws OperationCanceledException {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit(jpaProject);
        if (persistenceUnit == null) {
            return;
        }
        Iterable<ReplaceEdit> replaceEdits = this.createPersistenceUnitReplaceEditsCheckClasspath(persistenceUnit);
        if (!IterableTools.isEmpty(replaceEdits)) {
            this.persistenceXmlMappingFileReplaceEdits.put(jpaProject.getPersistenceXmlResource().getFile(), replaceEdits);
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.persistenceXmlMappingFileReplaceEdits.isEmpty()) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)this.persistenceXmlMappingFileReplaceEdits.size());
        sm.subTask(JptJpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_SUB_TASK_NAME);
        CompositeChange compositeChange = new CompositeChange(JptJpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_CHANGE_NAME);
        for (IFile persistenceXmlFile : this.persistenceXmlMappingFileReplaceEdits.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addPersistenceXmlRenameMappingFileChange(persistenceXmlFile, compositeChange);
        }
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitReplaceEditsCheckClasspath(PersistenceUnit persistenceUnit) {
        return IterableTools.children(this.getOriginalFoldersOnClasspath(persistenceUnit.getJpaProject()), (Transformer)new PersistenceUnitReplaceEditsTransformer(persistenceUnit));
    }

    protected Iterable<IFile> getOriginalFoldersOnClasspath(JpaProject jpaProject) {
        IJavaProject javaProject = jpaProject.getJavaProject();
        return IterableTools.filter(this.originalMappingFiles.keySet(), (Predicate)new JavaProjectTools.ResourceIsOnClasspath(javaProject));
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitReplaceEdits(PersistenceUnit persistenceUnit, IFile mappingFile, IFolder destination) {
        IProject project = destination.getProject();
        IPath fullPath = destination.getFullPath();
        ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
        IPath runtimePath = locator.getRuntimePath(fullPath);
        return persistenceUnit.createMoveMappingFileEdits(mappingFile, runtimePath);
    }

    protected void addPersistenceXmlRenameMappingFileChange(IFile persistenceXmlFile, CompositeChange compositeChange) {
        TextChange textChange = this.getTextChange(persistenceXmlFile);
        if (textChange == null) {
            textChange = new TextFileChange(JptJpaCoreRefactoringMessages.JPA_MOVE_MAPPING_FILE_REFACTORING_CHANGE_PERSISTENCE_XML_NAME, persistenceXmlFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        Iterable<ReplaceEdit> mappingFileReplaceEdits = this.persistenceXmlMappingFileReplaceEdits.get(persistenceXmlFile);
        this.addEdits(textChange, mappingFileReplaceEdits);
    }

    private PersistenceUnit getPersistenceUnit(JpaProject jpaProject) {
        PersistenceXml persistenceXml = jpaProject.getContextRoot().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getRoot();
        if (persistence == null) {
            return null;
        }
        if (persistence.getPersistenceUnitsSize() != 1) {
            return null;
        }
        return (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
    }

    private void addEdits(TextChange textChange, Iterable<? extends TextEdit> textEdits) {
        for (TextEdit textEdit : textEdits) {
            try {
                textChange.addEdit(textEdit);
            }
            catch (MalformedTreeException e) {
                JptJpaCorePlugin.instance().logError(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PersistenceUnitReplaceEditsTransformer
    extends TransformerAdapter<IFile, Iterable<ReplaceEdit>> {
        private final PersistenceUnit persistenceUnit;

        PersistenceUnitReplaceEditsTransformer(PersistenceUnit persistenceUnit) {
            this.persistenceUnit = persistenceUnit;
        }

        public Iterable<ReplaceEdit> transform(IFile mappingFile) {
            return JpaMoveMappingFileParticipant.this.createPersistenceUnitReplaceEdits(this.persistenceUnit, mappingFile, (IFolder)JpaMoveMappingFileParticipant.this.getArguments(mappingFile).getDestination());
        }
    }
}

