/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.DiscriminatorColumnComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInheritanceComposite<T extends Entity>
extends Pane<T> {
    public AbstractInheritanceComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected Composite addComposite(Composite container) {
        return this.addSubPane(container, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaUiDetailsMessages.INHERITANCE_COMPOSITE_STRATEGY);
        this.addStrategyCombo(container);
        ModifiablePropertyValueModel<Boolean> dvEnabled = this.buildDiscriminatorValueEnabledHolder();
        this.addLabel(container, JptJpaUiDetailsMessages.INHERITANCE_COMPOSITE_DISCRIMINATOR_VALUE, (PropertyValueModel)dvEnabled);
        this.addEditableCombo(container, (ListValueModel)this.buildDiscriminatorValueListHolder(), (ModifiablePropertyValueModel)this.buildDiscriminatorValueHolder(), TransformerTools.objectToStringTransformer(), (PropertyValueModel)dvEnabled, JpaHelpContextIds.ENTITY_INHERITANCE_DISCRIMINATOR_VALUE);
        DiscriminatorColumnComposite discriminatorColumnComposite = new DiscriminatorColumnComposite(this, container);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 10;
        discriminatorColumnComposite.getControl().setLayoutData((Object)gridData);
        Control pkJoinColumnsComposite = this.addPrimaryKeyJoinColumnsComposite(container);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        pkJoinColumnsComposite.setLayoutData((Object)gridData);
    }

    protected ModifiablePropertyValueModel<Boolean> buildDiscriminatorValueEnabledHolder() {
        return new PropertyAspectAdapter<Entity, Boolean>(this.getSubjectHolder(), new String[]{"discriminatorValueIsAllowed"}){

            protected Boolean buildValue_() {
                return ((Entity)this.subject).specifiedDiscriminatorValueIsAllowed();
            }
        };
    }

    private ListValueModel<String> buildDefaultDiscriminatorListValueHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultDiscriminatorValueHolder());
    }

    private ModifiablePropertyValueModel<String> buildDefaultDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"defaultDiscriminatorValue", "discriminatorValueIsUndefined"}){

            protected String buildValue_() {
                return AbstractInheritanceComposite.this.defaultValue((Entity)this.subject);
            }
        };
    }

    private String defaultValue(Entity subject) {
        String defaultValue = subject.getDefaultDiscriminatorValue();
        if (defaultValue == null && subject.discriminatorValueIsUndefined()) {
            return JptCommonUiMessages.NONE_SELECTED;
        }
        if (defaultValue != null && defaultValue.length() > 0) {
            return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
        }
        return JptJpaUiDetailsMessages.PROVIDER_DEFAULT;
    }

    private ModifiablePropertyValueModel<String> buildDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"specifiedDiscriminatorValue"}){

            protected String buildValue_() {
                String value = ((Entity)this.subject).getSpecifiedDiscriminatorValue();
                if (value == null) {
                    return AbstractInheritanceComposite.this.defaultValue((Entity)this.subject);
                }
                return value;
            }

            protected void setValue_(String value) {
                if (AbstractInheritanceComposite.this.defaultValue((Entity)this.subject).equals(value)) {
                    value = null;
                }
                ((Entity)this.subject).setSpecifiedDiscriminatorValue(value);
            }
        };
    }

    private ListValueModel<String> buildDiscriminatorValueListHolder() {
        return this.buildDefaultDiscriminatorListValueHolder();
    }

    private EnumFormComboViewer<Entity, InheritanceType> addStrategyCombo(Composite container) {
        return new EnumFormComboViewer<Entity, InheritanceType>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultInheritanceStrategy");
                propertyNames.add("specifiedInheritanceStrategy");
            }

            protected InheritanceType[] getChoices() {
                return InheritanceType.values();
            }

            protected InheritanceType getDefaultValue() {
                return ((Entity)this.getSubject()).getDefaultInheritanceStrategy();
            }

            protected String displayString(InheritanceType value) {
                switch (value) {
                    case JOINED: {
                        return JptJpaUiDetailsMessages.ABSTRACT_INHERITANCE_COMPOSITE_JOINED;
                    }
                    case SINGLE_TABLE: {
                        return JptJpaUiDetailsMessages.ABSTRACT_INHERITANCE_COMPOSITE_SINGLE_TABLE;
                    }
                    case TABLE_PER_CLASS: {
                        return JptJpaUiDetailsMessages.ABSTRACT_INHERITANCE_COMPOSITE_TABLE_PER_CLASS;
                    }
                }
                throw new IllegalStateException();
            }

            protected InheritanceType getValue() {
                return ((Entity)this.getSubject()).getSpecifiedInheritanceStrategy();
            }

            protected void setValue(InheritanceType value) {
                ((Entity)this.getSubject()).setSpecifiedInheritanceStrategy(value);
            }

            protected String getHelpId() {
                return JpaHelpContextIds.ENTITY_INHERITANCE_STRATEGY;
            }
        };
    }

    protected abstract Control addPrimaryKeyJoinColumnsComposite(Composite var1);
}

