/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.persistence;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.ui.internal.jface.ResourceManagerLabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.ResourceMappingFile;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.persistence.JptJpaUiPersistenceMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceUnitMappingFilesComposite
extends Pane<PersistenceUnit> {
    private static final Transformer<MappingFileRef, ImageDescriptor> MAPPING_FILE_REF_LABEL_IMAGE_DESCRIPTOR_TRANSFORMER = TransformerTools.staticOutputTransformer((Object)JptJpaUiImages.MAPPING_FILE_REF);
    private static final Transformer<MappingFileRef, String> MAPPING_FILE_REF_LABEL_TEXT_TRANSFORMER = new MappingFileRefLabelTextTransformer();

    public PersistenceUnitMappingFilesComposite(Pane<? extends PersistenceUnit> parent, Composite parentComposite) {
        super(parent, parentComposite);
    }

    protected void addMappingFilesList(Composite container) {
        new AddRemoveListPane((Pane)this, container, this.buildAdapter(), this.buildItemListHolder(), this.buildSelectedMappingFileRefsModel(), this.buildMappingFileRefLabelProvider(), JpaHelpContextIds.PERSISTENCE_XML_GENERAL);
    }

    MappingFileRef addJPAMappingDescriptor() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator(this.buildValidator());
        dialog.setTitle(JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_MAPPING_FILES_COMPOSITE_MAPPING_FILE_DIALOG_TITLE);
        dialog.setMessage(JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_MAPPING_FILES_COMPOSITE_MAPPING_FILE_DIALOG_MESSAGE);
        dialog.addFilter((ViewerFilter)new XmlMappingFileViewerFilter(((PersistenceUnit)this.getSubject()).getJpaProject(), ResourceMappingFile.Root.CONTENT_TYPE));
        dialog.setInput((Object)((PersistenceUnit)this.getSubject()).getJpaProject().getProject());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                IFile file = (IFile)result;
                IProject project = file.getProject();
                ProjectResourceLocator locator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
                IPath runtimePath = locator.getRuntimePath(file.getFullPath());
                String fileName = runtimePath.toPortableString();
                if (!this.mappingFileRefExists(fileName)) {
                    return ((PersistenceUnit)this.getSubject()).addSpecifiedMappingFileRef(fileName);
                }
                ++n2;
            }
        }
        return null;
    }

    private AddRemovePane.Adapter<MappingFileRef> buildAdapter() {
        return new AddRemovePane.AbstractAdapter<MappingFileRef>(){

            public MappingFileRef addNewItem() {
                return PersistenceUnitMappingFilesComposite.this.addJPAMappingDescriptor();
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<MappingFileRef> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<MappingFileRef> selectedItemsModel) {
                MappingFileRef mappingFileRef = (MappingFileRef)selectedItemsModel.iterator().next();
                ((PersistenceUnit)PersistenceUnitMappingFilesComposite.this.getSubject()).removeSpecifiedMappingFileRef(mappingFileRef);
            }
        };
    }

    private ListValueModel<MappingFileRef> buildItemListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildListHolder(), new String[]{"fileName"});
    }

    private ILabelProvider buildMappingFileRefLabelProvider() {
        return new ResourceManagerLabelProvider(MAPPING_FILE_REF_LABEL_IMAGE_DESCRIPTOR_TRANSFORMER, MAPPING_FILE_REF_LABEL_TEXT_TRANSFORMER, this.getResourceManager());
    }

    private ListValueModel<MappingFileRef> buildListHolder() {
        return new ListAspectAdapter<PersistenceUnit, MappingFileRef>(this.getSubjectHolder(), new String[]{"specifiedMappingFileRefs"}){

            protected ListIterable<MappingFileRef> getListIterable() {
                return ((PersistenceUnit)this.subject).getSpecifiedMappingFileRefs();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).getSpecifiedMappingFileRefsSize();
            }
        };
    }

    protected ModifiableCollectionValueModel<MappingFileRef> buildSelectedMappingFileRefsModel() {
        return new SimpleCollectionValueModel();
    }

    private boolean mappingFileRefExists(String fileName) {
        for (MappingFileRef mappingFileRef : ((PersistenceUnit)this.getSubject()).getSpecifiedMappingFileRefs()) {
            if (!mappingFileRef.getFileName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private ISelectionStatusValidator buildValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return JptJpaUiPlugin.instance().buildErrorStatus();
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof IFolder) {
                        return JptJpaUiPlugin.instance().buildErrorStatus();
                    }
                    ++n2;
                }
                return JptJpaUiPlugin.instance().buildOKStatus();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MappingFileRefLabelTextTransformer
    extends AbstractTransformer<MappingFileRef, String> {
        MappingFileRefLabelTextTransformer() {
        }

        protected String transform_(MappingFileRef mappingFileRef) {
            String name = mappingFileRef.getFileName();
            return name != null ? name : JptJpaUiPersistenceMessages.PERSISTENCE_UNIT_MAPPING_FILES_COMPOSITE_ORM_NO_NAME;
        }
    }
}

