/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.impl.AddBendpointContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.DerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorImageCreator;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorImageCreator;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtilImpl;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.Wrp;
import org.eclipse.swt.graphics.Point;

public class AddRelationFeature
extends AbstractAddFeature {
    private static final double START_COEFFICIENT = 0.1;
    private IJPAEditorImageCreator imageCreator;
    private IJPAEditorUtil jpaEditorUtil;

    public AddRelationFeature(IFeatureProvider fp) {
        this(fp, new JPAEditorImageCreator(), new JPAEditorUtilImpl());
    }

    public AddRelationFeature(IFeatureProvider fp, IJPAEditorImageCreator imageCreator, IJPAEditorUtil jpaEditorUtil) {
        super(fp);
        this.imageCreator = imageCreator;
        this.jpaEditorUtil = jpaEditorUtil;
    }

    public PictogramElement add(IAddContext context) {
        final IAddConnectionContext addConContext = (IAddConnectionContext)context;
        final IRelation relation = (IRelation)context.getNewObject();
        final Diagram diagram = this.getDiagram();
        final Wrp wrp = new Wrp();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)diagram);
        RecordingCommand rc = new RecordingCommand(ted){

            protected void doExecute() {
                FreeFormConnection connection = AddRelationFeature.this.createConnection(addConContext, relation, diagram);
                AddRelationFeature.this.imageCreator.createConnectionLine(diagram, (Connection)connection);
                AddRelationFeature.this.getFeatureProvider().putKeyToBusinessObject(relation.getId(), relation);
                AddRelationFeature.this.link((PictogramElement)connection, relation);
                AddRelationFeature.this.layoutPictogramElement((PictogramElement)connection);
                wrp.setObj(connection);
            }
        };
        try {
            ted.getCommandStack().execute((Command)rc);
        }
        catch (Exception exception) {}
        return (PictogramElement)wrp.getObj();
    }

    private FreeFormConnection createConnection(IAddConnectionContext addConContext, IRelation relation, Diagram diagram) {
        FreeFormConnection connection = this.getFeatureProvider().getPeServiceUtil().createFreeFormConnection(diagram);
        connection.setStart(addConContext.getSourceAnchor());
        connection.setEnd(addConContext.getTargetAnchor());
        connection.setVisible(true);
        connection.setActive(true);
        List<Point> points = this.jpaEditorUtil.createBendPointList(connection, relation.getOwner() == relation.getInverse());
        int i = 0;
        while (i < points.size()) {
            Point p = points.get(i);
            AddBendpointContext ctx = new AddBendpointContext(connection, p.x, p.y, i);
            IAddBendpointFeature ft = this.getFeatureProvider().getAddBendpointFeature((IAddBendpointContext)ctx);
            ft.addBendpoint((IAddBendpointContext)ctx);
            ++i;
        }
        this.addDecorators(connection, relation);
        this.addTextDecorators(connection, relation);
        return connection;
    }

    private void addDecorators(FreeFormConnection connection, IRelation relation) {
        IRelation.RelDir direction = relation.getRelDir();
        IRelation.RelType type = relation.getRelType();
        if (IRelation.RelType.ONE_TO_ONE.equals((Object)type)) {
            this.addOneToOneDecorator(connection, direction, relation);
        } else if (IRelation.RelType.ONE_TO_MANY.equals((Object)type) && IRelation.RelDir.UNI.equals((Object)direction)) {
            this.addOneToManyDecorator(connection, relation);
        } else if (IRelation.RelType.MANY_TO_ONE.equals((Object)type)) {
            this.addManyToOneDecorator(connection, direction, relation);
        } else if (IRelation.RelType.MANY_TO_MANY.equals((Object)type)) {
            this.addManyToManyDecorator(connection, direction, relation);
        }
    }

    private void addTextDecorators(FreeFormConnection connection, IRelation relation) {
        IRelation.RelDir direction = relation.getRelDir();
        IRelation.RelType type = relation.getRelType();
        if (IRelation.RelType.ONE_TO_ONE.equals((Object)type)) {
            this.addOneToOneTextDecorator(connection, direction, relation);
        } else if (IRelation.RelType.ONE_TO_MANY.equals((Object)type) && IRelation.RelDir.UNI.equals((Object)direction)) {
            this.addOneToManyTextDecorator(connection, relation);
        } else if (IRelation.RelType.MANY_TO_ONE.equals((Object)type)) {
            this.addManyToOneTextDecorator(connection, direction, relation);
        } else if (IRelation.RelType.MANY_TO_MANY.equals((Object)type)) {
            this.addManyToManyTextDecorator(connection, direction, relation);
        }
    }

    private void addOneToOneDecorator(FreeFormConnection c, IRelation.RelDir direction, IRelation rel) {
        double startCoefficient = 0.1;
        double endCoefficient = 1.0 - startCoefficient;
        int len = JPAEditorUtil.calcConnectionLength(c);
        if (IRelation.RelDir.UNI.equals((Object)direction)) {
            ConnectionDecorator d = this.imageCreator.createArrowConnectionDecorator((Connection)c, endCoefficient);
            Graphiti.getGaService().setLocation(d.getGraphicsAlgorithm(), Math.round(-len / 10), 0);
        }
    }

    private void addOneToManyDecorator(FreeFormConnection c, IRelation rel) {
        double startCoefficient = 0.1;
        double endCoefficient = 1.0 - startCoefficient;
        int len = JPAEditorUtil.calcConnectionLength(c);
        ConnectionDecorator d = this.imageCreator.createManyEndWithArrowDecorator((Connection)c, endCoefficient);
        Graphiti.getGaService().setLocation(d.getGraphicsAlgorithm(), Math.round(-len / 10), 0);
    }

    private void addManyToOneDecorator(FreeFormConnection c, IRelation.RelDir direction, IRelation rel) {
        double startCoefficient = 0.1;
        double endCoefficient = 1.0 - startCoefficient;
        int len = JPAEditorUtil.calcConnectionLength(c);
        ConnectionDecorator d1 = this.imageCreator.createManyStartDecorator((Connection)c, startCoefficient);
        Graphiti.getGaService().setLocation(d1.getGraphicsAlgorithm(), Math.round(len / 10), 0);
        if (IRelation.RelDir.UNI.equals((Object)direction)) {
            ConnectionDecorator d2 = this.imageCreator.createArrowConnectionDecorator((Connection)c, endCoefficient);
            Graphiti.getGaService().setLocation(d2.getGraphicsAlgorithm(), Math.round(-len / 10), 0);
        }
    }

    private void addManyToManyDecorator(FreeFormConnection c, IRelation.RelDir direction, IRelation rel) {
        double startCoefficient = 0.1;
        double endCoefficient = 1.0 - startCoefficient;
        int len = JPAEditorUtil.calcConnectionLength(c);
        ConnectionDecorator d1 = this.imageCreator.createManyStartDecorator((Connection)c, startCoefficient);
        Graphiti.getGaService().setLocation(d1.getGraphicsAlgorithm(), Math.round(len / 10), 0);
        if (IRelation.RelDir.UNI.equals((Object)direction)) {
            ConnectionDecorator d = this.imageCreator.createManyEndWithArrowDecorator((Connection)c, endCoefficient);
            Graphiti.getGaService().setLocation(d.getGraphicsAlgorithm(), Math.round(-len / 10), 0);
        } else {
            ConnectionDecorator d = this.imageCreator.createManyEndDecorator((Connection)c, endCoefficient, false);
            Graphiti.getGaService().setLocation(d.getGraphicsAlgorithm(), Math.round(-len / 10), 0);
        }
    }

    private void addOneToOneTextDecorator(FreeFormConnection c, IRelation.RelDir direction, IRelation rel) {
        AttributeMapping mapping;
        boolean isOptional = false;
        if (IRelation.RelDir.BI.equals((Object)direction)) {
            PersistentAttribute inverse = rel.getInverse().getAttributeNamed(rel.getInverseAttributeName());
            mapping = JpaArtifactFactory.instance().getAttributeMapping(inverse);
            if (mapping instanceof OneToOneMapping) {
                isOptional = ((OneToOneMapping)mapping).isOptional();
            }
            this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, isOptional ? JPAEditorConstants.CARDINALITY_ZERO_ONE : JPAEditorConstants.CARDINALITY_ONE, 0.0);
        }
        PersistentAttribute owner = rel.getOwner().getAttributeNamed(rel.getOwnerAttributeName());
        owner.update();
        if (this.isDerivedId(owner)) {
            isOptional = false;
        } else {
            mapping = JpaArtifactFactory.instance().getAttributeMapping(owner);
            if (mapping instanceof OneToOneMapping) {
                isOptional = ((OneToOneMapping)mapping).isOptional();
            }
        }
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, isOptional ? JPAEditorConstants.CARDINALITY_ZERO_ONE : JPAEditorConstants.CARDINALITY_ONE, 1.0);
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, rel.getOwnerAttributeName(), 0.0);
        if (!IRelation.RelDir.UNI.equals((Object)direction)) {
            this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, rel.getInverseAttributeName(), 1.0);
        }
    }

    private boolean isDerivedId(PersistentAttribute attr) {
        DerivedIdentity2_0 derivedIdentity;
        AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(attr);
        return attributeMapping instanceof SingleRelationshipMapping2_0 && ((derivedIdentity = ((SingleRelationshipMapping2_0)attributeMapping).getDerivedIdentity()).usesIdDerivedIdentityStrategy() || derivedIdentity.usesMapsIdDerivedIdentityStrategy());
    }

    private void addOneToManyTextDecorator(FreeFormConnection c, IRelation rel) {
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, JPAEditorConstants.CARDINALITY_ZERO_ONE, 0.0);
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, JPAEditorConstants.CARDINALITY_ZERO_N, 1.0);
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, rel.getOwnerAttributeName(), 0.0);
    }

    private void addManyToOneTextDecorator(FreeFormConnection c, IRelation.RelDir direction, IRelation rel) {
        boolean isOptional = false;
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, JPAEditorConstants.CARDINALITY_ZERO_N, 0.0);
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, rel.getOwnerAttributeName(), 0.0);
        PersistentAttribute owner = rel.getOwner().getAttributeNamed(rel.getOwnerAttributeName());
        if (this.isDerivedId(owner)) {
            isOptional = false;
        } else {
            AttributeMapping mapping = JpaArtifactFactory.instance().getAttributeMapping(owner);
            if (mapping instanceof ManyToOneMapping) {
                isOptional = ((ManyToOneMapping)mapping).isOptional();
            }
        }
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, isOptional ? JPAEditorConstants.CARDINALITY_ZERO_ONE : JPAEditorConstants.CARDINALITY_ONE, 1.0);
        if (!IRelation.RelDir.UNI.equals((Object)direction)) {
            this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, rel.getInverseAttributeName(), 1.0);
        }
    }

    private void addManyToManyTextDecorator(FreeFormConnection c, IRelation.RelDir direction, IRelation rel) {
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, JPAEditorConstants.CARDINALITY_ZERO_N, 0.0);
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, JPAEditorConstants.CARDINALITY_ZERO_N, 1.0);
        this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, rel.getOwnerAttributeName(), 0.0);
        if (!IRelation.RelDir.UNI.equals((Object)direction)) {
            this.imageCreator.createCardinalityConnectionDecorator(this.getDiagram(), (Connection)c, rel.getInverseAttributeName(), 1.0);
        }
    }

    public boolean canAdd(IAddContext context) {
        return context instanceof IAddConnectionContext && context.getNewObject() instanceof IRelation;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }
}

