/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.core.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.alm.mylyn.core.Activator;
import org.eclipse.jubula.client.alm.mylyn.core.i18n.Messages;
import org.eclipse.jubula.client.alm.mylyn.core.model.CommentEntry;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ALMAccess {
    private static final Logger LOG = LoggerFactory.getLogger(ALMAccess.class);

    private ALMAccess() {
    }

    public static TaskRepository getRepositoryByLabel(String repoLabel) {
        List<TaskRepository> allRepositories = ALMAccess.getAllRepositories();
        for (TaskRepository repo : allRepositories) {
            if (!repo.getRepositoryLabel().equals(repoLabel)) continue;
            return repo;
        }
        return null;
    }

    public static List<TaskRepository> getAllRepositories() {
        IRepositoryManager repositoryManager = TasksUi.getRepositoryManager();
        return repositoryManager.getAllRepositories();
    }

    private static ITask getTaskByID(TaskRepository repo, String taskId, IProgressMonitor monitor) throws CoreException {
        IRepositoryModel repositoryModel;
        ITask task = null;
        if (ALMAccess.validRepository(repo) && (task = (repositoryModel = TasksUi.getRepositoryModel()).getTask(repo, taskId)) == null) {
            task = repositoryModel.createTask(repo, taskId);
        }
        return task;
    }

    private static boolean validRepository(TaskRepository repo) {
        return repo != null && !repo.isOffline();
    }

    public static boolean createComment(String repoLabel, String taskId, List<CommentEntry> comments, IProgressMonitor monitor) {
        boolean succeeded = false;
        TaskRepository repo = ALMAccess.getRepositoryByLabel(repoLabel);
        try {
            TaskData taskData = ALMAccess.getTaskDataByID(repo, taskId, monitor);
            if (taskData == null) {
                return succeeded;
            }
            ITask task = ALMAccess.getTaskByID(repo, taskData.getTaskId(), monitor);
            if (task != null) {
                ITaskDataManager taskDataManager = TasksUi.getTaskDataManager();
                ITaskDataWorkingCopy taskWorkingCopy = taskDataManager.createWorkingCopy(task, taskData);
                TaskDataModel taskModel = new TaskDataModel(repo, task, taskWorkingCopy);
                String connectorKind = repo.getConnectorKind();
                AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)connectorKind);
                AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
                TaskAttribute rootData = taskModel.getTaskData().getRoot();
                CONNECTOR handle = ALMAccess.determineConnectorHandling(connectorKind);
                TaskAttribute change = null;
                switch (handle) {
                    case HP_ALM: {
                        change = ALMAccess.hpAlmHandling(comments, rootData);
                        break;
                    }
                    default: {
                        change = ALMAccess.defaultHandling(comments, rootData);
                    }
                }
                if (change == null) {
                    return succeeded;
                }
                taskModel.attributeChanged(change);
                RepositoryResponse response = taskDataHandler.postTaskData(taskModel.getTaskRepository(), taskModel.getTaskData(), taskModel.getChangedOldAttributes(), monitor);
                succeeded = RepositoryResponse.ResponseKind.TASK_UPDATED.equals((Object)response.getReposonseKind());
            }
        }
        catch (CoreException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return succeeded;
    }

    private static TaskData getTaskDataByID(TaskRepository repo, String taskId, IProgressMonitor monitor) throws CoreException {
        TaskData taskData = null;
        if (ALMAccess.validRepository(repo)) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repo.getConnectorKind());
            taskData = connector.getTaskData(repo, taskId, monitor);
        }
        return taskData;
    }

    private static TaskAttribute hpAlmHandling(List<CommentEntry> commentEntries, TaskAttribute attr) {
        Properties almProps = Activator.getDefault().getAlmAccessProperties();
        String hpTaskKindKeyPrefix = String.valueOf(CONNECTOR.HP_ALM.toString()) + "." + "task.common.kind";
        String req = String.valueOf(hpTaskKindKeyPrefix) + ".REQUIREMENT";
        String hpTaskKindReq = almProps.getProperty(req);
        String def = String.valueOf(hpTaskKindKeyPrefix) + ".DEFECT";
        String hpTaskKindDefect = almProps.getProperty(def);
        String taskKindValue = attr.getMappedAttribute("task.common.kind").getValue();
        String attrName = null;
        if (hpTaskKindReq.equals(taskKindValue)) {
            attrName = almProps.getProperty(String.valueOf(req) + ".comment");
        } else if (hpTaskKindDefect.equals(taskKindValue)) {
            attrName = almProps.getProperty(String.valueOf(def) + ".comment");
        }
        if (attrName != null) {
            TaskAttribute commentAttribute = attr.getMappedAttribute(attrName);
            String oldComment = commentAttribute.getValue();
            String newComment = "";
            for (CommentEntry c : commentEntries) {
                newComment = String.valueOf(c.toString()) + "<br>" + c.getDashboardURL() + "<br>" + newComment;
            }
            commentAttribute.setValue(String.valueOf(newComment) + oldComment);
            return commentAttribute;
        }
        return null;
    }

    private static TaskAttribute defaultHandling(List<CommentEntry> commentEntries, TaskAttribute attr) {
        TaskAttribute newComment = attr.createMappedAttribute("task.common.comment.new");
        String comment = "";
        for (CommentEntry c : commentEntries) {
            comment = String.valueOf(comment) + "\n" + c.toString() + "\n" + c.getDashboardURL() + "\n" + "\n";
        }
        newComment.setValue(comment);
        return newComment;
    }

    private static CONNECTOR determineConnectorHandling(String connectorKind) {
        String hpAlmConnectorKind = Activator.getDefault().getAlmAccessProperties().getProperty(CONNECTOR.HP_ALM.toString());
        if (hpAlmConnectorKind.equals(connectorKind)) {
            return CONNECTOR.HP_ALM;
        }
        return CONNECTOR.DEFAULT;
    }

    public static IStatus testConnection(String repoLabel) {
        TaskRepository repository = ALMAccess.getRepositoryByLabel(repoLabel);
        if (repository == null) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", NLS.bind((String)Messages.TaskRepositoryNotFound, (Object)repoLabel));
        }
        if (repository.isOffline()) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", NLS.bind((String)Messages.TaskRepositoryOffline, (Object)repoLabel));
        }
        boolean savePassword = repository.getSavePassword(AuthenticationType.REPOSITORY);
        if (!savePassword) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", NLS.bind((String)Messages.TaskRepositoryNoCredentialsStored, (Object)repoLabel));
        }
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)repository.getConnectorKind());
        if (connector == null) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", NLS.bind((String)Messages.TaskRepositoryNoCredentialsStored, (Object)repoLabel));
        }
        try {
            connector.updateRepositoryConfiguration(repository, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.jubula.client.alm.mylyn.core", e.getLocalizedMessage().replace("\n\n", " "));
        }
        IStatus repoStatus = repository.getStatus();
        if (repoStatus != null) {
            return repoStatus;
        }
        return Status.OK_STATUS;
    }

    public static class ALMDefaultTaskMapping
    extends TaskMapping {
        private Map<String, String> m_values = new HashMap<String, String>();

        public String getDescription() {
            return this.m_values.get("task.common.description");
        }

        public String getSummary() {
            return this.m_values.get("task.common.summary");
        }

        public String getProduct() {
            return this.m_values.get("task.common.product");
        }

        public String getTaskKind() {
            return this.m_values.get("task.common.kind");
        }
    }

    public static enum CONNECTOR {
        DEFAULT,
        HP_ALM;

    }
}

