/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jubula.client.core.functions.FunctionDefinition;
import org.eclipse.jubula.client.core.functions.IFunctionEvaluator;
import org.eclipse.jubula.client.core.functions.ParameterDefinition;
import org.eclipse.jubula.client.core.functions.VarArgsDefinition;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionRegistry.class);
    private static final String EXTENSION_POINT_ID = "org.eclipse.jubula.client.core.functions";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_DEFAULT_ARG_COUNT = "defaultArgumentCount";
    private static final String ELEMENT_PARAM = "parameter";
    private static final String ELEMENT_VARARG = "varArg";
    private static FunctionRegistry instance = null;
    private Map<String, FunctionDefinition> m_registeredFunctions = null;

    private FunctionRegistry() {
        this.registerFunctions();
    }

    public static synchronized FunctionRegistry getInstance() {
        if (instance == null) {
            instance = new FunctionRegistry();
        }
        return instance;
    }

    private void registerFunctions() {
        HashMap<String, FunctionDefinition> registeredFunctions = new HashMap<String, FunctionDefinition>();
        IExtensionPoint functionExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = functionExtensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement functionElement = iConfigurationElementArray[n4];
                String functionName = functionElement.getAttribute(ATTR_NAME);
                VarArgsDefinition varArg = null;
                ArrayList<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();
                IConfigurationElement[] iConfigurationElementArray2 = functionElement.getChildren(ELEMENT_PARAM);
                int n5 = iConfigurationElementArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement parameterElement = iConfigurationElementArray2[n6];
                    String name = parameterElement.getAttribute(ATTR_NAME);
                    String type = parameterElement.getAttribute(ATTR_TYPE);
                    parameters.add(new ParameterDefinition(name, type));
                    ++n6;
                }
                iConfigurationElementArray2 = functionElement.getChildren(ELEMENT_VARARG);
                n5 = iConfigurationElementArray2.length;
                n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement varArgElement = iConfigurationElementArray2[n6];
                    varArg = new VarArgsDefinition(varArgElement.getAttribute(ATTR_TYPE), Integer.parseInt(varArgElement.getAttribute(ATTR_DEFAULT_ARG_COUNT)));
                    ++n6;
                }
                ParameterDefinition[] parameterArray = new ParameterDefinition[parameters.size()];
                parameterArray = parameters.toArray(parameterArray);
                try {
                    Object evaluator = functionElement.createExecutableExtension(ATTR_CLASS);
                    if (evaluator instanceof IFunctionEvaluator) {
                        FunctionDefinition function = new FunctionDefinition(functionName, parameterArray, varArg, (IFunctionEvaluator)evaluator);
                        registeredFunctions.put(function.getName(), function);
                    } else {
                        LOG.error(NLS.bind((String)Messages.FunctionRegistry_WrongEvaluatorType, (Object[])new Object[]{evaluator.getClass(), functionName, IFunctionEvaluator.class.getName()}));
                    }
                }
                catch (CoreException e) {
                    LOG.error(NLS.bind((String)Messages.FunctionRegistry_EvaluatorCreationError, (Object)functionName), (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        this.m_registeredFunctions = Collections.unmodifiableMap(registeredFunctions);
    }

    public Collection<FunctionDefinition> getAllFunctions() {
        return this.m_registeredFunctions.values();
    }

    public FunctionDefinition getFunction(String functionName) {
        return this.m_registeredFunctions.get(functionName);
    }
}

