/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTraverserContext<T>
implements ITreeTraverserContext<T> {
    private LinkedList<T> m_treePath = new LinkedList();
    private boolean m_continue = true;
    private T m_rootNode;

    public TreeTraverserContext(T rootNode) {
        this.m_rootNode = rootNode;
    }

    @Override
    public List<T> getCurrentTreePath() {
        return Collections.unmodifiableList(this.m_treePath);
    }

    @Override
    public T getRootNode() {
        return this.m_rootNode;
    }

    @Override
    public void setContinued(boolean continued) {
        this.m_continue = continued;
    }

    @Override
    public boolean isContinue() {
        return this.m_continue;
    }

    @Override
    public void append(T node) {
        this.m_treePath.add(node);
    }

    @Override
    public void removeLast() {
        this.m_treePath.removeLast();
    }

    public String toString() {
        try {
            INodePO[] treePath = this.m_treePath.toArray(new INodePO[this.m_treePath.size()]);
            StringBuilder sb = new StringBuilder();
            INodePO[] iNodePOArray = treePath;
            int n = treePath.length;
            int n2 = 0;
            while (n2 < n) {
                INodePO node = iNodePOArray[n2];
                sb.append("/").append(node.getName());
                ++n2;
            }
            if (sb.length() == 0) {
                sb.append("/");
            }
            return sb.toString();
        }
        catch (Throwable throwable) {
            return super.toString();
        }
    }
}

