/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.checks.contexts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;
import org.eclipse.jubula.client.teststyle.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventHandlerContext
extends BaseContext {
    public EventHandlerContext() {
        super(IEventExecTestCasePO.class);
    }

    public List<Object> getAll() {
        ArrayList<Object> tmp = new ArrayList<Object>();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        for (ISpecPersistable p : project.getSpecObjCont().getSpecObjList()) {
            tmp.addAll(this.getEventHandler(p));
        }
        return tmp;
    }

    private List<Object> getEventHandler(Object root) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (root instanceof ISpecTestCasePO) {
            tmp.addAll(this.handleSpecTestCase((ISpecTestCasePO)root));
        } else if (root instanceof ICategoryPO) {
            ICategoryPO cat = (ICategoryPO)root;
            for (Object o : cat.getUnmodifiableNodeList()) {
                tmp.addAll(this.getEventHandler(o));
            }
        }
        return tmp;
    }

    private List<Object> handleSpecTestCase(ISpecTestCasePO spec) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        for (Object obj : spec.getAllEventEventExecTC()) {
            IEventExecTestCasePO event = (IEventExecTestCasePO)obj;
            if (this.isFromReusedProject(event)) continue;
            tmp.add(obj);
        }
        return tmp;
    }

    private boolean isFromReusedProject(IEventExecTestCasePO exec) {
        if (exec.getSpecTestCase() == null) {
            return true;
        }
        long projId = GeneralStorage.getInstance().getProject().getId();
        return projId != exec.getSpecTestCase().getParentProjectId();
    }

    @Override
    public String getName() {
        return Messages.ContextEventHandlerName;
    }

    @Override
    public String getDescription() {
        return Messages.ContextEventHandlerDescription;
    }
}

