/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets.autconfig;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.ui.rcp.businessprocess.RemoteFileBrowserBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.widgets.autconfig.AutConfigComponent;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.UIComponentHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WinAppsAutConfigComponent
extends AutConfigComponent {
    private Text m_modernUiAppName;
    private Text m_autArgsTextField;
    private WidgetModifyListener m_modifyListener;

    public WinAppsAutConfigComponent(Composite parent, int style, Map<String, String> autConfig, String autName) {
        super(parent, style, autConfig, autName, false);
    }

    @Override
    protected void initState() {
        this.m_modernUiAppName.setEnabled(true);
        this.m_autArgsTextField.setEnabled(true);
        this.checkLocalhostServer();
        RemoteFileBrowserBP.clearCache();
    }

    @Override
    protected void createBasicArea(Composite basicAreaComposite) {
        super.createBasicArea(basicAreaComposite);
        Composite basicAreaModernUiApp = new Composite(basicAreaComposite, 0);
        this.createLayout(basicAreaModernUiApp);
        GridData gridDataArea = (GridData)basicAreaModernUiApp.getLayoutData();
        gridDataArea.horizontalAlignment = 4;
        UIComponentHelper.createLabel((Composite)basicAreaComposite, (String)Messages.AUTConfigComponentAppName);
        this.m_modernUiAppName = UIComponentHelper.createTextField((Composite)basicAreaComposite, (int)2);
        LayoutUtil.setMaxChar((Text)this.m_modernUiAppName, (int)4000);
        ControlDecorator.createInfo((Control)UIComponentHelper.createLabel((Composite)basicAreaComposite, (String)Messages.AUTConfigComponentArguments), Messages.AUTConfigComponentArgumentsControlDecorator, false);
        this.m_autArgsTextField = UIComponentHelper.createTextField((Composite)basicAreaComposite, (int)2);
        this.createAutDirectoryEditor(basicAreaComposite);
    }

    @Override
    protected void populateBasicArea(Map<String, String> data) {
        super.populateBasicArea(data);
        this.m_modernUiAppName.setText(StringUtils.defaultString((String)data.get("EXECUTABLE")));
        this.m_autArgsTextField.setText(StringUtils.defaultString((String)data.get("AUT_ARGUMENTS")));
        this.m_modernUiAppName.setText(StringUtils.defaultString((String)data.get("APP_NAME")));
    }

    @Override
    protected void createAdvancedArea(Composite advancedAreaComposite) {
    }

    @Override
    protected void populateExpertArea(Map<String, String> data) {
    }

    @Override
    protected void populateAdvancedArea(Map<String, String> data) {
    }

    @Override
    protected boolean isJavaAut() {
        return true;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        this.getServerCombo().addModifyListener((ModifyListener)modifyListener);
        this.m_modernUiAppName.addModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.addModifyListener((ModifyListener)modifyListener);
    }

    @Override
    protected void deinstallListeners() {
        super.deinstallListeners();
        WidgetModifyListener modifyListener = this.getModifyListener();
        this.getServerCombo().removeModifyListener((ModifyListener)modifyListener);
        this.m_modernUiAppName.removeModifyListener((ModifyListener)modifyListener);
        this.m_autArgsTextField.removeModifyListener((ModifyListener)modifyListener);
    }

    private WidgetModifyListener getModifyListener() {
        if (this.m_modifyListener == null) {
            this.m_modifyListener = new WidgetModifyListener();
        }
        return this.m_modifyListener;
    }

    @Override
    protected void checkAll(List<DialogStatusParameter> paramList) {
        super.checkAll(paramList);
        this.addError(paramList, this.modifyAutParamFieldAction());
        this.addError(paramList, this.modifyModernUiAppName());
        this.addError(paramList, this.modifyAutParamFieldAction());
        this.hideWorkingDirColumn();
    }

    DialogStatusParameter modifyAutParamFieldAction() {
        String params = this.m_autArgsTextField.getText();
        this.putConfigValue("AUT_ARGUMENTS", params);
        return null;
    }

    private DialogStatusParameter modifyModernUiAppName() {
        boolean isAppNameEmpty;
        DialogStatusParameter error = null;
        boolean bl = isAppNameEmpty = this.m_modernUiAppName.getText().length() == 0;
        if (!this.isValid((Widget)this.m_modernUiAppName, true) && !isAppNameEmpty) {
            error = this.createErrorStatus(Messages.AUTConfigComponentWrongModernUiAppName);
        }
        this.putConfigValue("APP_NAME", this.m_modernUiAppName.getText());
        return error;
    }

    private class WidgetModifyListener
    implements ModifyListener {
        private WidgetModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source.equals(WinAppsAutConfigComponent.this.m_modernUiAppName) || source.equals(WinAppsAutConfigComponent.this.m_autArgsTextField)) {
                WinAppsAutConfigComponent.this.checkAll();
            } else if (source.equals(WinAppsAutConfigComponent.this.getServerCombo())) {
                WinAppsAutConfigComponent.this.checkLocalhostServer();
                WinAppsAutConfigComponent.this.checkAll();
            }
        }
    }
}

