/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;

public class KeyboardHelper {
    private static AutServerLogger log = new AutServerLogger(KeyboardHelper.class);
    private static final String DELIMITER = "+";
    private static final String SHIFT = "shift";
    private static final String CTRL = "ctrl";
    private static final String ALT = "alt";
    private Map m_mapping = new HashMap();

    public KeyboardHelper(Properties layout) {
        this.initKeyboardMapping(layout);
    }

    private void initKeyboardMapping(Properties layout) {
        for (String string : layout.keySet()) {
            if (string.length() < 1) {
                log.error((Object)"Could not parse keyboard layout.", (Throwable)new RobotException((Throwable)new IOException("Could not parse keyboard layout.")));
            }
            char origChar = string.charAt(0);
            String mapping = ((String)layout.get(string)).toLowerCase();
            StringTokenizer tok = new StringTokenizer(mapping, DELIMITER);
            char nativeChar = mapping.charAt(mapping.length() - 1);
            KeyStroke keyStroke = new KeyStroke(nativeChar);
            while (tok.hasMoreTokens()) {
                String modifier = tok.nextToken();
                int mod = this.getModifier(modifier);
                if (mod == 0) continue;
                keyStroke.addModifier(mod);
            }
            this.m_mapping.put(new Character(origChar), keyStroke);
        }
    }

    private int getModifier(String modifier) {
        int mod = 0;
        if (CTRL.equals(modifier)) {
            mod = 262144;
        } else if (SHIFT.equals(modifier)) {
            mod = 131072;
        } else if (ALT.equals(modifier)) {
            mod = 65536;
        }
        return mod;
    }

    public KeyStroke getKeyStroke(char character) {
        KeyStroke keyStroke = null;
        if (Character.isUpperCase(character)) {
            char lowChar = Character.toLowerCase(character);
            keyStroke = new KeyStroke(lowChar);
            keyStroke.addModifier(131072);
            return keyStroke;
        }
        if (this.isSingleKey(character)) {
            return new KeyStroke(character);
        }
        keyStroke = (KeyStroke)this.m_mapping.get(new Character(character));
        if (keyStroke == null && log.isDebugEnabled()) {
            log.debug((Object)("No keyboard-mapping found for character '" + String.valueOf(character) + "'!"));
        }
        return keyStroke != null ? keyStroke : new KeyStroke(character);
    }

    private boolean isSingleKey(char character) {
        return Character.isLowerCase(character) || Character.isWhitespace(character) || Character.isDigit(character);
    }

    public static class KeyStroke {
        private char m_char = (char)48;
        private List m_modifiers = new ArrayList(3);

        public KeyStroke(char character) {
            this.m_char = character;
        }

        public char getChar() {
            return this.m_char;
        }

        public Integer[] getModifiers() {
            return this.m_modifiers.toArray(new Integer[this.m_modifiers.size()]);
        }

        public void addModifier(int modifier) {
            this.m_modifiers.add(new Integer(modifier));
        }
    }
}

