/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.listener;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.ServerShowDialogMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.commands.ShowDialogResultCommand;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.rc.swt.listener.AbstractAutSwtEventListener;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.rc.swt.listener.RecordHelperSWT;
import org.eclipse.jubula.rc.swt.listener.TableSelectionTracker;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.utils.StringParsing;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class CheckListener
extends AbstractAutSwtEventListener {
    private static AutServerLogger log = new AutServerLogger(CheckListener.class);
    private boolean m_active = true;
    private RecordHelperSWT m_recordHelperSWT = new RecordHelperSWT();

    public void handleEvent(final Event event) {
        Display display = ((SwtAUTServer)AUTServer.getInstance()).getAutDisplay();
        if (display != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    if (event.equals(CheckListener.this.getLastEvent())) {
                        return;
                    }
                    if (event.type == 5) {
                        CheckListener.this.handleMouseEvent();
                    }
                    if (event.type == 1) {
                        CheckListener.this.handleKeyEvent(event);
                    }
                    CheckListener.this.setLastEvent(event);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleKeyEvent(Event event) {
        Object object = this.getComponentLock();
        synchronized (object) {
            if (event.type == 1) {
                IComponentIdentifier id = null;
                Widget source = event.widget;
                int accepted = this.getAcceptor().accept(event);
                if (accepted == 2) {
                    this.changeCheckModeState(3);
                    this.cleanUp();
                }
                if (accepted == 3 && this.getCurrentComponent() != null && !(this.getCurrentComponent() instanceof Shell)) {
                    try {
                        id = ComponentHandler.getIdentifier(this.getCurrentComponent());
                        Map checkValues = this.getCheckValues(this.getCurrentComponent());
                        String logName = this.m_recordHelperSWT.generateLogicalName(this.getCurrentComponent(), id);
                        this.openCheckDialog(id, checkValues, logName);
                    }
                    catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                        log.error((Object)("no identifier for '" + source));
                    }
                }
            }
        }
    }

    protected void handleMouseEvent() {
        Widget widget = SwtUtils.getWidgetAtCursorLocation();
        this.setCurrentComponent(widget);
        this.setCurrentWidget();
        this.highlightComponent();
    }

    protected void openCheckDialog(IComponentIdentifier id, Map checkValues, String logName) {
        try {
            AUTServer.getInstance().setMode(1);
            this.m_active = true;
            Component comp = AUTServerConfiguration.getInstance().findComponent(id.getSupportedClassName());
            this.sendMessage(id, comp, checkValues, logName);
            AUTServer.getInstance().setObservingDialogOpen(true);
            if (this.m_active) {
                AUTServer.getInstance().setMode(4);
            }
        }
        catch (CommunicationException nifce) {
            AUTServer.getInstance().setObservingDialogOpen(false);
            log.error((Object)("communication exception: '" + (Object)((Object)nifce)));
        }
    }

    protected Color getBorderColor() {
        return new Color(null, 200, 0, 0);
    }

    protected Map addFocExistEnbl(Map valueMap, String hasFocus, String exists, String enabled) {
        valueMap.put("CompSystem.HasFocus", hasFocus);
        valueMap.put("CompSystem.IsExisting", exists);
        valueMap.put("CompSystem.IsEnabled", enabled);
        return valueMap;
    }

    private void sendMessage(IComponentIdentifier id, Component comp, Map checkValues, String logName) throws CommunicationException {
        ServerShowDialogMessage message = new ServerShowDialogMessage(comp, id, checkValues);
        message.setAction(3);
        Point compLoc = SwtUtils.getWidgetLocation(this.getCurrentComponent());
        message.setPoint(new java.awt.Point(compLoc.x, compLoc.y));
        message.setLogicalName(logName);
        ShowDialogResultCommand command = new ShowDialogResultCommand();
        AUTServer.getInstance().getServerCommunicator().request((Message)message, (ICommand)command, 6000);
    }

    protected Map getCheckValues(Widget widget) {
        Map valueMap = new HashMap();
        if (widget instanceof Text) {
            valueMap = this.getTextValues(widget);
        }
        if (widget instanceof Button) {
            valueMap = this.getButtonValues(widget);
        }
        if (widget instanceof Label) {
            valueMap = this.getLabelValues(widget);
        }
        if (widget instanceof CLabel) {
            valueMap = this.getCLabelValues(widget);
        }
        if (widget instanceof Tree) {
            valueMap = this.getTreeValues(widget);
        }
        if (widget instanceof List) {
            valueMap = this.getListValues(widget);
        }
        if (widget instanceof Combo) {
            valueMap = this.getComboValues(widget);
        }
        if (widget instanceof CCombo) {
            valueMap = this.getCComboValues(widget);
        }
        if (widget instanceof TabFolder) {
            valueMap = this.getTabFolderValues(widget);
        }
        if (widget instanceof CTabFolder) {
            valueMap = this.getCTabFolderValues(widget);
        }
        if (widget instanceof Table) {
            valueMap = this.getTableValues(widget);
        }
        if (widget instanceof ToolItem) {
            valueMap = this.getToolItemValues(widget);
        }
        return valueMap;
    }

    protected Map getTextValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        Text t = (Text)widget;
        String text = StringParsing.singleQuoteText((String)t.getText());
        map.put("CompSystem.Text", text);
        String hasFocus = StringParsing.boolToString((boolean)t.isFocusControl());
        String exists = StringParsing.boolToString((boolean)t.isVisible());
        String enabled = StringParsing.boolToString((boolean)t.isEnabled());
        String editable = StringParsing.boolToString((boolean)t.getEditable());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        map.put("CompSystem.IsEditable", editable);
        return map;
    }

    protected Map getButtonValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        Button ab = (Button)widget;
        String text = StringParsing.singleQuoteText((String)ab.getText());
        text = SwtUtils.removeMnemonics(text);
        String hasFocus = StringParsing.boolToString((boolean)ab.isFocusControl());
        String exists = StringParsing.boolToString((boolean)ab.isVisible());
        String enabled = StringParsing.boolToString((boolean)ab.isEnabled());
        String selected = StringParsing.boolToString((boolean)ab.getSelection());
        map.put("CompSystem.Text", text);
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        map.put("CompSystem.IsSelected", selected);
        return map;
    }

    protected Map getLabelValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        Label lbl = (Label)widget;
        String text = StringParsing.singleQuoteText((String)lbl.getText());
        text = SwtUtils.removeMnemonics(text);
        String hasFocus = StringParsing.boolToString((boolean)lbl.isFocusControl());
        String exists = StringParsing.boolToString((boolean)lbl.isVisible());
        String enabled = StringParsing.boolToString((boolean)lbl.isEnabled());
        map.put("CompSystem.Text", text);
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    protected Map getCLabelValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        CLabel clbl = (CLabel)widget;
        String text = StringParsing.singleQuoteText((String)clbl.getText());
        text = SwtUtils.removeMnemonics(text);
        String hasFocus = StringParsing.boolToString((boolean)clbl.isFocusControl());
        String exists = StringParsing.boolToString((boolean)clbl.isVisible());
        String enabled = StringParsing.boolToString((boolean)clbl.isEnabled());
        map.put("CompSystem.Text", text);
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    protected Map getTreeValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        Tree tre = (Tree)widget;
        if (tre.getSelectionCount() != 0) {
            TreeItem[] entries = tre.getSelection();
            String treText = "";
            int i = 0;
            while (i < entries.length) {
                String node = StringParsing.maskAndSingleQuoteText((String)entries[i].getText(), (int)2);
                treText = treText.concat(node);
                if (i < entries.length - 1) {
                    treText = treText.concat(",");
                }
                ++i;
            }
            String textpath = this.m_recordHelperSWT.getTreePath((Widget)entries[0]);
            this.m_recordHelperSWT.setTreePath("");
            String existNode = "true";
            String column = new Integer(1).toString();
            map.put("CompSystem.Text", treText);
            map.put("CompSystem.TextPath", textpath);
            map.put("CompSystem.Exists", existNode);
            map.put("CompSystem.Column", column);
        }
        String preascend = "0";
        String hasFocus = StringParsing.boolToString((boolean)tre.isFocusControl());
        String exists = StringParsing.boolToString((boolean)tre.isVisible());
        String enabled = StringParsing.boolToString((boolean)tre.isEnabled());
        map.put("CompSystem.PreAscend", preascend);
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    protected Map getListValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        List lst = (List)widget;
        if (lst.getSelectionCount() != 0) {
            String[] entries = lst.getSelection();
            String lstText = "";
            int i = 0;
            while (i < entries.length) {
                String item = StringParsing.maskAndSingleQuoteText((String)entries[i].toString(), (int)1);
                lstText = lstText.concat(item);
                if (i < entries.length - 1) {
                    lstText = lstText.concat(",");
                }
                ++i;
            }
            String entryExists = "true";
            if (lst.getItemCount() == 0) {
                entryExists = "false";
            }
            String isSel = "true";
            map.put("CompSystem.IsSelected", isSel);
            map.put("CompSystem.Text", lstText);
            map.put("CompSystem.Exists", entryExists);
        }
        String hasFocus = StringParsing.boolToString((boolean)lst.isFocusControl());
        String exists = StringParsing.boolToString((boolean)lst.isVisible());
        String enabled = StringParsing.boolToString((boolean)lst.isEnabled());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    protected Map getComboValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        Combo cbx = (Combo)widget;
        if (cbx.getSelectionIndex() != -1) {
            String cbxText = StringParsing.singleQuoteText((String)cbx.getItem(cbx.getSelectionIndex()).toString());
            map.put("CompSystem.Text", cbxText);
        }
        String hasFocus = StringParsing.boolToString((boolean)cbx.isFocusControl());
        String exists = StringParsing.boolToString((boolean)cbx.isVisible());
        String enabled = StringParsing.boolToString((boolean)cbx.isEnabled());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    protected Map getCComboValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        CCombo ccbx = (CCombo)widget;
        if (ccbx.getSelectionIndex() != -1) {
            String ccbxText = StringParsing.singleQuoteText((String)ccbx.getItem(ccbx.getSelectionIndex()).toString());
            map.put("CompSystem.Text", ccbxText);
        }
        String hasFocus = StringParsing.boolToString((boolean)ccbx.isFocusControl());
        String exists = StringParsing.boolToString((boolean)ccbx.isVisible());
        String enabled = StringParsing.boolToString((boolean)ccbx.isEnabled());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    protected Map getTabFolderValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        TabFolder tp = (TabFolder)widget;
        String title = StringParsing.singleQuoteText((String)tp.getItem(tp.getSelectionIndex()).getText());
        title = SwtUtils.removeMnemonics(title);
        String isSel = "true";
        map.put("CompSystem.IsSelected", isSel);
        map.put("CompSystem.Title", title);
        map.put("CompSystem.Tab", title);
        String hasFocus = StringParsing.boolToString((boolean)tp.isFocusControl());
        String exists = StringParsing.boolToString((boolean)tp.isVisible());
        String enabled = StringParsing.boolToString((boolean)tp.isEnabled());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    protected Map getCTabFolderValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        CTabFolder ctp = (CTabFolder)widget;
        if (ctp.getSelection() != null) {
            String title = StringParsing.singleQuoteText((String)ctp.getSelection().getText());
            title = SwtUtils.removeMnemonics(title);
            String isSel = "true";
            map.put("CompSystem.IsSelected", isSel);
            map.put("CompSystem.Title", title);
            map.put("CompSystem.Tab", title);
        }
        String hasFocus = StringParsing.boolToString((boolean)ctp.isFocusControl());
        String exists = StringParsing.boolToString((boolean)ctp.isVisible());
        String enabled = StringParsing.boolToString((boolean)ctp.isEnabled());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    protected Map getTableValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        Table tbl = (Table)widget;
        if (tbl.getSelectionCount() != 0) {
            Cell cell = TableSelectionTracker.getInstance().getSelectedCell(tbl);
            String tblText = StringParsing.singleQuoteText((String)tbl.getItem(cell.getRow()).getText(cell.getCol()));
            String rowStr = new Integer(cell.getRow() + 1).toString();
            String columnStr = new Integer(cell.getCol() + 1).toString();
            map.put("CompSystem.Text", tblText);
            map.put("CompSystem.TextOperator", "equals");
            map.put("CompSystem.CellValue", tblText);
            map.put("CompSystem.ValueOperator", "equals");
            map.put("CompSystem.Row", rowStr);
            map.put("CompSystem.RowOperator", "equals");
            map.put("CompSystem.Column", columnStr);
            map.put("CompSystem.ColumnOperator", "equals");
        }
        String hasFocus = StringParsing.boolToString((boolean)tbl.isFocusControl());
        String exists = StringParsing.boolToString((boolean)tbl.isVisible());
        String enabled = StringParsing.boolToString((boolean)tbl.isEnabled());
        this.addFocExistEnbl(map, hasFocus, exists, enabled);
        return map;
    }

    protected Map getToolItemValues(Widget widget) {
        HashMap<String, String> map = new HashMap<String, String>();
        ToolItem ti = (ToolItem)widget;
        String toolText = StringParsing.singleQuoteText((String)ti.getText());
        toolText = SwtUtils.removeMnemonics(toolText);
        String selected = StringParsing.boolToString((boolean)ti.getSelection());
        map.put("CompSystem.Text", toolText);
        map.put("CompSystem.IsSelected", selected);
        String enabled = StringParsing.boolToString((boolean)ti.isEnabled());
        map.put("CompSystem.IsEnabled", enabled);
        return map;
    }
}

