/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.util;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.tools.utils.StringParsing;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class SimulatedTooltip
extends Thread {
    private static AutServerLogger log = new AutServerLogger(SimulatedTooltip.class);
    private static final String TOOLTIP_FONT = "MS Mincho";
    private static final Color TOOLTIP_BG_COLOR = new Color(null, 255, 255, 231);
    private static final Color PROGRESSBAR_BG_COLOR = new Color(null, 255, 255, 220);
    private static final Color PROGRESSBAR_FG_COLOR = new Color(null, 0, 0, 0);
    private static final int P_HEIGHT = 4;
    private final Shell m_dialog = new Shell(16384);
    private final int m_dialogWidth;
    private int m_dialogHeight;
    private final int m_textSize;
    private final int m_timeout;
    private final Rectangle m_componentBounds;
    private final String m_displayText;
    private final Label m_label;

    public SimulatedTooltip(int timePerWord, String popupText, int dialogWidth, int textSize, Rectangle componentBounds) {
        this.m_dialog.setBackground(TOOLTIP_BG_COLOR);
        this.m_dialog.setText("Information");
        this.m_textSize = textSize;
        this.m_timeout = StringParsing.countWords((String)popupText) * timePerWord;
        this.m_displayText = popupText;
        this.m_dialogWidth = dialogWidth;
        this.m_label = new Label((Composite)this.m_dialog, 64);
        this.m_componentBounds = componentBounds;
    }

    public void run() {
        log.debug((Object)(String.valueOf(Thread.currentThread().toString()) + ": managing started"));
        EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
        queuer.invokeAndWait("openSimulatedTooltipShell", new IRunnable(){

            public Object run() {
                log.debug((Object)(String.valueOf(Thread.currentThread().toString()) + ": popup started"));
                SimulatedTooltip.this.openShell();
                return null;
            }
        });
        TimeUtil.delay((long)this.m_timeout);
        queuer.invokeAndWait("disposeSimulatedTooltipShell", new IRunnable(){

            public Object run() {
                if (SimulatedTooltip.this.m_dialog != null && !SimulatedTooltip.this.m_dialog.isDisposed()) {
                    SimulatedTooltip.this.m_dialog.dispose();
                    log.debug((Object)(String.valueOf(Thread.currentThread().toString()) + ": popup stopped"));
                }
                return null;
            }
        });
        log.debug((Object)(String.valueOf(Thread.currentThread().toString()) + ": managing stopped"));
    }

    public void openShell() {
        GridLayout gl = new GridLayout();
        this.m_dialog.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.m_dialog.setLayoutData((Object)gd);
        this.m_dialog.setBounds(100, 100, 200, 0);
        this.m_dialog.open();
        this.m_dialog.setVisible(false);
        this.createText();
        this.createProgressBar();
        this.m_dialog.setSize(this.m_dialogWidth, 1000);
        int margins = this.m_label.getLocation().y * 4;
        this.m_dialog.setSize(this.m_dialogWidth, this.m_label.getSize().y + 4 + margins);
        this.m_dialogHeight = this.m_dialog.getBounds().height;
        this.setLocation();
        this.m_dialog.setVisible(true);
    }

    public void createText() {
        Font font1 = new Font((Device)this.m_dialog.getDisplay(), TOOLTIP_FONT, this.m_textSize, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.m_label.setLayoutData((Object)gd);
        this.m_label.setFont(font1);
        this.m_label.setBackground(TOOLTIP_BG_COLOR);
        this.m_label.setText(this.m_displayText);
    }

    public void setLocation() {
        int cWidth = this.m_componentBounds.width;
        int cHeight = this.m_componentBounds.height;
        int x = this.m_componentBounds.x + cWidth;
        int y = this.m_componentBounds.y + cHeight;
        Rectangle bounds = Display.getDefault().getBounds();
        int screenWidth = bounds.width;
        int screenHeight = bounds.height;
        int xOffset = 1;
        int yOffset = 1;
        int xMin = 5 + xOffset;
        int yMin = 5 + yOffset;
        x = x + this.m_dialogWidth + xMin >= screenWidth ? x - this.m_dialogWidth - xOffset - cWidth : (x += xOffset);
        y = y + this.m_dialogHeight + yMin >= screenHeight ? y - this.m_dialogHeight - yOffset - cHeight : (y += yOffset);
        this.m_dialog.setLocation(x, y);
    }

    public void createProgressBar() {
        final ProgressBar bar = new ProgressBar((Composite)this.m_dialog, 256);
        GridData gd = new GridData();
        gd.heightHint = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        bar.setLayoutData((Object)gd);
        bar.setForeground(PROGRESSBAR_FG_COLOR);
        bar.setBackground(PROGRESSBAR_BG_COLOR);
        bar.setMaximum(this.m_timeout);
        final int maximum = bar.getMaximum();
        Thread progressBarThread = new Thread(){

            public void run() {
                int refreshIntervall = 25;
                int times = Math.round(SimulatedTooltip.this.m_timeout / refreshIntervall) - 1;
                int increment = Math.round(maximum / times) + 1;
                final int[] i = new int[1];
                while (i[0] <= maximum) {
                    TimeUtil.delay((long)refreshIntervall);
                    if (SimulatedTooltip.this.m_dialog != null && SimulatedTooltip.this.m_dialog.getDisplay().isDisposed()) {
                        return;
                    }
                    SimulatedTooltip.this.m_dialog.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (bar.isDisposed()) {
                                return;
                            }
                            bar.setSelection(i[0]);
                        }
                    });
                    i[0] = i[0] + increment;
                }
            }
        };
        progressBarThread.start();
    }
}

