/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class WARProductUtil {
    public static IPath getAbsolutLibraryPath(IPath libPath, IWARProduct product) {
        IPath result = null;
        boolean fromTarget = product.isLibraryFromTarget(libPath);
        if (fromTarget) {
            String absoluteBridgePath = WARProductUtil.getServletBridgeAbsolutePath();
            if (absoluteBridgePath != null && absoluteBridgePath.indexOf(libPath.toPortableString()) != -1) {
                result = new Path(absoluteBridgePath);
            }
        } else {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile lib = root.getFile(libPath);
            result = lib.getLocation();
        }
        return result;
    }

    public static void addServletBridgeFromTarget(IWARProduct product) {
        String path = WARProductUtil.getServletBridgeAbsolutePath();
        if (path != null) {
            Path absolutePath = new Path(path);
            Path relativePath = new Path(absolutePath.lastSegment());
            product.addLibrary((IPath)relativePath, true);
        }
    }

    private static String getServletBridgeAbsolutePath() {
        String result = null;
        ModelEntry entry = PluginRegistry.findEntry((String)"org.eclipse.equinox.servletbridge");
        if (entry != null) {
            IPluginModelBase[] targetModels = entry.getExternalModels();
            int i = 0;
            while (i < targetModels.length && result == null) {
                IPluginModelBase bridgeModel = targetModels[i];
                String libLocation = bridgeModel.getInstallLocation();
                if (libLocation != null && libLocation.toLowerCase().indexOf(".jar") != -1) {
                    result = libLocation;
                }
                ++i;
            }
        }
        return result;
    }
}

