/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.rpmstubby.AbstractGenerator;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.model.FeatureModel;
import org.eclipse.linuxtools.rpmstubby.RPMStubbyUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class StubbyGenerator
extends AbstractGenerator {
    private FeatureModel model;
    private IFile featureFile;
    private boolean pomExists;

    public StubbyGenerator(IFile featureFile) {
        this.featureFile = featureFile;
        this.parse(featureFile);
        this.specfileName = String.valueOf(this.model.getPackageName().toLowerCase()) + ".spec";
        this.projectName = featureFile.getProject().getName();
        this.pomExists = new RPMStubbyUtils().findPom(featureFile.getParent().getLocation());
    }

    private void parse(IFile featureFile) {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        IPath featureDir = featureFile.getLocation().removeLastSegments(1);
        String featurePropertiesFile = String.valueOf(featureDir.toOSString()) + "/feature.properties";
        Properties featureProperties = new Properties();
        try {
            featureProperties.load(new FileInputStream(featurePropertiesFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
        try {
            DocumentBuilder docbuilder = docfactory.newDocumentBuilder();
            Document docroot = docbuilder.parse(featureFile.getContents());
            this.model = new FeatureModel(docroot, featureProperties);
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
            StubbyLog.logError(e);
        }
    }

    @Override
    public String generateSpecfile() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("%global install_loc    %{_datadir}/eclipse/dropins/" + this.model.getSimplePackageName() + "\n\n");
        buffer.append("Name:           " + this.model.getPackageName().toLowerCase() + "\n");
        buffer.append("Version:        " + this.model.getVersion() + "\n");
        buffer.append("Release:        1%{?dist}\n");
        buffer.append("Summary:        " + this.model.getSummary() + "\n\n");
        buffer.append("Group:          Development/Tools\n");
        buffer.append("License:        " + this.model.getLicense() + "\n");
        buffer.append("URL:            " + this.model.getURL() + "\n");
        buffer.append("Source0:        #FIXME\n");
        buffer.append("BuildArch:      noarch\n\n");
        StubbyGenerator.generateRequires(buffer);
        buffer.append("%description\n" + this.model.getDescription() + "\n");
        StubbyGenerator.generatePrepSection(buffer);
        this.generateBuildSection(buffer);
        this.generateInstallSection(buffer);
        this.generateFilesSections(buffer);
        StubbyGenerator.generateChangelog(buffer);
        return buffer.toString();
    }

    private static void generateRequires(StringBuilder buffer) {
        buffer.append("Requires:       eclipse-platform >= 3.4.0\n");
        buffer.append("BuildRequires:  maven-local\n");
        buffer.append("\n\n");
    }

    private void generateInstallSection(StringBuilder buffer) {
        buffer.append("%install\n");
        if (!this.pomExists) {
            StubbyGenerator.generateTempPom(buffer);
        }
        buffer.append("mvn-rpmbuild ");
        if (!this.pomExists) {
            buffer.append("-f temp/pom.xml ");
        }
        buffer.append("org.fedoraproject:feclipse-maven-plugin:install \\\n");
        buffer.append("\t-DsourceRepo=#FIXME \\\n");
        buffer.append("\t-DtargetLocation=%{buildroot}%{install_loc}/eclipse\n");
        buffer.append("\n\n");
    }

    private void generateFilesSections(StringBuilder buffer) {
        String[] files;
        buffer.append("%files\n");
        buffer.append("%{install_loc}\n");
        String docsRoot = this.featureFile.getLocation().removeLastSegments(1).lastSegment();
        String[] stringArray = files = this.featureFile.getLocation().removeLastSegments(1).toFile().list();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.matches("(epl-.*|license)\\.html")) {
                buffer.append("%doc " + docsRoot + "/" + file + "\n");
            }
            ++n2;
        }
        buffer.append("\n\n");
    }

    private static void generatePrepSection(StringBuilder buffer) {
        buffer.append("\n%prep\n");
        buffer.append("%setup -q #You may need to update this according to your Source0\n");
        buffer.append("\n\n");
    }

    private void generateBuildSection(StringBuilder buffer) {
        buffer.append("%build\n");
        if (!this.pomExists) {
            StubbyGenerator.generateTempPom(buffer);
        }
        buffer.append("mvn-rpmbuild ");
        if (!this.pomExists) {
            buffer.append("-f temp/pom.xml ");
        }
        buffer.append("install\n");
        buffer.append("\n\n");
    }

    public String getPackageName(String packageName) {
        String[] packageItems = packageName.split("\\.");
        String name = packageItems[packageItems.length - 1];
        if (name.equalsIgnoreCase("feature")) {
            name = packageItems[packageItems.length - 2];
        }
        return "eclipse-" + name;
    }

    private static void generateTempPom(StringBuilder buffer) {
        buffer.append("mkdir temp\n");
        buffer.append("pushd temp\n");
        buffer.append("cat > pom.xml << EOF\n");
        buffer.append("<project>\n");
        buffer.append("    <modelVersion>4.0.0</modelVersion>\n");
        buffer.append("    <name>Maven Default Project</name>\n");
        buffer.append("    <groupId>org.fedoraproject</groupId>\n");
        buffer.append("    <artifactId>dummy</artifactId>\n");
        buffer.append("    <version>1.0.0</version>\n");
        buffer.append("</project>\n");
        buffer.append("EOF\n");
        buffer.append("popd\n");
    }
}

