/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="collections_grouped_by_size")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
public class CollectionsBySizeQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String size_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.CollectionsBySizeQuery_CollectingSizes);
        HashMapIntObject metadata = new HashMapIntObject();
        for (CollectionUtil.Info info : CollectionUtil.getKnownCollections(this.snapshot)) {
            Collection<IClass> classes;
            if (!info.hasSize() || (classes = this.snapshot.getClassesByName(info.getClassName(), true)) == null) continue;
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), (Object)info);
            }
        }
        if (this.collection != null) {
            CollectionUtil.Info info;
            if (this.size_attribute == null) {
                String msg = Messages.CollectionsBySizeQuery_ErrorMsg_ArgumentMissing;
                throw new SnapshotException(msg);
            }
            info = new CollectionUtil.Info(this.collection, this.size_attribute, null);
            Collection<IClass> classes = this.snapshot.getClassesByName(this.collection, true);
            if (classes == null) {
                classes = Collections.emptySet();
            }
            if (classes.isEmpty()) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.CollectionsBySizeQuery_ClassNotFound, (Object[])new Object[]{this.collection}), null);
            }
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), (Object)info);
            }
        }
        Quantize.Builder builder = Quantize.valueDistribution((Column[])new Column[]{new Column(Messages.CollectionsBySizeQuery_Column_Length, Integer.TYPE)});
        builder.column(Messages.CollectionsBySizeQuery_Column_NumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_LONG, Column.SortDirection.DESC);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        Iterator<IClass> iterator = this.objects.iterator();
        block5: while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                CollectionUtil.Info info = (CollectionUtil.Info)metadata.get(this.snapshot.getClassOf(objectId).getObjectId());
                if (info != null) {
                    IObject obj = this.snapshot.getObject(objectId);
                    try {
                        int size = info.getSize(obj);
                        quantize.addValue(objectId, new Object[]{size, null, obj.getUsedHeapSize()});
                    }
                    catch (SnapshotException e) {
                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.CollectionsBySizeQuery_IgnoringCollection, (Object[])new Object[]{obj.getTechnicalName()}), (Throwable)e);
                    }
                }
                if (listener.isCanceled()) break block5;
                ++n2;
            }
        }
        return quantize.getResult();
    }
}

