/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot.inspections;

import com.ibm.icu.text.DecimalFormat;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

@CommandName(value="dominator_tree")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/dominator_tree.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/concepts/dominatortree.html")
public class DominatorQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false)
    public Grouping groupBy = Grouping.NONE;

    public Tree execute(IProgressListener listener) throws Exception {
        this.snapshot.getTopAncestorsInDominatorTree(new int[0], listener);
        return this.create(new int[]{-1}, listener);
    }

    protected Tree create(int[] roots, IProgressListener listener) throws SnapshotException {
        if (this.groupBy == null) {
            this.groupBy = Grouping.NONE;
        }
        switch (this.groupBy) {
            case NONE: {
                return Factory.create(this.snapshot, roots, listener);
            }
            case BY_CLASS: {
                return Factory.groupByClass(this.snapshot, roots, listener);
            }
            case BY_CLASSLOADER: {
                return Factory.groupByClassLoader(this.snapshot, roots, listener);
            }
            case BY_PACKAGE: {
                return Factory.groupByPackage(this.snapshot, roots, listener);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassLoaderTree
    extends Tree
    implements IIconProvider {
        private List<?> classLoader;

        static List<?> prepareSet(ISnapshot snapshot, int[] roots, IProgressListener listener) throws SnapshotException {
            HashMapIntObject classLoader2node = new HashMapIntObject();
            int ii = 0;
            while (ii < roots.length) {
                int clId;
                int dominatedId = roots[ii];
                if (snapshot.isClass(dominatedId)) {
                    IClass cl = (IClass)snapshot.getObject(dominatedId);
                    clId = cl.getClassLoaderId();
                } else {
                    clId = snapshot.isClassLoader(dominatedId) ? dominatedId : snapshot.getClassOf(dominatedId).getClassLoaderId();
                }
                GroupedNode node = (GroupedNode)classLoader2node.get(clId);
                if (node == null) {
                    node = new GroupedNode(clId, null, null);
                    IObject cl = snapshot.getObject(clId);
                    node.label = cl.getClassSpecificName();
                    if (node.label == null) {
                        node.label = cl.getTechnicalName();
                    }
                    classLoader2node.put(clId, (Object)node);
                }
                node.objects.add(dominatedId);
                node.shallowHeap += snapshot.getHeapSize(dominatedId);
                node.retainedHeap += snapshot.getRetainedHeapSize(dominatedId);
                if (ii % 100 == 0 && listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                ++ii;
            }
            return Arrays.asList(classLoader2node.getAllValues());
        }

        static List<?> prepare(ISnapshot snapshot, IProgressListener listener) throws SnapshotException {
            return ClassLoaderTree.prepareSet(snapshot, snapshot.getImmediateDominatedIds(-1), listener);
        }

        private ClassLoaderTree(ISnapshot snapshot, int[] roots, List<?> classLoader) {
            super(snapshot, roots, Grouping.BY_CLASSLOADER);
            this.classLoader = classLoader;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassLoaderName, String.class), new Column(Messages.Column_Objects, Integer.TYPE), new Column(Messages.Column_ShallowHeap, Integer.TYPE), new Column(Messages.Column_RetainedHeap, Long.TYPE).sorting(Column.SortDirection.DESC), new Column(Messages.Column_Percentage, Double.TYPE).formatting((Format)new DecimalFormat("0.00%"))};
        }

        public List<?> getElements() {
            return this.classLoader;
        }

        public boolean hasChildren(Object element) {
            return element instanceof GroupedNode;
        }

        public List<?> getChildren(Object parent) {
            if (parent instanceof ClassNode) {
                return this.objects((ClassNode)parent);
            }
            if (parent instanceof GroupedNode) {
                return this.histogram(((GroupedNode)parent).objects);
            }
            return null;
        }

        private List<Node> objects(ClassNode parent) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            IteratorInt iter = parent.objects.iterator();
            while (iter.hasNext()) {
                nodes.add(new Node(iter.next()));
            }
            return nodes;
        }

        private List<?> histogram(ArrayInt objectIds) {
            try {
                HashMapIntObject class2node = new HashMapIntObject();
                int ii = 0;
                while (ii < objectIds.size()) {
                    int objectId = objectIds.get(ii);
                    IClass clazz = this.snapshot.getClassOf(objectId);
                    ClassNode node = (ClassNode)class2node.get(clazz.getObjectId());
                    if (node == null) {
                        node = new ClassNode(clazz.getObjectId());
                        node.label = clazz.getName();
                        class2node.put(node.objectId, (Object)node);
                    }
                    node.objects.add(objectId);
                    node.shallowHeap += this.snapshot.getHeapSize(objectId);
                    node.retainedHeap += this.snapshot.getRetainedHeapSize(objectId);
                    ++ii;
                }
                return Arrays.asList(class2node.getAllValues());
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        public Object getColumnValue(Object row, int columnIndex) {
            try {
                Node node = (Node)row;
                switch (columnIndex) {
                    case 0: {
                        if (node.label == null) {
                            IObject obj = this.snapshot.getObject(node.objectId);
                            node.label = obj.getDisplayName();
                        }
                        return node.label;
                    }
                    case 1: {
                        return node instanceof GroupedNode ? Integer.valueOf(((GroupedNode)node).objects.size()) : null;
                    }
                    case 2: {
                        if (node.shallowHeap == -1L) {
                            node.shallowHeap = this.snapshot.getHeapSize(node.objectId);
                        }
                        return node.shallowHeap;
                    }
                    case 3: {
                        if (node.retainedHeap == -1L) {
                            node.retainedHeap = this.snapshot.getRetainedHeapSize(node.objectId);
                        }
                        return node.retainedHeap;
                    }
                    case 4: {
                        if (node.retainedHeap == -1L) {
                            node.retainedHeap = this.snapshot.getRetainedHeapSize(node.objectId);
                        }
                        return (double)node.retainedHeap / this.totalHeap;
                    }
                }
                return null;
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        public IContextObject getContext(final Object row) {
            if (row instanceof GroupedNode) {
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return ((Node)row).objectId;
                    }

                    public int[] getObjectIds() {
                        return ((GroupedNode)row).objects.toArray();
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
            return new IContextObject(){

                public int getObjectId() {
                    return ((Node)row).objectId;
                }
            };
        }

        public URL getIcon(Object row) {
            if (row instanceof ClassNode) {
                return Icons.CLASS;
            }
            return Icons.forObject(this.snapshot, ((Node)row).objectId);
        }
    }

    private static class ClassNode
    extends GroupedNode {
        private ClassNode(int objectId) {
            super(objectId);
            this.shallowHeap = 0L;
            this.retainedHeap = 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassTree
    extends Tree
    implements IIconProvider {
        private List<ClassNode> elements;

        public static List<ClassNode> prepare(ISnapshot snapshot, int[] objectIds, IProgressListener listener) {
            try {
                HashMapIntObject class2node = new HashMapIntObject();
                int ii = 0;
                while (ii < objectIds.length) {
                    int[] dominatedIds = snapshot.getImmediateDominatedIds(objectIds[ii]);
                    int jj = 0;
                    while (jj < dominatedIds.length) {
                        int objectId = dominatedIds[jj];
                        IClass clazz = snapshot.getClassOf(objectId);
                        ClassNode node = (ClassNode)class2node.get(clazz.getObjectId());
                        if (node == null) {
                            node = new ClassNode(clazz.getObjectId());
                            node.label = clazz.getName();
                            class2node.put(node.objectId, (Object)node);
                        }
                        node.objects.add(objectId);
                        node.shallowHeap += snapshot.getHeapSize(objectId);
                        node.retainedHeap += snapshot.getRetainedHeapSize(objectId);
                        if (listener.isCanceled()) {
                            throw new IProgressListener.OperationCanceledException();
                        }
                        ++jj;
                    }
                    ++ii;
                }
                return Arrays.asList((ClassNode[])class2node.getAllValues((Object[])new ClassNode[0]));
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        public static List<ClassNode> prepareSet(ISnapshot snapshot, int[] roots, IProgressListener listener) {
            try {
                HashMapIntObject class2node = new HashMapIntObject();
                int jj = 0;
                while (jj < roots.length) {
                    int objectId = roots[jj];
                    IClass clazz = snapshot.getClassOf(objectId);
                    ClassNode node = (ClassNode)class2node.get(clazz.getObjectId());
                    if (node == null) {
                        node = new ClassNode(clazz.getObjectId());
                        node.label = clazz.getName();
                        class2node.put(node.objectId, (Object)node);
                    }
                    node.objects.add(objectId);
                    node.shallowHeap += snapshot.getHeapSize(objectId);
                    node.retainedHeap += snapshot.getRetainedHeapSize(objectId);
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    ++jj;
                }
                return Arrays.asList((ClassNode[])class2node.getAllValues((Object[])new ClassNode[0]));
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        private ClassTree(ISnapshot snapshot, int[] roots, List<ClassNode> elements) {
            super(snapshot, roots, Grouping.BY_CLASS);
            this.elements = elements;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName, String.class), new Column(Messages.Column_Objects, Integer.TYPE), new Column(Messages.Column_ShallowHeap, Integer.TYPE), new Column(Messages.Column_RetainedHeap, Long.TYPE).sorting(Column.SortDirection.DESC), new Column(Messages.Column_Percentage, Double.TYPE).formatting((Format)new DecimalFormat("0.00%"))};
        }

        public List<?> getElements() {
            return this.elements;
        }

        public boolean hasChildren(Object element) {
            return true;
        }

        public List<?> getChildren(Object parent) {
            return ClassTree.prepare(this.snapshot, ((GroupedNode)parent).objects.toArray(), (IProgressListener)new VoidProgressListener());
        }

        public Object getColumnValue(Object row, int columnIndex) {
            ClassNode node = (ClassNode)row;
            switch (columnIndex) {
                case 0: {
                    return node.label;
                }
                case 1: {
                    return node.objects.size();
                }
                case 2: {
                    return node.shallowHeap;
                }
                case 3: {
                    return node.retainedHeap;
                }
                case 4: {
                    return (double)node.retainedHeap / this.totalHeap;
                }
            }
            return null;
        }

        public IContextObject getContext(final Object row) {
            return new IContextObjectSet(){

                public int getObjectId() {
                    return ((ClassNode)row).objectId;
                }

                public int[] getObjectIds() {
                    return ((ClassNode)row).objects.toArray();
                }

                public String getOQL() {
                    return null;
                }
            };
        }

        public URL getIcon(Object row) {
            return Icons.CLASS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTree
    extends Tree
    implements IIconProvider,
    IDecorator {
        private List<Node> elements;

        static List<Node> prepareSet(ISnapshot snapshot, int[] roots, IProgressListener listener) throws SnapshotException {
            ArrayList<Node> nodes = new ArrayList<Node>();
            int ii = 0;
            while (ii < roots.length) {
                Node node = new Node(roots[ii]);
                node.retainedHeap = snapshot.getRetainedHeapSize(roots[ii]);
                nodes.add(node);
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                ++ii;
            }
            Collections.sort(nodes, new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return o1.retainedHeap < o2.retainedHeap ? 1 : (o1.retainedHeap == o2.retainedHeap ? 0 : -1);
                }
            });
            return nodes;
        }

        static List<Node> prepare(ISnapshot snapshot, int id, IProgressListener listener) {
            int[] objectIds;
            block5: {
                objectIds = snapshot.getImmediateDominatedIds(id);
                if (objectIds != null) break block5;
                return null;
            }
            try {
                ArrayList<Node> nodes = new ArrayList<Node>(objectIds.length);
                int ii = 0;
                while (ii < objectIds.length) {
                    nodes.add(new Node(objectIds[ii]));
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    ++ii;
                }
                return nodes;
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        private DefaultTree(ISnapshot snapshot, int[] roots, List<Node> elements) {
            super(snapshot, roots, Grouping.NONE);
            this.elements = elements;
        }

        @Override
        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().setIsPreSortedBy(2, Column.SortDirection.DESC).build();
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName, String.class).decorator((IDecorator)this), new Column(Messages.Column_ShallowHeap, Integer.TYPE).noTotals(), new Column(Messages.Column_RetainedHeap, Long.TYPE).noTotals(), new Column(Messages.Column_Percentage, Double.TYPE).formatting((Format)new DecimalFormat("0.00%")).noTotals()};
        }

        public List<?> getElements() {
            return this.elements;
        }

        public boolean hasChildren(Object element) {
            return true;
        }

        public List<?> getChildren(Object parent) {
            return DefaultTree.prepare(this.snapshot, ((Node)parent).objectId, (IProgressListener)new VoidProgressListener());
        }

        public Object getColumnValue(Object row, int columnIndex) {
            try {
                Node node = (Node)row;
                switch (columnIndex) {
                    case 0: {
                        if (node.label == null) {
                            IObject obj = this.snapshot.getObject(node.objectId);
                            node.label = obj.getDisplayName();
                        }
                        return node.label;
                    }
                    case 1: {
                        if (node.shallowHeap == -1L) {
                            node.shallowHeap = this.snapshot.getHeapSize(node.objectId);
                        }
                        return node.shallowHeap;
                    }
                    case 2: {
                        if (node.retainedHeap == -1L) {
                            node.retainedHeap = this.snapshot.getRetainedHeapSize(node.objectId);
                        }
                        return node.retainedHeap;
                    }
                    case 3: {
                        if (node.retainedHeap == -1L) {
                            node.retainedHeap = this.snapshot.getRetainedHeapSize(node.objectId);
                        }
                        return (double)node.retainedHeap / this.totalHeap;
                    }
                }
                return null;
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        public IContextObject getContext(final Object row) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((Node)row).objectId;
                }
            };
        }

        public URL getIcon(Object row) {
            return Icons.forObject(this.snapshot, ((Node)row).objectId);
        }

        public String prefix(Object row) {
            return null;
        }

        public String suffix(Object row) {
            try {
                Node node = (Node)row;
                GCRootInfo[] roots = this.snapshot.getGCRootInfo(node.objectId);
                return roots == null ? null : GCRootInfo.getTypeSetAsString(roots);
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Factory {
        public static Tree create(ISnapshot snapshot, int[] roots, IProgressListener listener) throws SnapshotException {
            List<Node> elements = roots.length == 1 && roots[0] == -1 ? DefaultTree.prepare(snapshot, roots[0], listener) : DefaultTree.prepareSet(snapshot, roots, listener);
            return new DefaultTree(snapshot, roots, elements);
        }

        public static Tree groupByClass(ISnapshot snapshot, int[] roots, IProgressListener listener) {
            List<ClassNode> elements = roots.length == 1 && roots[0] == -1 ? ClassTree.prepare(snapshot, roots, listener) : ClassTree.prepareSet(snapshot, roots, listener);
            return new ClassTree(snapshot, roots, elements);
        }

        public static Tree groupByClassLoader(ISnapshot snapshot, int[] roots, IProgressListener listener) throws SnapshotException {
            List<?> classloader = roots.length == 1 && roots[0] == -1 ? ClassLoaderTree.prepare(snapshot, listener) : ClassLoaderTree.prepareSet(snapshot, roots, listener);
            return new ClassLoaderTree(snapshot, roots, classloader);
        }

        public static Tree groupByPackage(ISnapshot snapshot, int[] roots, IProgressListener listener) throws SnapshotException {
            PackageNode rootNode = roots.length == 1 && roots[0] == -1 ? PackageTree.prepare(snapshot, listener) : PackageTree.prepareSet(snapshot, roots, listener);
            return new PackageTree(snapshot, roots, rootNode);
        }
    }

    private static class GroupedNode
    extends Node {
        ArrayInt objects = new ArrayInt();

        private GroupedNode(int objectId) {
            super(objectId);
        }

        /* synthetic */ GroupedNode(int n, GroupedNode groupedNode, GroupedNode groupedNode2) {
            this(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Grouping {
        NONE(Messages.DominatorQuery_Group_None, Icons.OBJECT_INSTANCE),
        BY_CLASS(Messages.DominatorQuery_Group_ByClass, Icons.CLASS),
        BY_CLASSLOADER(Messages.DominatorQuery_Group_ByClassLoader, Icons.CLASSLOADER_INSTANCE),
        BY_PACKAGE(Messages.DominatorQuery_Group_ByPackage, Icons.PACKAGE);

        String label;
        URL icon;

        private Grouping(String label, URL icon) {
            this.label = label;
            this.icon = icon;
        }

        public URL getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.label;
        }
    }

    private static class Node {
        int objectId;
        String label;
        long shallowHeap;
        long retainedHeap;

        public Node(int objectId) {
            this.objectId = objectId;
            this.shallowHeap = -1L;
            this.retainedHeap = -1L;
        }
    }

    private static class PackageNode
    extends GroupedNode {
        Map<String, PackageNode> subPackages = new HashMap<String, PackageNode>();

        private PackageNode(String label) {
            super(-1);
            this.label = label;
            this.shallowHeap = 0L;
            this.retainedHeap = 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageTree
    extends Tree
    implements IIconProvider {
        private PackageNode invisibleRoot;

        public static PackageNode prepare(ISnapshot snapshot, IProgressListener listener) throws SnapshotException {
            return PackageTree.prepareSet(snapshot, snapshot.getImmediateDominatedIds(-1), listener);
        }

        public static PackageNode prepareSet(ISnapshot snapshot, int[] roots, IProgressListener listener) throws SnapshotException {
            PackageNode root = new PackageNode(Messages.DominatorQuery_LabelAll);
            listener.beginTask(Messages.DominatorQuery_Msg_Grouping, roots.length / 100);
            int index = 0;
            int[] nArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                int dominatorId = nArray[n2];
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                long retainedHeap = snapshot.getRetainedHeapSize(dominatorId);
                long shallowHeap = snapshot.getHeapSize(dominatorId);
                PackageNode current = root;
                IClass objClass = snapshot.isClass(dominatorId) ? (IClass)snapshot.getObject(dominatorId) : snapshot.getClassOf(dominatorId);
                String className = objClass.getName();
                StringTokenizer tokenizer = new StringTokenizer(className, ".");
                while (tokenizer.hasMoreTokens()) {
                    String subpack = tokenizer.nextToken();
                    PackageNode childNode = current.subPackages.get(subpack);
                    if (childNode == null) {
                        childNode = new PackageNode(subpack);
                        current.subPackages.put(subpack, childNode);
                    }
                    childNode.objects.add(dominatorId);
                    childNode.retainedHeap += retainedHeap;
                    childNode.shallowHeap += shallowHeap;
                    current = childNode;
                }
                if (++index % 100 == 0) {
                    listener.worked(1);
                }
                ++n2;
            }
            listener.done();
            return root;
        }

        private PackageTree(ISnapshot snapshot, int[] roots, PackageNode invisibleRoot) {
            super(snapshot, roots, Grouping.BY_PACKAGE);
            this.invisibleRoot = invisibleRoot;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName, String.class), new Column(Messages.Column_Objects, Integer.TYPE), new Column(Messages.Column_ShallowHeap, Integer.TYPE), new Column(Messages.Column_RetainedHeap, Long.TYPE).sorting(Column.SortDirection.DESC), new Column(Messages.Column_Percentage, Double.TYPE).formatting((Format)new DecimalFormat("0.00%"))};
        }

        public List<?> getElements() {
            return new ArrayList<PackageNode>(this.invisibleRoot.subPackages.values());
        }

        public boolean hasChildren(Object element) {
            return !((PackageNode)element).subPackages.isEmpty();
        }

        public List<?> getChildren(Object parent) {
            return new ArrayList<PackageNode>(((PackageNode)parent).subPackages.values());
        }

        public Object getColumnValue(Object row, int columnIndex) {
            GroupedNode node = (GroupedNode)row;
            switch (columnIndex) {
                case 0: {
                    return node.label;
                }
                case 1: {
                    return node.objects.size();
                }
                case 2: {
                    return node.shallowHeap;
                }
                case 3: {
                    return node.retainedHeap;
                }
                case 4: {
                    return (double)node.retainedHeap / this.totalHeap;
                }
            }
            return null;
        }

        public IContextObject getContext(final Object row) {
            return new IContextObjectSet(){

                public int getObjectId() {
                    return ((Node)row).objectId;
                }

                public int[] getObjectIds() {
                    return ((GroupedNode)row).objects.toArray();
                }

                public String getOQL() {
                    return null;
                }
            };
        }

        public URL getIcon(Object row) {
            return ((PackageNode)row).subPackages.isEmpty() ? Icons.CLASS : Icons.PACKAGE;
        }
    }

    public static abstract class Tree
    implements IResultTree {
        protected ISnapshot snapshot;
        protected int[] roots;
        protected Grouping groupedBy;
        protected double totalHeap;

        public Tree(ISnapshot snapshot, int[] roots, Grouping groupedBy) {
            this.snapshot = snapshot;
            this.roots = roots;
            this.groupedBy = groupedBy;
            this.totalHeap = snapshot.getSnapshotInfo().getUsedHeapSize();
        }

        public Grouping getGroupedBy() {
            return this.groupedBy;
        }

        public int[] getRoots() {
            return this.roots;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }
    }
}

