/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.source.extension.discovery;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.kdm.source.discoverer.actions.DiscoverSourceModelFromJavaProject;
import org.eclipse.modisco.kdm.source.extension.Activator;
import org.eclipse.modisco.kdm.source.extension.discovery.Messages;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractComposedKDMSourceDiscoverer
implements Discoverer {
    private Resource kdmSourceModelResource = null;
    private ResourceSet resourceSet = null;

    protected Resource getKdmSourceModelResource() {
        return this.kdmSourceModelResource;
    }

    protected void setKdmSourceModelResource(Resource kdmSourceModelResource) {
        this.kdmSourceModelResource = kdmSourceModelResource;
    }

    public void discoverElement(final Object source, final Map<DiscoveryParameter, Object> parameters) {
        Job job = new Job(this.getDiscoveryName()){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus resultStatus = Status.OK_STATUS;
                monitor.beginTask(Messages.AbstractComposedKDMSourceDiscoverer_0, -1);
                AbstractComposedKDMSourceDiscoverer.this.initializeCompositeModel(source, parameters, monitor);
                if (monitor.isCanceled()) {
                    resultStatus = Status.CANCEL_STATUS;
                    return resultStatus;
                }
                monitor.worked(1);
                AbstractComposedKDMSourceDiscoverer.this.discoverOtherLeafModels(source, parameters, monitor);
                if (monitor.isCanceled()) {
                    resultStatus = Status.CANCEL_STATUS;
                    return resultStatus;
                }
                monitor.worked(1);
                AbstractComposedKDMSourceDiscoverer.this.discoverKDMSourceModel(source, monitor);
                if (monitor.isCanceled()) {
                    resultStatus = Status.CANCEL_STATUS;
                    return resultStatus;
                }
                monitor.worked(1);
                AbstractComposedKDMSourceDiscoverer.this.completeModelsBuild(source, parameters, monitor);
                monitor.done();
                return resultStatus;
            }
        };
        this.scheduleEditorOpening(job);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    protected abstract void initializeCompositeModel(Object var1, Map<DiscoveryParameter, Object> var2, IProgressMonitor var3);

    protected abstract void discoverOtherLeafModels(Object var1, Map<DiscoveryParameter, Object> var2, IProgressMonitor var3);

    protected abstract void completeModelsBuild(Object var1, Map<DiscoveryParameter, Object> var2, IProgressMonitor var3);

    protected abstract String getDiscoveryName();

    protected abstract Resource getResultModel();

    protected abstract boolean shouldOpenEditorOnResultModel();

    protected Resource discoverKDMSourceModel(Object source, IProgressMonitor monitor) {
        monitor.subTask(Messages.AbstractComposedKDMSourceDiscoverer_1);
        this.kdmSourceModelResource = null;
        DiscoverSourceModelFromJavaProject kdmSourceDiscoverer = new DiscoverSourceModelFromJavaProject();
        HashMap<DiscoveryParameter, Boolean> parameterForKDMSourceDiscovery = new HashMap<DiscoveryParameter, Boolean>();
        parameterForKDMSourceDiscovery.put(DiscoverSourceModelFromJavaProject.PARAMETER_SILENT_MODE, Boolean.TRUE);
        kdmSourceDiscoverer.discoverElement(source, parameterForKDMSourceDiscovery);
        if (parameterForKDMSourceDiscovery.get(kdmSourceDiscoverer.getDiscovererParameters().get(0)) != null) {
            this.kdmSourceModelResource = (Resource)parameterForKDMSourceDiscovery.get(kdmSourceDiscoverer.getDiscovererParameters().get(0));
            this.getResourceSet().getResources().add((Object)this.kdmSourceModelResource);
        }
        return this.kdmSourceModelResource;
    }

    protected final ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    private void scheduleEditorOpening(Job job) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (AbstractComposedKDMSourceDiscoverer.this.shouldOpenEditorOnResultModel() && event.getJob().getResult().isOK() && AbstractComposedKDMSourceDiscoverer.this.getResultModel() != null && AbstractComposedKDMSourceDiscoverer.this.getResultModel().getURI() != null) {
                    URI uri = AbstractComposedKDMSourceDiscoverer.this.getResultModel().getURI();
                    IFile iFile = null;
                    if (uri.isPlatformResource()) {
                        iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                    } else if (uri.isFile()) {
                        iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
                    }
                    AbstractComposedKDMSourceDiscoverer.openEditor(iFile);
                }
            }
        });
    }

    protected static final void openEditor(final IFile source) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IEditorDescriptor editDesc;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart existingEditorOnResource = page.findEditor((IEditorInput)new FileEditorInput(source));
                    if (existingEditorOnResource != null) {
                        page.closeEditor(existingEditorOnResource, true);
                    }
                    if ((editDesc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.gmt.modisco.infra.browser.editorID")) != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)source, (String)editDesc.getId());
                    } else {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)source);
                    }
                }
                catch (PartInitException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
        });
    }
}

