/*******************************************************************************
 * Copyright (c) 2009, 2011 David Green and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     David Green - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.internal.wikitext.tasks.ui.util;

import org.eclipse.mylyn.wikitext.core.parser.markup.ConfigurationBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.BugzillaGeneratedCommentBlock;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.BugzillaQuoteBlock;

/**
 * @author David Green
 */
public class Util {
	private static final String TASKTOP_TASKZILLA = "taskzilla"; //$NON-NLS-1$

	private static final String TASKTOP_ALM = "com.tasktop.alm.tasks"; //$NON-NLS-1$

	private static final String BUGZILLA = "bugzilla"; //$NON-NLS-1$

	public static MarkupLanguageConfiguration create(String repositoryKind) {
		ConfigurationBuilder builder = ConfigurationBuilder.create().repositorySettings();

		if (isBugzillaOrDerivative(repositoryKind)) {
			builder.block(new BugzillaQuoteBlock()).block(new BugzillaGeneratedCommentBlock());
		}
		return builder.configuration();
	}

	private static boolean isBugzillaOrDerivative(String repositoryKind) {
		return BUGZILLA.equals(repositoryKind) || TASKTOP_ALM.equals(repositoryKind)
				|| TASKTOP_TASKZILLA.equals(repositoryKind);
	}
}
