/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.util.LocatorImpl;

public class RecordingDocumentBuilder
extends DocumentBuilder {
    private final List<Event> events = new ArrayList<Event>();

    private void add(Event event) {
        event.locator = new LocatorImpl(this.getLocator());
        this.events.add(event);
    }

    public void acronym(String text, String definition) {
        this.add(new Event(text));
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        this.add(new Event(type, attributes));
    }

    public void beginDocument() {
    }

    public void beginHeading(int level, Attributes attributes) {
        this.add(new Event(level, attributes));
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.add(new Event(type, attributes));
    }

    public void characters(String text) {
        this.add(new Event(text));
    }

    public void charactersUnescaped(String literal) {
        this.add(new Event(literal));
    }

    public void endBlock() {
    }

    public void endDocument() {
    }

    public void endHeading() {
    }

    public void endSpan() {
    }

    public void entityReference(String entity) {
    }

    public void image(Attributes attributes, String url) {
    }

    public void imageLink(Attributes linkAttributes, Attributes attributes, String href, String imageUrl) {
    }

    public void lineBreak() {
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(((Object)((Object)this)).getClass().getSimpleName());
        buf.append("(");
        for (Event event : this.events) {
            buf.append("\n\t");
            buf.append(event);
        }
        buf.append("\n)");
        return buf.toString();
    }

    public static class Event {
        public Attributes attributes;
        public DocumentBuilder.BlockType blockType;
        public String text;
        public Integer headingLevel;
        public DocumentBuilder.SpanType spanType;
        public LocatorImpl locator;

        Event(String text) {
            this.text = text;
        }

        public Event(DocumentBuilder.BlockType type, Attributes attributes2) {
            this.blockType = type;
            this.attributes = attributes2;
        }

        public Event(int level, Attributes attributes2) {
            this.headingLevel = level;
            this.attributes = attributes2;
        }

        public Event(DocumentBuilder.SpanType type, Attributes attributes2) {
            this.spanType = type;
            this.attributes = attributes2;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.blockType != null) {
                buf.append("Block(");
                buf.append(this.blockType);
            } else if (this.spanType != null) {
                buf.append("Span(");
                buf.append(this.spanType);
            } else if (this.headingLevel != null) {
                buf.append("Heading(");
                buf.append(this.headingLevel);
            } else {
                buf.append("Text?(");
            }
            if (this.text != null) {
                buf.append(this.text.length() > 6 ? String.valueOf(this.text.substring(0, 6)) + "..." : this.text);
            }
            buf.append(",lineNumber=");
            buf.append(this.locator.getLineNumber());
            buf.append(",lineCharacterOffset=");
            buf.append(this.locator.getLineCharacterOffset());
            buf.append(",lineSegmentEnd=");
            buf.append(this.locator.getLineSegmentEndOffset());
            buf.append(",lineLength=");
            buf.append(this.locator.getLineLength());
            buf.append(",lineDocumentOffset=");
            buf.append(this.locator.getLineDocumentOffset());
            buf.append(",documentOffset=");
            buf.append(this.locator.getDocumentOffset());
            buf.append(")");
            return buf.toString();
        }
    }
}

