/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupEndCommand;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupStartCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.action.ColumnReorderDragMode;

public class ColumnGroupHeaderReorderDragMode
extends ColumnReorderDragMode {
    private final ColumnGroupModel model;

    public ColumnGroupHeaderReorderDragMode(ColumnGroupModel model) {
        this.model = model;
    }

    @Override
    protected boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition) {
        if (this.currentEvent != null) {
            toGridColumnPosition = natLayer.getColumnPositionByX(this.currentEvent.x);
        }
        int toColumnIndex = natLayer.getColumnIndexByPosition(toGridColumnPosition);
        boolean betweenGroups = false;
        if (this.currentEvent != null) {
            int minX = this.currentEvent.x - 4;
            int maxX = this.currentEvent.x + 4;
            betweenGroups = ColumnGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.model);
        }
        return !this.model.isPartOfAGroup(toColumnIndex) || betweenGroups;
    }

    @Override
    protected void fireMoveStartCommand(NatTable natTable, int dragFromGridColumnPosition) {
        natTable.doCommand(new ReorderColumnGroupStartCommand(natTable, dragFromGridColumnPosition));
    }

    @Override
    protected void fireMoveEndCommand(NatTable natTable, int dragToGridColumnPosition) {
        natTable.doCommand(new ReorderColumnGroupEndCommand(natTable, dragToGridColumnPosition));
    }
}

