/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedIOUtil;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.io.TMPUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DBType {
    BOOLEAN(16){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            return DBType.writeValueBoolean(out, resultSet, column, canBeNull);
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            return DBType.readValueBoolean(in, statement, column, canBeNull, this.getCode());
        }
    }
    ,
    BIT(-7){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            return DBType.writeValueBoolean(out, resultSet, column, canBeNull);
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            return DBType.readValueBoolean(in, statement, column, canBeNull, this.getCode());
        }
    }
    ,
    TINYINT(-6){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            byte value = resultSet.getByte(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeByte((int)value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            byte value = in.readByte();
            statement.setByte(column, value);
            return value;
        }
    }
    ,
    SMALLINT(5){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            short value = resultSet.getShort(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeShort((int)value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            short value = in.readShort();
            statement.setShort(column, value);
            return value;
        }
    }
    ,
    INTEGER(4){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            int value = resultSet.getInt(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeInt(value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            int value = in.readInt();
            statement.setInt(column, value);
            return value;
        }
    }
    ,
    BIGINT(-5){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            long value = resultSet.getLong(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeLong(value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            long value = in.readLong();
            statement.setLong(column, value);
            return value;
        }
    }
    ,
    FLOAT(6){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            float value = resultSet.getFloat(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeFloat(value);
            return Float.valueOf(value);
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            float value = in.readFloat();
            statement.setFloat(column, value);
            return Float.valueOf(value);
        }
    }
    ,
    REAL(7){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            float value = resultSet.getFloat(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeFloat(value);
            return Float.valueOf(value);
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            float value = in.readFloat();
            statement.setFloat(column, value);
            return Float.valueOf(value);
        }
    }
    ,
    DOUBLE(8){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            double value = resultSet.getDouble(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeDouble(value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            double value = in.readDouble();
            statement.setDouble(column, value);
            return value;
        }
    }
    ,
    NUMERIC(2){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            throw new UnsupportedOperationException("SQL NULL has to be considered");
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            throw new UnsupportedOperationException("SQL NULL has to be considered");
        }
    }
    ,
    DECIMAL(3){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            throw new UnsupportedOperationException("SQL NULL has to be considered");
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            throw new UnsupportedOperationException("SQL NULL has to be considered");
        }
    }
    ,
    CHAR(1){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            String value = resultSet.getString(column);
            out.writeString(value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            String value = in.readString();
            statement.setString(column, value);
            return value;
        }
    }
    ,
    VARCHAR(12){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            String value = resultSet.getString(column);
            out.writeString(value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            String value = in.readString();
            statement.setString(column, value);
            return value;
        }
    }
    ,
    LONGVARCHAR(-1, "LONG VARCHAR"){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            String value = resultSet.getString(column);
            out.writeString(value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            String value = in.readString();
            statement.setString(column, value);
            return value;
        }
    }
    ,
    CLOB(2005){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            Reader value = null;
            try {
                value = resultSet.getCharacterStream(column);
                if (canBeNull) {
                    if (resultSet.wasNull()) {
                        out.writeBoolean(false);
                        return null;
                    }
                    out.writeBoolean(true);
                }
                Long l = ExtendedIOUtil.writeCharacterStream((DataOutput)out, (Reader)value);
                return l;
            }
            finally {
                IOUtil.close((Closeable)value);
            }
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            ReaderWithLength value = ReaderWithLength.create(in);
            long length = value.getLength();
            statement.setCharacterStream(column, (Reader)value, (int)length);
            return length;
        }
    }
    ,
    DATE(91){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            Date value = resultSet.getDate(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            long longValue = value.getTime();
            out.writeLong(longValue);
            return longValue;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            long value = in.readLong();
            statement.setDate(column, new Date(value));
            return value;
        }
    }
    ,
    TIME(92){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            Time value = resultSet.getTime(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            long longValue = value.getTime();
            out.writeLong(longValue);
            return longValue;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            long value = in.readLong();
            statement.setTime(column, new Time(value));
            return value;
        }
    }
    ,
    TIMESTAMP(93){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            Timestamp value = resultSet.getTimestamp(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeLong(value.getTime());
            out.writeInt(value.getNanos());
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            long value = in.readLong();
            int nanos = in.readInt();
            Timestamp timeStamp = new Timestamp(value);
            timeStamp.setNanos(nanos);
            statement.setTimestamp(column, timeStamp);
            return timeStamp;
        }
    }
    ,
    BINARY(-2){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            byte[] value = resultSet.getBytes(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeInt(value.length);
            out.write(value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            byte[] value = in.readByteArray();
            statement.setBytes(column, value);
            return value;
        }
    }
    ,
    VARBINARY(-3){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            byte[] value = resultSet.getBytes(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeInt(value.length);
            out.write(value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            byte[] value = in.readByteArray();
            statement.setBytes(column, value);
            return value;
        }
    }
    ,
    LONGVARBINARY(-4, "LONG VARBINARY"){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            byte[] value = resultSet.getBytes(column);
            if (canBeNull) {
                if (resultSet.wasNull()) {
                    out.writeBoolean(false);
                    return null;
                }
                out.writeBoolean(true);
            }
            out.writeInt(value.length);
            out.write(value);
            return value;
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            byte[] value = in.readByteArray();
            statement.setBytes(column, value);
            return value;
        }
    }
    ,
    BLOB(2004){

        public Object writeValueWithResult(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
            InputStream value = null;
            try {
                value = resultSet.getBinaryStream(column);
                if (canBeNull) {
                    if (resultSet.wasNull()) {
                        out.writeBoolean(false);
                        return null;
                    }
                    out.writeBoolean(true);
                }
                Long l = ExtendedIOUtil.writeBinaryStream((DataOutput)out, (InputStream)value);
                return l;
            }
            finally {
                IOUtil.close((Closeable)value);
            }
        }

        public Object readValueWithResult(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
            if (canBeNull && !in.readBoolean()) {
                statement.setNull(column, this.getCode());
                return null;
            }
            InputStreamWithLength value = InputStreamWithLength.create(in);
            long length = value.getLength();
            statement.setBinaryStream(column, (InputStream)value, (int)length);
            return length;
        }
    };

    private static final int BOOLEAN_NULL = -1;
    private static final int BOOLEAN_FALSE = 0;
    private static final int BOOLEAN_TRUE = 1;
    private int code;
    private String keyword;

    private DBType(int code, String keyword) {
        this.code = code;
        this.keyword = keyword;
    }

    private DBType(int code) {
        this(code, (String)null);
    }

    public int getCode() {
        return this.code;
    }

    public String getKeyword() {
        return this.keyword == null ? super.toString() : this.keyword;
    }

    public String toString() {
        return this.getKeyword();
    }

    public void writeValue(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
        this.writeValueWithResult(out, resultSet, column, canBeNull);
    }

    public abstract Object writeValueWithResult(ExtendedDataOutput var1, ResultSet var2, int var3, boolean var4) throws SQLException, IOException;

    public void readValue(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull) throws SQLException, IOException {
        this.readValueWithResult(in, statement, column, canBeNull);
    }

    public abstract Object readValueWithResult(ExtendedDataInput var1, PreparedStatement var2, int var3, boolean var4) throws SQLException, IOException;

    private static Boolean writeValueBoolean(ExtendedDataOutput out, ResultSet resultSet, int column, boolean canBeNull) throws SQLException, IOException {
        boolean value = resultSet.getBoolean(column);
        if (canBeNull) {
            if (resultSet.wasNull()) {
                out.writeByte(-1);
                return null;
            }
            out.writeByte(value ? 1 : 0);
            return value;
        }
        out.writeBoolean(value);
        return value;
    }

    private static Boolean readValueBoolean(ExtendedDataInput in, PreparedStatement statement, int column, boolean canBeNull, int sqlType) throws IOException, SQLException {
        if (canBeNull) {
            byte opcode = in.readByte();
            switch (opcode) {
                case -1: {
                    statement.setNull(column, sqlType);
                    return null;
                }
                case 0: {
                    statement.setBoolean(column, false);
                    return false;
                }
                case 1: {
                    statement.setBoolean(column, true);
                    return true;
                }
            }
            throw new IOException("Invalid boolean opcode: " + opcode);
        }
        boolean value = in.readBoolean();
        statement.setBoolean(column, value);
        return value;
    }

    public static DBType getTypeByKeyword(String keyword) {
        DBType[] values = DBType.values();
        int i = 0;
        while (i < values.length) {
            DBType dbType = values[i];
            if (dbType.getKeyword().equalsIgnoreCase(keyword)) {
                return dbType;
            }
            ++i;
        }
        return null;
    }

    public static DBType getTypeByCode(int code) {
        DBType[] values = DBType.values();
        int i = 0;
        while (i < values.length) {
            DBType dbType = values[i];
            if (dbType.getCode() == code) {
                return dbType;
            }
            ++i;
        }
        return null;
    }

    /* synthetic */ DBType(String string, int n, int n2, DBType dBType) {
        this(n2);
    }

    /* synthetic */ DBType(String string, int n, int n2, String string2, DBType dBType) {
        this(n2, string2);
    }

    private static final class InputStreamWithLength
    extends FileInputStream {
        private final File file;
        private final long length;

        private InputStreamWithLength(File file, long length) throws FileNotFoundException {
            super(file);
            this.file = file;
            this.length = length;
        }

        public long getLength() {
            return this.length;
        }

        public void close() throws IOException {
            super.close();
            this.file.delete();
        }

        public static InputStreamWithLength create(ExtendedDataInput in) throws IOException {
            InputStreamWithLength inputStreamWithLength;
            FileOutputStream fileOutputStream = null;
            try {
                File tempFile = TMPUtil.createTempFile((String)"lob_", (String)".tmp");
                fileOutputStream = new FileOutputStream(tempFile);
                long length = ExtendedIOUtil.readBinaryStream((DataInput)in, (OutputStream)fileOutputStream);
                inputStreamWithLength = new InputStreamWithLength(tempFile, length);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileOutputStream);
                throw throwable;
            }
            IOUtil.close((Closeable)fileOutputStream);
            return inputStreamWithLength;
        }
    }

    private static final class ReaderWithLength
    extends FileReader {
        private final File file;
        private final long length;

        private ReaderWithLength(File file, long length) throws FileNotFoundException {
            super(file);
            this.file = file;
            this.length = length;
        }

        public long getLength() {
            return this.length;
        }

        public void close() throws IOException {
            super.close();
            this.file.delete();
        }

        public static ReaderWithLength create(ExtendedDataInput in) throws IOException {
            ReaderWithLength readerWithLength;
            FileWriter fileWriter = null;
            try {
                File tempFile = TMPUtil.createTempFile((String)"lob_", (String)".tmp");
                fileWriter = new FileWriter(tempFile);
                long length = ExtendedIOUtil.readCharacterStream((DataInput)in, (Writer)fileWriter);
                readerWithLength = new ReaderWithLength(tempFile, length);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileWriter);
                throw throwable;
            }
            IOUtil.close((Closeable)fileWriter);
            return readerWithLength;
        }
    }
}

