/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.container;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.net4j.util.ui.container.ElementWizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ElementWizardAction
extends LongRunningAction {
    private Shell shell;
    private String title;
    private String toolTip;
    private String productGroup;
    private String factoryType;
    private String description;
    private String defaultFactoryType;
    private IManagedContainer container;

    public ElementWizardAction(Shell shell, String title, String toolTip, ImageDescriptor image, String productGroup) {
        this(shell, title, toolTip, image, productGroup, (IManagedContainer)IPluginContainer.INSTANCE);
    }

    public ElementWizardAction(Shell shell, String title, String toolTip, ImageDescriptor image, String productGroup, IManagedContainer container) {
        this(shell, title, toolTip, image, productGroup, container, null);
    }

    public ElementWizardAction(Shell shell, String title, String toolTip, ImageDescriptor image, String productGroup, IManagedContainer container, String defaultFactoryType) {
        super(title, toolTip, image);
        this.shell = shell;
        this.title = title;
        this.toolTip = toolTip;
        this.productGroup = productGroup;
        this.container = container;
        this.defaultFactoryType = defaultFactoryType;
    }

    public String getDefaultFactoryType() {
        return this.defaultFactoryType;
    }

    public String getDefaultDescription(String factoryType) {
        return null;
    }

    protected void preRun() throws Exception {
        ElementWizardDialog dialog = new ElementWizardDialog(this.shell, this.title, this.toolTip, this.productGroup, this.defaultFactoryType){

            protected IManagedContainer getContainer() {
                return ElementWizardAction.this.container;
            }

            protected String getDefaultDescription(String factoryType) {
                return ElementWizardAction.this.getDefaultDescription(factoryType);
            }
        };
        if (dialog.open() == 0) {
            this.factoryType = dialog.getFactoryType();
            this.description = dialog.getDescription();
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        try {
            this.container.getElement(this.productGroup, this.factoryType, this.description);
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)ElementWizardAction.this.shell, (String)ElementWizardAction.this.title, (String)("An error occured: " + ex.getMessage() + "\n\nThe error log may contain more information about the problem."));
                }
            });
        }
    }
}

