/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode;

public abstract class Types {
    public static final int ACCESS_PACKAGE = 0;
    public static final int ACCESS_PUBLIC = 1;
    public static final int ACCESS_PRIVATE = 2;
    public static final int ACCESS_PROTECTED = 4;
    public static final int ACCESS_STATIC = 8;
    public static final int TEAM = 32768;
    public static final int ROLE_FLAG = 2;
    public static final String VOID = "V";
    public static final String BOOLEAN = "Z";
    public static final String CHAR = "C";
    public static final String BYTE = "B";
    public static final String SHORT = "S";
    public static final String INT = "I";
    public static final String FLOAT = "F";
    public static final String LONG = "J";
    public static final String DOUBLE = "D";
    private static final String ARRAY = "[";

    public static String getAsArrayType(String className) {
        if (className.length() == 1) {
            return ARRAY + className;
        }
        return "[L" + className;
    }

    public static String getAsType(String type) {
        return "L" + type;
    }

    public static String getAsType(Class<?> clazz) {
        String type = null;
        if (clazz.isPrimitive()) {
            String name = clazz.getName();
            if (name.compareTo("void") == 0) {
                type = VOID;
            } else if (name.compareTo("boolean") == 0) {
                type = BOOLEAN;
            } else if (name.compareTo("char") == 0) {
                type = CHAR;
            } else if (name.compareTo("byte") == 0) {
                type = BYTE;
            } else if (name.compareTo("short") == 0) {
                type = SHORT;
            } else if (name.compareTo("int") == 0) {
                type = INT;
            } else if (name.compareTo("float") == 0) {
                type = FLOAT;
            } else if (name.compareTo("long") == 0) {
                type = LONG;
            } else if (name.compareTo("double") == 0) {
                type = DOUBLE;
            }
        } else {
            type = clazz.getName().replace('.', '/');
            if (!clazz.isArray()) {
                type = "L" + type;
            }
        }
        return type;
    }

    public static String getTypeStringForMethod(String returnType, String[] paramTypes) {
        String result = "(";
        if (paramTypes != null) {
            String[] stringArray = paramTypes;
            int n = paramTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String paramType = stringArray[n2];
                result = String.valueOf(result) + paramType;
                if (paramType.length() > 2) {
                    result = String.valueOf(result) + ";";
                }
                ++n2;
            }
        }
        result = String.valueOf(result) + ")" + returnType;
        if (returnType.length() > 2) {
            result = String.valueOf(result) + ";";
        }
        return result;
    }

    public static String getTypeStringForMethod(Class<?> returnType, Class<?>[] paramTypes) {
        String result = "(";
        if (paramTypes != null) {
            Class<?>[] classArray = paramTypes;
            int n = paramTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> paramType = classArray[n2];
                String paramTypeString = Types.getAsType(paramType);
                result = String.valueOf(result) + paramTypeString;
                if (!paramType.isPrimitive() && !paramType.isArray()) {
                    result = String.valueOf(result) + ";";
                }
                ++n2;
            }
        }
        String returnTypeString = Types.getAsType(returnType);
        result = String.valueOf(result) + ")" + returnTypeString;
        if (!returnType.isPrimitive() && !returnType.isArray()) {
            result = String.valueOf(result) + ";";
        }
        return result;
    }

    public static String getTypeStringForField(String type) {
        return String.valueOf(type) + ";";
    }
}

