/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.ids.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.IdHash;
import org.eclipse.ocl.examples.domain.ids.MetaclassId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.ids.impl.AbstractMetaclassId;
import org.eclipse.ocl.examples.domain.ids.impl.SpecializedMetaclassIdImpl;
import org.eclipse.ocl.examples.domain.ids.impl.WeakHashMapOfWeakReference;

public class GeneralizedMetaclassIdImpl
extends AbstractMetaclassId {
    @NonNull
    private WeakHashMapOfWeakReference<ElementId, MetaclassId> specializations = new WeakHashMapOfWeakReference<ElementId, MetaclassId>(){

        @Override
        @NonNull
        protected MetaclassId newId(@NonNull ElementId elementId) {
            return new SpecializedMetaclassIdImpl(elementId);
        }
    };

    public GeneralizedMetaclassIdImpl() {
        super(IdHash.createGlobalHash(MetaclassId.class, "Metaclass"));
    }

    @NonNull
    public String getDisplayName() {
        return "Metaclass";
    }

    @NonNull
    public ElementId getElementId() {
        return TypeId.T_1;
    }

    @Nullable
    public String getLiteralName() {
        if (this == TypeId.METACLASS) {
            return "METACLASS";
        }
        return null;
    }

    @NonNull
    public MetaclassId getSpecializedId(@NonNull ElementId elementId) {
        return this.specializations.getId(elementId);
    }
}

