/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OrderedCollectionValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.CollectionValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.SparseSequenceValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceValueImpl
extends CollectionValueImpl
implements SequenceValue {
    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.SEQUENCE_VALUE;
    }

    public SequenceValueImpl(@NonNull CollectionTypeId typeId, @NonNull List<? extends Object> values) {
        super(typeId, values);
    }

    @Override
    @NonNull
    public OrderedCollectionValue append(@Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(EvaluatorMessages.InvalidSource, "append");
        }
        ArrayList<Object> result = new ArrayList<Object>(this.elements);
        result.add(object);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    @NonNull
    public OrderedCollectionValue appendAll(@NonNull OrderedCollectionValue objects) {
        ArrayList<? extends Object> result = new ArrayList<Object>(this.elements);
        result.addAll(objects.getElements());
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    @NonNull
    public List<? extends Object> asList() {
        return this.getElements();
    }

    @Override
    @NonNull
    public OrderedCollectionValue asOrderedCollectionValue() {
        return this;
    }

    @Override
    @NonNull
    public SequenceValue asSequenceValue() {
        return this;
    }

    @Override
    @Nullable
    public Object at(int index) {
        if (--index < 0 || this.elements.size() <= index) {
            throw new InvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        return this.getElements().get(index);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SequenceValue) || obj instanceof OrderedSetValue) {
            return false;
        }
        Iterator<Object> theseElements = this.iterator();
        Iterator<Object> thoseElements = ((SequenceValue)obj).iterator();
        while (theseElements.hasNext() && thoseElements.hasNext()) {
            Object thatValue;
            Object thisValue = theseElements.next();
            if (thisValue.equals(thatValue = thoseElements.next())) continue;
            return false;
        }
        return !theseElements.hasNext() && !thoseElements.hasNext();
    }

    @Override
    @NonNull
    public SequenceValue excluding(@Nullable Object value) {
        ArrayList result = new ArrayList();
        if (value == null) {
            for (Object element : this.elements) {
                if (element == null) continue;
                result.add(element);
            }
        } else {
            for (Object element : this.elements) {
                if (value.equals(element)) continue;
                result.add(element);
            }
        }
        if (result.size() < this.elements.size()) {
            return new SparseSequenceValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    @NonNull
    public SequenceValue excludingAll(@NonNull CollectionValue values) {
        ArrayList result = new ArrayList();
        for (Object element : this.elements) {
            boolean reject = false;
            if (element == null) {
                for (Object value : values) {
                    if (value != null) continue;
                    reject = true;
                    break;
                }
            } else {
                for (Object value : values) {
                    if (value == null || !value.equals(element)) continue;
                    reject = true;
                    break;
                }
            }
            if (reject) continue;
            result.add(element);
        }
        if (result.size() < this.elements.size()) {
            return new SparseSequenceValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    @Nullable
    public Object first() {
        if (this.elements.size() <= 0) {
            throw new InvalidValueException(EvaluatorMessages.EmptyCollection, "Sequence", "first");
        }
        return this.getElements().get(0);
    }

    @Override
    @NonNull
    public SequenceValue flatten() {
        ArrayList<Object> flattened = new ArrayList<Object>();
        if (this.flatten(flattened)) {
            return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)flattened);
        }
        return this;
    }

    @NonNull
    public List<? extends Object> getElements() {
        return (List)this.elements;
    }

    @Override
    @NonNull
    public String getKind() {
        return "Sequence";
    }

    @Override
    @NonNull
    public SequenceValue including(@Nullable Object value) {
        if (value instanceof InvalidValueException) {
            throw new InvalidValueException(EvaluatorMessages.InvalidSource, "including");
        }
        ArrayList<Object> result = new ArrayList<Object>(this.elements);
        result.add(value);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    @NonNull
    public SequenceValue includingAll(@NonNull CollectionValue values) {
        ArrayList<Object> result = new ArrayList<Object>(this.elements);
        for (Object value : values) {
            result.add(value);
        }
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    @NonNull
    public IntegerValue indexOf(@Nullable Object object) {
        int index = this.getElements().indexOf(object);
        if (index < 0) {
            throw new InvalidValueException(EvaluatorMessages.MissingValue, "indexOf");
        }
        return ValuesUtil.integerValueOf(index + 1);
    }

    @Override
    @NonNull
    public SequenceValue insertAt(int index, @Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(EvaluatorMessages.InvalidSource, "insertAt");
        }
        if (--index < 0 || index > this.elements.size()) {
            throw new InvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        ArrayList<Object> result = new ArrayList<Object>(this.elements);
        result.add(index, object);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    @Nullable
    public Object last() {
        int size = this.elements.size();
        if (size <= 0) {
            throw new InvalidValueException(EvaluatorMessages.EmptyCollection, "Sequence", "last");
        }
        return this.getElements().get(size - 1);
    }

    @Override
    @NonNull
    public SequenceValue prepend(@Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(EvaluatorMessages.InvalidSource, "prepend");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(object);
        result.addAll(this.elements);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    @NonNull
    public SequenceValue prependAll(@NonNull OrderedCollectionValue objects) {
        ArrayList<? extends Object> result = new ArrayList<Object>(objects.getElements());
        result.addAll(this.elements);
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    @NonNull
    public SequenceValue reverse() {
        ArrayList elements = new ArrayList(this.elements);
        Collections.reverse(elements);
        return new SparseSequenceValueImpl(this.getTypeId(), elements);
    }

    @Override
    @NonNull
    public SequenceValue sort(@NonNull Comparator<Object> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new SparseSequenceValueImpl(this.getTypeId(), values);
    }

    @Override
    @NonNull
    public SequenceValue subSequence(int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new InvalidValueException(new IndexOutOfBoundsException("lower: " + (lower + 1)));
        }
        if (upper >= this.elements.size()) {
            throw new InvalidValueException(new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + this.size()));
        }
        if (upper < lower) {
            throw new InvalidValueException(new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1)));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int curr = 0;
        for (Object object : this.iterable()) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return new SparseSequenceValueImpl(this.getTypeId(), (List<? extends Object>)result);
    }

    @Override
    @NonNull
    public SequenceValue toSequenceValue() {
        return this;
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("Sequence");
        super.toString(s, lengthLimit);
    }
}

