/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.NumberValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnlimitedValueImpl
extends NumberValueImpl
implements UnlimitedValue {
    private static final long serialVersionUID = 8556985089778234910L;

    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.UNLIMITED_VALUE;
    }

    @Override
    @NonNull
    public UnlimitedValueImpl abs() {
        return this;
    }

    @Override
    @NonNull
    public IntegerValue addInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "add", "UnlimitedValue");
    }

    @Override
    @NonNull
    public RealValue addReal(@NonNull RealValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "add", "UnlimitedValue");
    }

    @Override
    @NonNull
    public Object asEcoreObject(@NonNull IdResolver idResolver) {
        return Unlimited.INSTANCE;
    }

    @Override
    public Object asEcoreObject(@NonNull IdResolver idResolver, @Nullable Class<?> instanceClass) {
        return -1;
    }

    @Override
    @NonNull
    public Number asNumber() {
        return Unlimited.INSTANCE;
    }

    @Override
    @NonNull
    public Object asObject() {
        return Unlimited.INSTANCE;
    }

    @Override
    @NonNull
    public RealValue asRealValue() {
        return this;
    }

    @Override
    @NonNull
    public Value asUnlimitedNaturalValue() {
        return this;
    }

    @Override
    @NonNull
    public BigDecimal bigDecimalValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "bigDecimalValue", "UnlimitedValue");
    }

    @Override
    @NonNull
    public BigInteger bigIntegerValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "bigIntegerValue", "UnlimitedValue");
    }

    @Override
    @NonNull
    public RealValue commutatedAdd(@NonNull RealValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "add", "UnlimitedValue");
    }

    @Override
    @NonNull
    public IntegerValue commutatedDiv(@NonNull IntegerValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "div", "UnlimitedValue");
    }

    @Override
    @NonNull
    public RealValue commutatedDivide(@NonNull RealValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "divide", "UnlimitedValue");
    }

    @Override
    @NonNull
    public IntegerValue commutatedMod(@NonNull IntegerValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "mod", "UnlimitedValue");
    }

    @Override
    @NonNull
    public RealValue commutatedMultiply(@NonNull RealValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "multiply", "UnlimitedValue");
    }

    @Override
    @NonNull
    public RealValue commutatedSubtract(@NonNull RealValue left) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "subtract", "UnlimitedValue");
    }

    @Override
    public int compareTo(RealValue left) {
        return -left.compareToUnlimited(this);
    }

    @Override
    public int compareToInteger(@NonNull IntegerValue right) {
        return 1;
    }

    @Override
    public int compareToReal(@NonNull RealValue right) {
        return 1;
    }

    @Override
    public int compareToUnlimited(@NonNull UnlimitedValue right) {
        return 0;
    }

    @Override
    @NonNull
    public IntegerValue divInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "div", "UnlimitedValue");
    }

    @Override
    @NonNull
    public IntegerValue divUnlimited(@NonNull UnlimitedValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "div", "UnlimitedValue");
    }

    @Override
    @NonNull
    public RealValue divideInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "divide", "UnlimitedValue");
    }

    @Override
    @NonNull
    public RealValue divideReal(@NonNull RealValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "divide", "UnlimitedValue");
    }

    @Override
    public double doubleValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidReal, null, null, this);
    }

    @Override
    public float floatValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidReal, null, null, this);
    }

    @Override
    @NonNull
    public IntegerValue floor() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "floor", "UnlimitedValue");
    }

    @NonNull
    public DomainType getType(@NonNull DomainStandardLibrary standardLibrary) {
        return standardLibrary.getUnlimitedNaturalType();
    }

    @Override
    @NonNull
    public TypeId getTypeId() {
        return TypeId.UNLIMITED_NATURAL;
    }

    @Override
    public int intValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidInteger, null, null, this);
    }

    @Override
    @Nullable
    public IntegerValue isIntegerValue() {
        return null;
    }

    @Override
    public boolean isUnlimited() {
        return true;
    }

    @Override
    public boolean isUnlimitedNatural() {
        return true;
    }

    @Override
    public long longValue() {
        throw new InvalidValueException(EvaluatorMessages.InvalidInteger, null, null, this);
    }

    @Override
    @NonNull
    public RealValue max(@NonNull RealValue rightValue) {
        return this;
    }

    @Override
    @NonNull
    public IntegerValue maxInteger(@NonNull IntegerValue right) {
        return this;
    }

    @Override
    @NonNull
    public RealValue maxReal(@NonNull RealValue right) {
        return this;
    }

    @Override
    @NonNull
    public RealValue maxUnlimited(@NonNull UnlimitedValue rightValue) {
        return this;
    }

    @Override
    @NonNull
    public RealValue min(@NonNull RealValue rightValue) {
        return rightValue;
    }

    @Override
    @NonNull
    public RealValue minUnlimited(@NonNull UnlimitedValue rightValue) {
        return this;
    }

    @Override
    @NonNull
    public IntegerValue minInteger(@NonNull IntegerValue right) {
        return right;
    }

    @Override
    @NonNull
    public RealValue minReal(@NonNull RealValue right) {
        return right;
    }

    @Override
    @NonNull
    public IntegerValue modInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "mod", "UnlimitedValue");
    }

    @Override
    @NonNull
    public IntegerValue modUnlimited(@NonNull UnlimitedValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "mod", "UnlimitedValue");
    }

    @Override
    @NonNull
    public IntegerValue multiplyInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "multiply", "UnlimitedValue");
    }

    @Override
    @NonNull
    public RealValue multiplyReal(@NonNull RealValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "multiply", "UnlimitedValue");
    }

    @Override
    @NonNull
    public UnlimitedValue negate() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "negate", "UnlimitedValue");
    }

    @Override
    @NonNull
    public IntegerValue round() {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "round", "UnlimitedValue");
    }

    @Override
    public int signum() {
        return 1;
    }

    @Override
    @NonNull
    public IntegerValue subtractInteger(@NonNull IntegerValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "subtract", "UnlimitedValue");
    }

    @Override
    @NonNull
    public RealValue subtractReal(@NonNull RealValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "subtract", "UnlimitedValue");
    }

    public String toString() {
        return "*";
    }
}

