/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.ecore;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainRoot;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.NsURIPackageId;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.domain.ids.RootPackageId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreReflectivePackage;
import org.eclipse.ocl.examples.library.executor.AbstractIdResolver;
import org.eclipse.ocl.examples.library.executor.ExecutableStandardLibrary;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreIdResolver
extends AbstractIdResolver
implements Adapter {
    @NonNull
    protected final Collection<? extends EObject> directRoots;
    private Map<String, DomainPackage> nsURI2package = new HashMap<String, DomainPackage>();
    private Map<String, DomainPackage> roots2package = new HashMap<String, DomainPackage>();
    private boolean directRootsProcessed = false;
    private boolean crossReferencedRootsProcessed = false;
    @NonNull
    private Map<EClassifier, WeakReference<DomainInheritance>> typeMap = new WeakHashMap<EClassifier, WeakReference<DomainInheritance>>();

    public EcoreIdResolver(@NonNull Collection<? extends EObject> roots, @NonNull ExecutorStandardLibrary standardLibrary) {
        super((DomainStandardLibrary)standardLibrary);
        this.directRoots = roots;
    }

    @NonNull
    private DomainPackage addEPackage(@NonNull EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        DomainPackage asPackage = this.nsURI2package.get(nsURI);
        if (asPackage == null) {
            PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
            asPackage = new EcoreReflectivePackage(ePackage, this, packageId);
            this.nsURI2package.put(nsURI, asPackage);
            if (packageId instanceof RootPackageId) {
                this.roots2package.put(((RootPackageId)packageId).getName(), asPackage);
            }
        }
        return asPackage;
    }

    private void addPackage(@NonNull DomainPackage userPackage) {
        String nsURI = userPackage.getNsURI();
        if (nsURI != null) {
            this.nsURI2package.put(nsURI, userPackage);
            EPackage ePackage = userPackage.getEPackage();
            if (ePackage != null) {
                if (DomainUtil.basicGetMetamodelAnnotation((EPackage)ePackage) != null && this.roots2package.get("$metamodel$") == null) {
                    this.roots2package.put("$metamodel$", userPackage);
                }
            } else {
                for (DomainType asType : userPackage.getOwnedType()) {
                    if (!"Boolean".equals(asType.getName())) continue;
                    if (this.roots2package.get("$metamodel$") == null) {
                        this.roots2package.put("$metamodel$", userPackage);
                    }
                    break;
                }
            }
        } else {
            String name = userPackage.getName();
            if (name != null) {
                this.roots2package.put(name, userPackage);
            }
        }
        this.addPackages(userPackage.getNestedPackage());
    }

    private void addPackages(Iterable<? extends DomainPackage> userPackages) {
        for (DomainPackage domainPackage : userPackages) {
            assert (domainPackage != null);
            this.addPackage(domainPackage);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public Notifier getTarget() {
        return null;
    }

    @Override
    @NonNull
    public synchronized DomainTupleType getTupleType(@NonNull TupleTypeId typeId) {
        return ((ExecutableStandardLibrary)this.standardLibrary).getTupleType(typeId);
    }

    @NonNull
    public DomainTupleType getTupleType(DomainTypedElement ... parts) {
        int iSize = parts.length;
        ArrayList<TuplePartId> partsList = new ArrayList<TuplePartId>(iSize);
        int i = 0;
        while (i < iSize) {
            DomainTypedElement part = parts[i];
            String partName = DomainUtil.getSafeName((Nameable)part);
            partsList.add(IdManager.getTuplePartId((int)i, (String)partName, (TypeId)part.getTypeId()));
            ++i;
        }
        return this.getTupleType(IdManager.getTupleTypeId((String)"Tuple", partsList));
    }

    @NonNull
    public synchronized DomainInheritance getType(@NonNull EClassifier eClassifier) {
        DomainInheritance type = this.weakGet(this.typeMap, eClassifier);
        if (type == null) {
            DomainType domainType;
            PackageId packageId;
            DomainElement domainPackage;
            EPackage ePackage = eClassifier.getEPackage();
            assert (ePackage != null);
            ExecutorPackage execPackage = ((ExecutorStandardLibrary)this.standardLibrary).getPackage(ePackage);
            if (execPackage == null && (domainPackage = (DomainElement)(packageId = IdManager.getPackageId((EPackage)ePackage)).accept((IdVisitor)this)) instanceof ExecutorPackage) {
                execPackage = (ExecutorPackage)domainPackage;
            }
            if (execPackage != null && (domainType = ((ExecutorPackage)execPackage).getType(eClassifier.getName())) != null) {
                type = this.standardLibrary.getInheritance(domainType);
                this.typeMap.put(eClassifier, new WeakReference<DomainInheritance>(type));
            }
        }
        return (DomainInheritance)DomainUtil.nonNullState((Object)type);
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
    }

    protected synchronized void processCrossReferencedRoots() {
        if (this.crossReferencedRootsProcessed) {
            return;
        }
        this.crossReferencedRootsProcessed = true;
        new EcoreUtil.ExternalCrossReferencer(this.directRoots){
            private static final long serialVersionUID = 1L;
            private Set<EObject> moreRoots;
            {
                this.moreRoots = new HashSet<EObject>();
                this.findExternalCrossReferences();
            }

            protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
                EObject root = EcoreUtil.getRootContainer((EObject)crossReferencedEObject);
                if (this.moreRoots.add(root) && !EcoreIdResolver.this.directRoots.contains(root)) {
                    if (root instanceof DomainRoot) {
                        EcoreIdResolver.this.addPackages(((DomainRoot)root).getNestedPackage());
                    } else if (root instanceof DomainPackage) {
                        EcoreIdResolver.this.addPackage((DomainPackage)root);
                    }
                }
                return false;
            }
        };
    }

    protected synchronized void processDirectRoots() {
        if (this.directRootsProcessed) {
            return;
        }
        this.directRootsProcessed = true;
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        for (EObject eObject : this.directRoots) {
            if (eObject instanceof DomainRoot) {
                this.addPackages(((DomainRoot)eObject).getNestedPackage());
            }
            ePackages.add(eObject.eClass().getEPackage());
        }
        for (EPackage ePackage : ePackages) {
            if (ePackage == null) continue;
            this.addEPackage(ePackage);
        }
    }

    public void setTarget(Notifier newTarget) {
    }

    @Override
    @NonNull
    public synchronized DomainPackage visitNsURIPackageId(@NonNull NsURIPackageId id) {
        EPackage ePackage;
        String nsURI = id.getNsURI();
        DomainPackage knownPackage = this.nsURI2package.get(nsURI);
        if (knownPackage != null) {
            return knownPackage;
        }
        DomainPackage libraryPackage = this.standardLibrary.getNsURIPackage(nsURI);
        if (libraryPackage != null) {
            this.nsURI2package.put(nsURI, libraryPackage);
            return libraryPackage;
        }
        if (!this.directRootsProcessed) {
            this.processDirectRoots();
            knownPackage = this.nsURI2package.get(nsURI);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        if (!this.crossReferencedRootsProcessed) {
            this.processCrossReferencedRoots();
            knownPackage = this.nsURI2package.get(nsURI);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        if ((ePackage = id.getEPackage()) != null) {
            DomainPackage asPackage = this.addEPackage(ePackage);
            return asPackage;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public DomainPackage visitRootPackageId(@NonNull RootPackageId id) {
        if (id == IdManager.METAMODEL) {
            return (DomainPackage)DomainUtil.nonNullState((Object)this.getStandardLibrary().getOclAnyType().getPackage());
        }
        String name = id.getName();
        DomainPackage knownPackage = this.roots2package.get(name);
        if (knownPackage != null) {
            return knownPackage;
        }
        if (!this.directRootsProcessed) {
            this.processDirectRoots();
            knownPackage = this.roots2package.get(name);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        if (!this.crossReferencedRootsProcessed) {
            this.processCrossReferencedRoots();
            knownPackage = this.roots2package.get(name);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        throw new UnsupportedOperationException();
    }
}

