/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.ecore;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTemplateParameter;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.domain.elements.FeatureFilter;
import org.eclipse.ocl.examples.domain.types.AbstractFragment;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.ecore.EcoreReflectiveFragment;
import org.eclipse.ocl.examples.library.ecore.EcoreReflectivePackage;
import org.eclipse.ocl.examples.library.executor.DomainProperties;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.examples.library.executor.ReflectiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreReflectiveType
extends ReflectiveType {
    @NonNull
    public static final List<DomainInheritance> EMPTY_INHERITANCES = Collections.emptyList();
    @NonNull
    protected final EClassifier eClassifier;
    @NonNull
    protected final DomainTypeParameters typeParameters;
    private DomainProperties allProperties;

    public EcoreReflectiveType(@NonNull EcoreReflectivePackage evaluationPackage, int flags, @NonNull EClassifier eClassifier, DomainTemplateParameter ... typeParameters) {
        super((String)DomainUtil.nonNullEMF((Object)eClassifier.getName()), evaluationPackage, flags, new ExecutorTypeParameter[0]);
        this.eClassifier = eClassifier;
        this.typeParameters = new DomainTypeParameters(typeParameters);
    }

    @Override
    @NonNull
    protected AbstractFragment createFragment(@NonNull DomainInheritance baseInheritance) {
        return new EcoreReflectiveFragment(this, baseInheritance);
    }

    @Override
    @NonNull
    public Object createInstance() {
        if (this.eClassifier instanceof EClass) {
            EClass eClass = (EClass)this.eClassifier;
            EObject element = eClass.getEPackage().getEFactoryInstance().create(eClass);
            return DomainUtil.nonNullEMF((Object)element);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Object createInstance(@NonNull String value) {
        if (this.eClassifier instanceof EDataType) {
            EDataType eDataType = (EDataType)this.eClassifier;
            Object element = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, value);
            return DomainUtil.nonNullEMF((Object)element);
        }
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Iterable<? extends DomainOperation> getAllOperations(@Nullable FeatureFilter featureFilter) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Iterable<? extends DomainProperty> getAllProperties(@Nullable FeatureFilter featureFilter) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties((DomainInheritance)this);
        }
        return allProperties2.getAllProperties(featureFilter);
    }

    @NonNull
    public final EClassifier getEClassifier() {
        return this.eClassifier;
    }

    @Override
    @NonNull
    public Iterable<? extends DomainInheritance> getInitialSuperInheritances() {
        if (this.eClassifier instanceof EClass) {
            final Iterator iterator = ((EClass)this.eClassifier).getESuperTypes().iterator();
            return new Iterable<DomainInheritance>(){

                @Override
                public Iterator<DomainInheritance> iterator() {
                    return new Iterator<DomainInheritance>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public DomainInheritance next() {
                            EClass next = (EClass)iterator.next();
                            if (!$assertionsDisabled && next == null) {
                                throw new AssertionError();
                            }
                            return ((EcoreReflectivePackage)EcoreReflectiveType.this.evaluationPackage).getIdResolver().getType((EClassifier)next);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        return EMPTY_INHERITANCES;
    }

    @NonNull
    public List<? extends DomainOperation> getLocalOperations() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public List<? extends DomainProperty> getLocalProperties() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public List<? extends DomainType> getLocalSuperTypes() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public DomainProperty getMemberProperty(@NonNull String name) {
        DomainProperties allProperties2 = this.allProperties;
        if (allProperties2 == null) {
            this.allProperties = allProperties2 = new DomainProperties((DomainInheritance)this);
        }
        return allProperties2.getMemberProperty(name);
    }

    @NonNull
    public String getMetaTypeName() {
        return (String)DomainUtil.nonNullPivot((Object)this.eClassifier.getName());
    }

    @NonNull
    public List<? extends DomainProperty> getOwnedAttribute() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public List<? extends DomainOperation> getOwnedOperation() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainStandardLibrary getStandardLibrary() {
        return ((EcoreReflectivePackage)this.getPackage()).getStandardLibrary();
    }

    @NonNull
    public DomainTypeParameters getTypeParameters() {
        return this.typeParameters;
    }
}

