/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class AnyIteration
extends AbstractIteration {
    @NonNull
    public static final AnyIteration INSTANCE = new AnyIteration();

    @NonNull
    public Object createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return INSTANCE;
    }

    @Nullable
    protected Object resolveTerminalValue(@NonNull DomainIterationManager iterationManager) {
        throw new InvalidValueException("No matching content for 'any'", new Object[0]);
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal == null) {
            throw new InvalidValueException(EvaluatorMessages.UndefinedBody, new Object[]{"any"});
        }
        if (bodyVal == Boolean.FALSE) {
            return CARRY_ON;
        }
        if (bodyVal != Boolean.TRUE) {
            throw new InvalidValueException(EvaluatorMessages.NonBooleanBody, new Object[]{"any"});
        }
        Object value = iterationManager.get();
        return value;
    }
}

