/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public class ExistsIteration
extends AbstractIteration {
    @NonNull
    public static final ExistsIteration INSTANCE = new ExistsIteration();

    @NonNull
    public Object createAccumulatorValue(@NonNull DomainEvaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return new AbstractIteration.MutableObject((Object)Boolean.FALSE);
    }

    @Nullable
    protected Object resolveTerminalValue(@NonNull DomainIterationManager iterationManager) {
        AbstractIteration.MutableObject accumulatorValue = (AbstractIteration.MutableObject)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        Object object = accumulatorValue.get();
        if (object == null || object == Boolean.FALSE) {
            return object;
        }
        throw (InvalidValueException)object;
    }

    @Nullable
    protected Object updateAccumulator(@NonNull DomainIterationManager iterationManager) {
        try {
            Object bodyVal = iterationManager.evaluateBody();
            if (bodyVal == Boolean.TRUE) {
                return Boolean.TRUE;
            }
            if (bodyVal == Boolean.FALSE) {
                return CARRY_ON;
            }
            if (bodyVal == null) {
                AbstractIteration.MutableObject accumulatorValue = (AbstractIteration.MutableObject)iterationManager.getAccumulatorValue();
                assert (accumulatorValue != null);
                if (accumulatorValue.get() == Boolean.FALSE) {
                    accumulatorValue.set(null);
                }
                return CARRY_ON;
            }
            throw new InvalidValueException(EvaluatorMessages.NonBooleanBody, new Object[]{"exists"});
        }
        catch (EvaluationHaltedException e) {
            throw e;
        }
        catch (InvalidValueException e) {
            AbstractIteration.MutableObject accumulatorValue = (AbstractIteration.MutableObject)iterationManager.getAccumulatorValue();
            assert (accumulatorValue != null);
            accumulatorValue.set((Object)e);
            return CARRY_ON;
        }
        catch (Exception e) {
            AbstractIteration.MutableObject accumulatorValue = (AbstractIteration.MutableObject)iterationManager.getAccumulatorValue();
            assert (accumulatorValue != null);
            accumulatorValue.set((Object)ValuesUtil.createInvalidValue((Exception)e));
            return CARRY_ON;
        }
    }
}

