/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.AbstractBasicEnvironment;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnvironment
extends AbstractBasicEnvironment<Environment>
implements Environment {
    private Package contextPackage;
    private Operation contextOperation;
    private Property contextProperty;
    private Variable selfVariable;

    protected AbstractEnvironment() {
        this(null);
    }

    protected AbstractEnvironment(Environment parent) {
        super(parent);
    }

    @Override
    public boolean addElement(@NonNull String name, @NonNull Variable elem, boolean isExplicit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
    }

    @Override
    @Nullable
    public Package getContextPackage() {
        if (this.contextPackage != null) {
            return this.contextPackage;
        }
        Environment parent2 = (Environment)this.parent;
        if (parent2 != null) {
            return parent2.getContextPackage();
        }
        return null;
    }

    @Override
    @Nullable
    public Type getContextClassifier() {
        Variable selfVariable = this.getSelfVariable();
        return selfVariable != null ? selfVariable.getType() : null;
    }

    @Override
    @Nullable
    public Operation getContextOperation() {
        if (this.contextOperation != null) {
            return this.contextOperation;
        }
        Environment parent2 = (Environment)this.parent;
        if (parent2 != null) {
            return parent2.getContextOperation();
        }
        return null;
    }

    @Override
    @Nullable
    public Property getContextProperty() {
        if (this.contextProperty != null) {
            return this.contextProperty;
        }
        Environment parent2 = (Environment)this.parent;
        if (parent2 != null) {
            return parent2.getContextProperty();
        }
        return null;
    }

    @Override
    @Nullable
    public Variable getSelfVariable() {
        Environment parent2;
        Variable result = this.selfVariable;
        if (result == null && (parent2 = (Environment)this.parent) != null) {
            result = parent2.getSelfVariable();
        }
        return result;
    }

    protected void setContextOperation(@Nullable Operation contextOperation) {
        this.contextOperation = contextOperation;
    }

    protected void setContextPackage(@Nullable Package contextPackage) {
        this.contextPackage = contextPackage;
    }

    protected void setContextProperty(@Nullable Property contextProperty) {
        this.contextProperty = contextProperty;
    }

    @Override
    public void setSelfVariable(@NonNull Variable var) {
        Type contextClassifier;
        this.selfVariable = var;
        if (this.getContextPackage() == null && (contextClassifier = this.getContextClassifier()) != null) {
            this.setContextPackage(contextClassifier.getPackage());
        }
    }

    protected final class VariableEntry {
        @NonNull
        final String name;
        @NonNull
        final Variable variable;
        final boolean isExplicit;

        VariableEntry(@NonNull String name, Variable variable, boolean isExplicit) {
            this.name = name;
            this.variable = variable;
            this.isExplicit = isExplicit;
        }

        public String toString() {
            return "VariableEntry[" + this.name + ", " + (this.isExplicit ? "explicit, " : "implicit, ") + this.variable + "]";
        }
    }
}

