/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Adaptable;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ProblemAware;
import org.eclipse.ocl.examples.pivot.ProblemHandler;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.SyntaxException;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCLUtil {
    private OCLUtil() {
    }

    @Nullable
    public static <T> T getAdapter(@NonNull Environment env, @NonNull Class<T> adapterType) {
        return env.getAdapter(adapterType);
    }

    @Nullable
    public static <T> T getAdapter(@NonNull EnvironmentFactory factory, @NonNull Class<T> adapterType) {
        Object result = factory instanceof Adaptable ? ((Adaptable)((Object)factory)).getAdapter(adapterType) : (adapterType.isInstance(factory) ? factory : null);
        return result;
    }

    public static <T> T getAdapter(EvaluationEnvironment env, Class<T> adapterType) {
        return (T)env.getAdapter(adapterType);
    }

    public static Diagnostic checkForErrors(@NonNull Environment env) throws SyntaxException, SemanticException {
        throw new UnsupportedOperationException();
    }

    public static Diagnostic checkForErrors(@NonNull ProblemHandler problemHandler) throws SyntaxException, SemanticException {
        throw new UnsupportedOperationException();
    }

    public static Diagnostic checkForErrorsOrWarnings(@NonNull ProblemHandler problemHandler) throws SyntaxException, SemanticException {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static Environment getValidationEnvironment(@NonNull Object target, @NonNull Map<Object, Object> context) {
        Environment result = (Environment)context.get(Environment.class);
        if (result == null && (result = Environment.Registry.INSTANCE.getEnvironmentFor(target)) != null) {
            context.put(Environment.class, result);
        }
        return result;
    }

    @Nullable
    public static Diagnostic getEvaluationProblems(@NonNull Query query) {
        if (query instanceof ProblemAware) {
            ProblemAware problemAware = (ProblemAware)((Object)query);
            return problemAware.getProblems();
        }
        return null;
    }
}

