/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInvocationDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainException;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.AbstractIdResolver;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.EvaluationException;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.SemanticException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.delegate.InvocationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.ValidationBehavior;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLInvocationDelegate
extends BasicInvocationDelegate {
    protected final OCLDelegateDomain delegateDomain;
    private Operation operation;
    private ExpressionInOCL specification;

    public OCLInvocationDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EOperation operation) {
        super(operation);
        this.delegateDomain = delegateDomain;
    }

    public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
        try {
            OCL ocl = this.delegateDomain.getOCL();
            MetaModelManager metaModelManager = ocl.getMetaModelManager();
            PivotIdResolver idResolver = metaModelManager.getIdResolver();
            ExpressionInOCL specification2 = this.specification;
            if (specification2 == null) {
                Operation operation2 = this.operation;
                NamedElement namedElement = this.delegateDomain.getPivot(NamedElement.class, (EObject)DomainUtil.nonNullEMF((Object)this.eOperation));
                if (namedElement instanceof Operation) {
                    operation2 = this.operation = (Operation)namedElement;
                    specification2 = this.specification = InvocationBehavior.INSTANCE.getExpressionInOCL(metaModelManager, operation2);
                    InvocationBehavior.INSTANCE.validate(operation2);
                } else if (namedElement instanceof Constraint) {
                    Constraint constraint = (Constraint)namedElement;
                    specification2 = this.specification = this.getExpressionInOCL(metaModelManager, constraint);
                    ValidationBehavior.INSTANCE.validate(constraint);
                } else {
                    throw new OCLDelegateException((Exception)new SemanticException("Unsupported InvocationDelegate for a " + namedElement.eClass().getName()));
                }
            }
            Query query = ocl.createQuery(specification2);
            EvaluationEnvironment env = query.getEvaluationEnvironment();
            Object object = target;
            Object value = idResolver.boxedValueOf(target);
            env.add((DomainTypedElement)DomainUtil.nonNullModel((Object)specification2.getContextVariable()), value);
            List<Variable> parms = specification2.getParameterVariable();
            if (!parms.isEmpty()) {
                int i = 0;
                while (i < parms.size()) {
                    object = arguments.get(i);
                    value = idResolver.boxedValueOf(object);
                    env.add((DomainTypedElement)DomainUtil.nonNullModel((Object)parms.get(i)), value);
                    ++i;
                }
            }
            Object result = query.evaluate(target);
            return AbstractIdResolver.ecoreValueOf((IdResolver)idResolver, (Class)this.eOperation.getEType().getInstanceClass(), (Object)result);
        }
        catch (DomainException e) {
            String message = DomainUtil.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object[])new Object[]{this.operation});
            throw new OCLDelegateException((Exception)new EvaluationException(message, e));
        }
    }

    @NonNull
    public ExpressionInOCL getExpressionInOCL(@NonNull MetaModelManager metaModelManager, @NonNull Constraint constraint) {
        ExpressionInOCL query = null;
        OpaqueExpression valueSpecification = constraint.getSpecification();
        if (valueSpecification instanceof ExpressionInOCL) {
            query = (ExpressionInOCL)valueSpecification;
        } else {
            Type contextType = (Type)((Object)constraint.getContext());
            if (contextType != null) {
                ClassContext classContext = new ClassContext(metaModelManager, null, contextType);
                query = ValidationBehavior.INSTANCE.getExpressionInOCL(classContext, constraint);
            }
        }
        if (query == null) {
            String message = DomainUtil.bind((String)OCLMessages.MissingBodyForInvocationDelegate_ERROR_, (Object[])new Object[]{constraint.getContext()});
            throw new OCLDelegateException((Exception)new SemanticException(message));
        }
        return query;
    }

    @NonNull
    public Operation getOperation() {
        Operation operation2 = this.operation;
        if (operation2 == null) {
            NamedElement pivot = this.delegateDomain.getPivot(NamedElement.class, (EObject)DomainUtil.nonNullEMF((Object)this.eOperation));
            if (pivot instanceof Operation) {
                operation2 = this.operation = (Operation)pivot;
            }
            if (operation2 == null) {
                throw new OCLDelegateException((Exception)new SemanticException("No pivot property for " + this.eOperation));
            }
        }
        return operation2;
    }

    public String toString() {
        if (this.operation != null) {
            return "<" + this.delegateDomain.getURI() + ":invocation> " + this.operation;
        }
        String name = String.valueOf(this.eOperation.getEContainingClass().getEPackage().getName()) + "::" + this.eOperation.getEContainingClass().getName() + "." + this.eOperation.getName();
        return "<" + this.delegateDomain.getURI() + ":invocation> " + name;
    }
}

