/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.EvaluatorMultipleIterationManager;
import org.eclipse.ocl.examples.domain.library.EvaluatorSingleIterationManager;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.library.LibraryIteration;
import org.eclipse.ocl.examples.domain.library.LibraryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryProperty;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.AssociationClassCallExp;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.MessageExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.NavigationCallExp;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.StateExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.UnspecifiedValueExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.evaluation.AbstractEvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class EvaluationVisitorImpl
extends AbstractEvaluationVisitor {
    public static boolean isSimpleRange(@NonNull CollectionLiteralExp cl) {
        List<CollectionLiteralPart> partsList = cl.getPart();
        int size = partsList.size();
        if (size == 1) {
            CollectionLiteralPart part = partsList.get(0);
            return part instanceof CollectionRange;
        }
        return false;
    }

    public EvaluationVisitorImpl(@NonNull Environment env, @NonNull EvaluationEnvironment evalEnv, @NonNull DomainModelManager modelManager) {
        super(env, evalEnv, modelManager);
    }

    @NonNull
    public EvaluationVisitor createNestedEvaluator() {
        Environment environment = this.getEnvironment();
        EnvironmentFactory factory = environment.getFactory();
        EvaluationEnvironment nestedEvalEnv = factory.createEvaluationEnvironment(this.getEvaluationEnvironment());
        EvaluationVisitorImpl nestedEvaluationVisitor = new EvaluationVisitorImpl(environment, nestedEvalEnv, this.getModelManager());
        nestedEvaluationVisitor.setMonitor(this.getMonitor());
        return nestedEvaluationVisitor;
    }

    @NonNull
    public EvaluationVisitor createNestedUndecoratedEvaluator(@NonNull NamedElement operation) {
        return this.undecoratedVisitor.createNestedEvaluator();
    }

    public void dispose() {
        if (this.undecoratedVisitor != this) {
            this.undecoratedVisitor.dispose();
        }
    }

    @Nullable
    public Object evaluate(@NonNull DomainExpression body) {
        Object value = ((OCLExpression)body).accept(this.undecoratedVisitor);
        assert (ValuesUtil.isBoxed((Object)value));
        return value;
    }

    @Nullable
    public Object evaluate(@NonNull ExpressionInOCL expressionInOCL) {
        Object value = expressionInOCL.accept(this.undecoratedVisitor);
        assert (ValuesUtil.isBoxed((Object)value));
        return value;
    }

    protected Object evaluatePropertyCallExp(@NonNull NavigationCallExp propertyCallExp, @NonNull Property referredProperty) {
        OCLExpression source = propertyCallExp.getSource();
        Type propertyType = propertyCallExp.getType();
        assert (propertyType != null);
        EvaluationVisitor evaluationVisitor = this.undecoratedVisitor;
        Object sourceValue = source != null ? evaluationVisitor.evaluate(source) : null;
        LibraryProperty implementation = this.metaModelManager.getImplementation(sourceValue, referredProperty);
        try {
            return implementation.evaluate((DomainEvaluator)this, propertyType.getTypeId(), sourceValue);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, "Failed to evaluate '" + referredProperty + "'", new Object[]{sourceValue, propertyCallExp});
        }
    }

    @NonNull
    public EvaluationVisitor getEvaluator() {
        return this;
    }

    @NonNull
    public LibraryFeature lookupImplementation(@NonNull DomainType dynamicType, @NonNull DomainOperation staticOperation) {
        DomainInheritance inheritance = this.metaModelManager.getInheritance(dynamicType);
        return inheritance.lookupImplementation((DomainStandardLibrary)this.metaModelManager, staticOperation);
    }

    public Object safeVisit(@Nullable Visitable v) {
        if (v == null) {
            throw new InvalidValueException("null expression", new Object[0]);
        }
        try {
            Object result = v.accept(this.undecoratedVisitor);
            assert (ValuesUtil.isBoxed((Object)result));
            return result;
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, "Evaluation Failure");
        }
    }

    public Object visitAssociationClassCallExp(@NonNull AssociationClassCallExp ae) {
        Object context = ae.getSource().accept(this.undecoratedVisitor);
        return this.evaluationEnvironment.navigateAssociationClass(ae.getReferredAssociationClass(), ae.getNavigationSource(), context);
    }

    public Object visitBooleanLiteralExp(@NonNull BooleanLiteralExp booleanLiteralExp) {
        boolean value = booleanLiteralExp.isBooleanSymbol();
        return value;
    }

    public Object visitCollectionItem(@NonNull CollectionItem item) {
        throw new UnsupportedOperationException("evaluation of CollectionItem");
    }

    public Object visitCollectionLiteralExp(@NonNull CollectionLiteralExp cl) {
        List<CollectionLiteralPart> parts = cl.getPart();
        DomainCollectionType type = (DomainCollectionType)cl.getType();
        boolean isOrdered = type.isOrdered();
        if (isOrdered && EvaluationVisitorImpl.isSimpleRange(cl)) {
            CollectionRange collRange = (CollectionRange)parts.get(0);
            OCLExpression first = collRange.getFirst();
            OCLExpression last = collRange.getLast();
            Object firstVal = first.accept(this.undecoratedVisitor);
            Object lastVal = last.accept(this.undecoratedVisitor);
            IntegerValue firstInteger = ValuesUtil.asIntegerValue((Object)firstVal);
            IntegerValue lastInteger = ValuesUtil.asIntegerValue((Object)lastVal);
            CollectionTypeId typeId = type.getTypeId();
            IntegerRange range = ValuesUtil.createRange((IntegerValue)firstInteger, (IntegerValue)lastInteger);
            if (type.isUnique()) {
                return ValuesUtil.createOrderedSetRange((CollectionTypeId)typeId, (Object[])new Object[]{range});
            }
            return ValuesUtil.createSequenceRange((CollectionTypeId)typeId, (IntegerRange)range);
        }
        ArrayList<Object> orderedResults = new ArrayList<Object>();
        HashSet<Object> uniqueResults = type.isUnique() ? new HashSet<Object>() : null;
        block0: for (CollectionLiteralPart part : parts) {
            if (part instanceof CollectionItem) {
                CollectionItem item = (CollectionItem)part;
                OCLExpression itemExp = item.getItem();
                Object itemVal = itemExp.accept(this.undecoratedVisitor);
                if (uniqueResults != null && !uniqueResults.add(itemVal)) continue;
                orderedResults.add(itemVal);
                continue;
            }
            CollectionRange range = (CollectionRange)part;
            OCLExpression first = range.getFirst();
            OCLExpression last = range.getLast();
            Object firstVal = first.accept(this.undecoratedVisitor);
            Object lastVal = last.accept(this.undecoratedVisitor);
            IntegerValue firstInteger = ValuesUtil.asIntegerValue((Object)firstVal);
            IntegerValue lastInteger = ValuesUtil.asIntegerValue((Object)lastVal);
            Integer firstInt = firstInteger.asInteger();
            Integer lastInt = lastInteger.asInteger();
            int i = firstInt;
            while (true) {
                IntegerValue integerValue = ValuesUtil.integerValueOf((int)i);
                if (uniqueResults == null || uniqueResults.add(integerValue)) {
                    orderedResults.add(integerValue);
                }
                if (i >= lastInt) continue block0;
                ++i;
            }
        }
        return this.getIdResolver().createCollectionOfAll(type.isOrdered(), type.isUnique(), ((DomainType)DomainUtil.nonNullModel((Object)type.getElementType())).getTypeId(), orderedResults);
    }

    public Object visitCollectionRange(@NonNull CollectionRange range) {
        throw new UnsupportedOperationException("evaluation of CollectionRange");
    }

    public Object visitConstructorExp(@NonNull ConstructorExp ce) {
        Object object;
        Type type = ce.getType();
        String value = ce.getValue();
        if (value == null) {
            object = type.createInstance();
            for (ConstructorPart part : ce.getPart()) {
                OCLExpression initExpression = part.getInitExpression();
                if (initExpression == null) continue;
                Object boxedValue = this.undecoratedVisitor.evaluate(initExpression);
                Object unboxedValue = this.getIdResolver().unboxedValueOf(boxedValue);
                part.getReferredProperty().initValue(object, unboxedValue);
            }
        } else {
            object = type.createInstance(value);
        }
        return object != null ? ValuesUtil.createObjectValue((TypeId)type.getTypeId(), (Object)object) : null;
    }

    public Object visitEnumLiteralExp(@NonNull EnumLiteralExp el) {
        EnumerationLiteral enumLiteral = el.getReferredEnumLiteral();
        assert (enumLiteral != null);
        EnumerationLiteralId enumerationLiteralId = enumLiteral.getEnumerationLiteralId();
        return enumerationLiteralId;
    }

    public Object visitExpressionInOCL(@NonNull ExpressionInOCL expression) {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Object result = this.safeVisit(expression.getBodyExpression());
        return result;
    }

    public Object visitIfExp(@NonNull IfExp ifExp) {
        OCLExpression condition = ifExp.getCondition();
        Object acceptedValue = condition.accept(this.undecoratedVisitor);
        Boolean evaluatedCondition = ValuesUtil.asBoolean((Object)acceptedValue);
        OCLExpression expression = null;
        expression = evaluatedCondition == ValuesUtil.TRUE_VALUE ? ifExp.getThenExpression() : ifExp.getElseExpression();
        return expression.accept(this.undecoratedVisitor);
    }

    public Object visitIntegerLiteralExp(@NonNull IntegerLiteralExp integerLiteralExp) {
        Number integerSymbol = integerLiteralExp.getIntegerSymbol();
        return integerSymbol != null ? ValuesUtil.integerValueOf((Object)integerSymbol) : null;
    }

    public Object visitInvalidLiteralExp(@NonNull InvalidLiteralExp invalidLiteralExp) {
        throw ValuesUtil.INVALID_VALUE;
    }

    public Object visitIterateExp(@NonNull IterateExp iterateExp) {
        if (this.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Iteration staticIteration = (Iteration)DomainUtil.nonNullModel((Object)iterateExp.getReferredIteration());
        OCLExpression source = iterateExp.getSource();
        Object acceptedValue = source.accept(this.undecoratedVisitor);
        CollectionValue sourceValue = ValuesUtil.asCollectionValue((Object)acceptedValue);
        Type dynamicSourceType = this.metaModelManager.getIdResolver().getType((TypeId)sourceValue.getTypeId(), null);
        LibraryIteration implementation = (LibraryIteration)dynamicSourceType.lookupImplementation((DomainStandardLibrary)this.metaModelManager, staticIteration);
        Object result = null;
        try {
            EvaluatorSingleIterationManager iterationManager;
            Variable accumulator = iterateExp.getResult();
            Object initValue = accumulator.getInitExpression().accept(this.undecoratedVisitor);
            Variable accumulatorVariable = accumulator;
            OCLExpression body = (OCLExpression)DomainUtil.nonNullModel((Object)iterateExp.getBody());
            List<Variable> iterators = iterateExp.getIterator();
            int iSize = iterators.size();
            if (iSize == 1) {
                VariableDeclaration firstIterator = (VariableDeclaration)DomainUtil.nonNullModel((Object)iterators.get(0));
                iterationManager = new EvaluatorSingleIterationManager((DomainEvaluator)this.undecoratedVisitor, (DomainExpression)body, sourceValue, (DomainTypedElement)accumulatorVariable, initValue, (DomainTypedElement)firstIterator);
            } else {
                DomainTypedElement[] variables = new VariableDeclaration[iSize];
                int i = 0;
                while (i < iSize) {
                    variables[i] = iterators.get(i);
                    ++i;
                }
                iterationManager = new EvaluatorMultipleIterationManager((DomainEvaluator)this.undecoratedVisitor, (DomainExpression)body, sourceValue, (DomainTypedElement)accumulatorVariable, initValue, variables);
            }
            result = implementation.evaluateIteration((DomainIterationManager)iterationManager);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, "Failed to evaluate '" + staticIteration + "'", new Object[]{sourceValue, iterateExp});
        }
        return result;
    }

    public Object visitIteratorExp(@NonNull IteratorExp iteratorExp) {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Iteration staticIteration = (Iteration)DomainUtil.nonNullModel((Object)iteratorExp.getReferredIteration());
        OCLExpression source = iteratorExp.getSource();
        Object sourceVal = source.accept(this.undecoratedVisitor);
        CollectionValue sourceValue = ValuesUtil.asCollectionValue((Object)sourceVal);
        Type dynamicSourceType = this.metaModelManager.getIdResolver().getType((TypeId)sourceValue.getTypeId(), null);
        LibraryIteration implementation = (LibraryIteration)dynamicSourceType.lookupImplementation((DomainStandardLibrary)this.metaModelManager, staticIteration);
        Object result = null;
        try {
            EvaluatorSingleIterationManager iterationManager;
            OCLExpression body = iteratorExp.getBody();
            Type iterationType = PivotUtil.getType((Type)DomainUtil.nonNullModel((Object)iteratorExp.getType()));
            Type bodyType = PivotUtil.getType((Type)DomainUtil.nonNullModel((Object)body.getType()));
            Object accumulatorValue = implementation.createAccumulatorValue((DomainEvaluator)this.undecoratedVisitor, iterationType.getTypeId(), bodyType.getTypeId());
            List<Variable> iterators = iteratorExp.getIterator();
            int iSize = iterators.size();
            if (iSize == 1) {
                VariableDeclaration firstIterator = (VariableDeclaration)DomainUtil.nonNullModel((Object)iterators.get(0));
                iterationManager = new EvaluatorSingleIterationManager((DomainEvaluator)this.undecoratedVisitor, (DomainExpression)body, sourceValue, null, accumulatorValue, (DomainTypedElement)firstIterator);
            } else {
                DomainTypedElement[] variables = new VariableDeclaration[iSize];
                int i = 0;
                while (i < iSize) {
                    variables[i] = iterators.get(i);
                    ++i;
                }
                iterationManager = new EvaluatorMultipleIterationManager((DomainEvaluator)this.undecoratedVisitor, (DomainExpression)body, sourceValue, null, accumulatorValue, variables);
            }
            result = implementation.evaluateIteration((DomainIterationManager)iterationManager);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, "Failed to evaluate '" + staticIteration + "'", new Object[]{sourceValue, iteratorExp});
        }
        return result;
    }

    public Object visitLetExp(@NonNull LetExp letExp) {
        Object value;
        OCLExpression expression = letExp.getIn();
        Variable variable = letExp.getVariable();
        assert (variable != null);
        try {
            value = variable.accept(this.undecoratedVisitor);
        }
        catch (EvaluationHaltedException e) {
            throw e;
        }
        catch (InvalidValueException e) {
            value = e;
        }
        EvaluationVisitor nestedVisitor = this.undecoratedVisitor.createNestedEvaluator();
        nestedVisitor.getEvaluationEnvironment().add(variable, value);
        try {
            Object object = expression.accept(nestedVisitor);
            return object;
        }
        finally {
            nestedVisitor.dispose();
        }
    }

    public Object visitMessageExp(@NonNull MessageExp m) {
        throw new UnsupportedOperationException("evaluation of MessageExp");
    }

    public Object visitNullLiteralExp(@NonNull NullLiteralExp nullLiteralExp) {
        return null;
    }

    public Object visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
        Object sourceValue;
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        EvaluationVisitor evaluator = this.undecoratedVisitor.getEvaluator();
        Operation staticOperation = operationCallExp.getReferredOperation();
        assert (staticOperation != null);
        OCLExpression source = operationCallExp.getSource();
        boolean isValidating = staticOperation.isValidating();
        if (isValidating) {
            try {
                sourceValue = source.accept(this.undecoratedVisitor);
            }
            catch (EvaluationHaltedException e) {
                throw e;
            }
            catch (InvalidValueException e) {
                sourceValue = e;
            }
        } else {
            sourceValue = source.accept(this.undecoratedVisitor);
        }
        PivotIdResolver idResolver = this.metaModelManager.getIdResolver();
        DomainType dynamicSourceType = idResolver.getStaticTypeOf(sourceValue);
        List<Parameter> ownedParameters = staticOperation.getOwnedParameter();
        if (ownedParameters.size() == 1 && ownedParameters.get(0).getType() instanceof SelfType) {
            List<OCLExpression> arguments = operationCallExp.getArgument();
            Object onlyArgument = arguments.get(0).accept(this.undecoratedVisitor);
            if (onlyArgument != null) {
                DomainType argType = idResolver.getStaticTypeOf(onlyArgument);
                dynamicSourceType = dynamicSourceType.getCommonType((IdResolver)idResolver, argType);
            }
            LibraryBinaryOperation implementation = (LibraryBinaryOperation)dynamicSourceType.lookupImplementation((DomainStandardLibrary)this.metaModelManager, (DomainOperation)staticOperation);
            try {
                Object result = implementation.evaluate((DomainEvaluator)evaluator, operationCallExp.getTypeId(), sourceValue, onlyArgument);
                assert (!(result instanceof NullValue));
                return result;
            }
            catch (InvalidValueException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidValueException(e, "Failed to evaluate '" + staticOperation + "'", new Object[]{sourceValue, operationCallExp});
            }
        }
        LibraryOperation implementation = (LibraryOperation)dynamicSourceType.lookupImplementation((DomainStandardLibrary)this.metaModelManager, (DomainOperation)staticOperation);
        try {
            Object result = implementation.dispatch((DomainEvaluator)evaluator, (DomainCallExp)operationCallExp, sourceValue);
            assert (!(result instanceof NullValue));
            return result;
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, "Failed to evaluate '" + staticOperation + "'", new Object[]{sourceValue, operationCallExp});
        }
    }

    public Object visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp oppositePropertyCallExp) {
        Property oppositeReferredProperty = oppositePropertyCallExp.getReferredProperty();
        Property referredProperty = oppositeReferredProperty.getOpposite();
        assert (referredProperty != null);
        return this.evaluatePropertyCallExp(oppositePropertyCallExp, referredProperty);
    }

    public Object visitPropertyCallExp(@NonNull PropertyCallExp propertyCallExp) {
        Property referredProperty = propertyCallExp.getReferredProperty();
        assert (referredProperty != null);
        return this.evaluatePropertyCallExp(propertyCallExp, referredProperty);
    }

    public Object visitRealLiteralExp(@NonNull RealLiteralExp realLiteralExp) {
        Number realSymbol = realLiteralExp.getRealSymbol();
        return realSymbol != null ? ValuesUtil.realValueOf((Number)realSymbol) : null;
    }

    public Object visitStateExp(@NonNull StateExp s) {
        return s.getReferredState();
    }

    public Object visitStringLiteralExp(@NonNull StringLiteralExp stringLiteralExp) {
        String value = stringLiteralExp.getStringSymbol();
        if (value == null) {
            throw new InvalidValueException("Invalid String Value", new Object[]{stringLiteralExp});
        }
        return value;
    }

    public Object visitTupleLiteralExp(@NonNull TupleLiteralExp tl) {
        DomainType type = (DomainType)DomainUtil.nonNullModel((Object)tl.getType());
        HashMap<TuplePartId, Object> propertyValues = new HashMap<TuplePartId, Object>();
        for (TupleLiteralPart part : tl.getPart()) {
            propertyValues.put(part.getPartId(), part.accept(this.undecoratedVisitor));
        }
        return ValuesUtil.createTupleValue((TupleTypeId)((TupleType)type).getTupleTypeId(), propertyValues);
    }

    public Object visitTupleLiteralPart(@NonNull TupleLiteralPart tp) {
        return tp.getInitExpression().accept(this.undecoratedVisitor);
    }

    public Object visitTypeExp(@NonNull TypeExp t) {
        return t.getReferredType();
    }

    public Object visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp unlimitedNaturalLiteralExp) {
        Number unlimitedNaturalSymbol = unlimitedNaturalLiteralExp.getUnlimitedNaturalSymbol();
        if (unlimitedNaturalSymbol == null) {
            return null;
        }
        IntegerValue integerValue = ValuesUtil.integerValueOf((Object)unlimitedNaturalSymbol);
        if (integerValue.signum() < 0 && integerValue == ValuesUtil.integerValueOf((int)-1)) {
            integerValue = ValuesUtil.UNLIMITED_VALUE;
        }
        return integerValue;
    }

    public Object visitUnspecifiedValueExp(@NonNull UnspecifiedValueExp uv) {
        throw new UnsupportedOperationException("evaluation of UnspecifiedValueExp");
    }

    public Object visitVariable(@NonNull Variable variable) {
        OCLExpression initExp = variable.getInitExpression();
        if (initExp == null) {
            throw new InvalidValueException("Uninitialized variable", new Object[]{variable});
        }
        return initExp.accept(this.undecoratedVisitor);
    }

    public Object visitVariableExp(@NonNull VariableExp variableExp) {
        VariableDeclaration variableDeclaration = variableExp.getReferredVariable();
        if (variableDeclaration == null) {
            throw new InvalidValueException("Undefined variable", new Object[]{null, null, variableExp});
        }
        Object value = this.evaluationEnvironment.getValueOf(variableDeclaration);
        if (value instanceof InvalidValueException) {
            throw (InvalidValueException)((Object)value);
        }
        return value;
    }

    public Object visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
    }
}

