/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.internal.impl.NumericLiteralExpImpl;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerLiteralExpImpl
extends NumericLiteralExpImpl
implements IntegerLiteralExp {
    protected static final Number INTEGER_SYMBOL_EDEFAULT = null;
    protected Number integerSymbol = INTEGER_SYMBOL_EDEFAULT;

    protected IntegerLiteralExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.INTEGER_LITERAL_EXP;
    }

    @Override
    public Number getIntegerSymbol() {
        return this.integerSymbol;
    }

    @Override
    public void setIntegerSymbol(Number newIntegerSymbol) {
        Number oldIntegerSymbol = this.integerSymbol;
        this.integerSymbol = newIntegerSymbol;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldIntegerSymbol, (Object)this.integerSymbol));
        }
    }

    @Override
    public boolean validateTypeIsInteger(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_eq;
        DomainEvaluator evaluator = PivotUtil.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            DomainType TYP_Integer_0 = idResolver.getType((TypeId)TypeId.INTEGER, null);
            Type type = this.getType();
            boolean eq = type != null ? type.getTypeId() == TYP_Integer_0.getTypeId() : ValuesUtil.throwBooleanInvalidValueException((String)"null equal input");
            CAUGHT_eq = eq;
        }
        catch (Exception e) {
            CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_eq == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IntegerLiteralExp", "TypeIsInteger", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 11, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getExtension();
            }
            case 1: {
                return this.getOwnedAnnotation();
            }
            case 2: {
                return this.getOwnedComment();
            }
            case 3: {
                return this.isStatic();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.isRequired();
            }
            case 6: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 7: {
                return this.getIntegerSymbol();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                this.getExtension().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                this.getOwnedAnnotation().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                this.getOwnedComment().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setIsStatic((Boolean)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 5: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 6: {
                this.setType((Type)newValue);
                return;
            }
            case 7: {
                this.setIntegerSymbol((Number)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getExtension().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotation().clear();
                return;
            }
            case 2: {
                this.getOwnedComment().clear();
                return;
            }
            case 3: {
                this.setIsStatic(false);
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.setIsRequired(true);
                return;
            }
            case 6: {
                this.setType(null);
                return;
            }
            case 7: {
                this.setIntegerSymbol(INTEGER_SYMBOL_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.extension != null && !this.extension.isEmpty();
            }
            case 1: {
                return this.ownedAnnotation != null && !this.ownedAnnotation.isEmpty();
            }
            case 2: {
                return this.ownedComment != null && !this.ownedComment.isEmpty();
            }
            case 3: {
                return (this.eFlags & 0x100) != 0;
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return (this.eFlags & 0x200) == 0;
            }
            case 6: {
                return this.type != null;
            }
            case 7: {
                return INTEGER_SYMBOL_EDEFAULT == null ? this.integerSymbol != null : !INTEGER_SYMBOL_EDEFAULT.equals(this.integerSymbol);
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.validateTypeIsInteger((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitIntegerLiteralExp(this);
    }
}

