/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.compatibility.UML_4_2;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainEnumerationLiteral;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainRoot;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.EnumerationLiteralId;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.IdVisitor;
import org.eclipse.ocl.examples.domain.ids.NsURIPackageId;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.domain.ids.RootPackageId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.DomainInvalidTypeImpl;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.library.executor.AbstractIdResolver;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.TupleTypeManager;
import org.eclipse.ocl.examples.pivot.uml.UML2PivotUtil;
import org.eclipse.ocl.examples.pivot.uml.UMLElementExtension;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotIdResolver
extends AbstractIdResolver {
    private static final Logger logger = Logger.getLogger(PivotIdResolver.class);
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    private final Set<EObject> directRoots = new HashSet<EObject>();
    private boolean directRootsProcessed = false;
    private boolean crossReferencedRootsProcessed = false;
    @NonNull
    private final Map<String, DomainPackage> nsURI2package = new HashMap<String, DomainPackage>();
    @NonNull
    private final Map<String, DomainPackage> roots2package = new HashMap<String, DomainPackage>();

    public PivotIdResolver(@NonNull MetaModelManager metaModelManager) {
        super((DomainStandardLibrary)metaModelManager);
        this.metaModelManager = metaModelManager;
    }

    @NonNull
    private DomainPackage addEPackage(@NonNull EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        DomainPackage asPackage = this.nsURI2package.get(nsURI);
        if (asPackage == null) {
            PackageId packageId = IdManager.getPackageId((EPackage)ePackage);
            asPackage = this.metaModelManager.getPivotOfEcore(Package.class, (EObject)ePackage);
            assert (asPackage != null);
            this.nsURI2package.put(nsURI, asPackage);
            if (packageId instanceof RootPackageId) {
                this.roots2package.put(((RootPackageId)packageId).getName(), asPackage);
            }
        }
        return asPackage;
    }

    private void addPackage(@NonNull DomainPackage userPackage) {
        String nsURI = userPackage.getNsURI();
        if (nsURI != null) {
            this.nsURI2package.put(nsURI, userPackage);
            EPackage ePackage = userPackage.getEPackage();
            if (ePackage != null) {
                if (DomainUtil.basicGetMetamodelAnnotation((EPackage)ePackage) != null && this.roots2package.get("$metamodel$") == null) {
                    this.roots2package.put("$metamodel$", userPackage);
                }
            } else {
                for (DomainType asType : userPackage.getOwnedType()) {
                    if (!"Boolean".equals(asType.getName())) continue;
                    if (this.roots2package.get("$metamodel$") == null) {
                        this.roots2package.put("$metamodel$", userPackage);
                    }
                    break;
                }
            }
        } else {
            String name = userPackage.getName();
            if (name != null) {
                this.roots2package.put(name, userPackage);
            }
        }
        this.addPackages(userPackage.getNestedPackage());
    }

    private void addPackages(Iterable<? extends DomainPackage> userPackages) {
        for (DomainPackage domainPackage : userPackages) {
            assert (domainPackage != null);
            this.addPackage(domainPackage);
        }
    }

    @Nullable
    public Object boxedValueOf(@Nullable Object unboxedValue) {
        if (unboxedValue instanceof org.eclipse.uml2.uml.EnumerationLiteral) {
            org.eclipse.uml2.uml.EnumerationLiteral umlEnumerationLiteral = (org.eclipse.uml2.uml.EnumerationLiteral)unboxedValue;
            try {
                EnumerationLiteral asEnumerationLiteral = this.metaModelManager.getPivotOf(EnumerationLiteral.class, (EObject)umlEnumerationLiteral);
                if (asEnumerationLiteral != null) {
                    return asEnumerationLiteral.getEnumerationLiteralId();
                }
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        return super.boxedValueOf(unboxedValue);
    }

    @NonNull
    public DomainType getDynamicTypeOf(@Nullable Object value) {
        if (value instanceof org.eclipse.uml2.uml.Element) {
            DomainType metaType = UML2PivotUtil.getMetaType(this.metaModelManager, (org.eclipse.uml2.uml.Element)value);
            if (metaType != null) {
                return metaType;
            }
        } else if (value instanceof UMLElementExtension) {
            org.eclipse.uml2.uml.Stereotype umlStereotype = ((UMLElementExtension)((Object)value)).getDynamicStereotype();
            try {
                Stereotype asStereotype = this.metaModelManager.getPivotOf(Stereotype.class, (EObject)umlStereotype);
                return asStereotype != null ? asStereotype : this.metaModelManager.getOclInvalidType();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        return super.getDynamicTypeOf(value);
    }

    @NonNull
    public DomainType getStaticTypeOf(@Nullable Object value) {
        if (value instanceof org.eclipse.uml2.uml.Element) {
            try {
                org.eclipse.uml2.uml.Element umlElement = (org.eclipse.uml2.uml.Element)value;
                this.metaModelManager.getPivotOf(Element.class, (EObject)umlElement);
                EClass umlEClass = umlElement.eClass();
                Type umlAStype = this.metaModelManager.getPivotOf(Type.class, (EObject)umlEClass);
                if (umlAStype != null) {
                    return umlAStype;
                }
            }
            catch (ParserException umlElement) {
                // empty catch block
            }
            DomainType metaType = UML2PivotUtil.getMetaType(this.metaModelManager, (org.eclipse.uml2.uml.Element)value);
            if (metaType != null) {
                return metaType;
            }
        } else if (value instanceof UMLElementExtension) {
            org.eclipse.uml2.uml.Stereotype umlStereotype = ((UMLElementExtension)((Object)value)).getStaticStereotype();
            try {
                Stereotype asStereotype = this.metaModelManager.getPivotOf(Stereotype.class, (EObject)umlStereotype);
                return asStereotype != null ? asStereotype : this.metaModelManager.getOclInvalidType();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        return super.getStaticTypeOf(value);
    }

    @NonNull
    public TupleType getTupleType(@NonNull TupleTypeId typeId) {
        TupleTypeManager tupleManager = this.metaModelManager.getTupleManager();
        return tupleManager.getTupleType((IdResolver)this, typeId);
    }

    @NonNull
    public DomainType getType(@NonNull EClassifier eClassifier) {
        PackageServer packageServer;
        Type pivotType;
        DomainPackage asMetamodel;
        String typeName;
        EClassifier eType = eClassifier;
        EPackage ePackage = eClassifier.getEPackage();
        if (ePackage == UMLPackage.eINSTANCE) {
            typeName = eClassifier.getName();
            if (typeName != null && (asMetamodel = this.metaModelManager.getASMetamodel()) != null && (pivotType = (packageServer = this.metaModelManager.getPackageServer(asMetamodel)).getMemberType(typeName)) != null) {
                return pivotType;
            }
        } else if (ePackage.eContainer() instanceof EAnnotation && ePackage.eContainer().eContainer() instanceof Profile) {
            Profile umlProfile = (Profile)ePackage.eContainer().eContainer();
            String stereotypeName = UML_4_2.UMLUtil.getOriginalName((ENamedElement)eClassifier);
            org.eclipse.uml2.uml.Stereotype umlStereotype = umlProfile.getOwnedStereotype(stereotypeName);
            try {
                Stereotype stereotype = this.metaModelManager.getPivotOf(Stereotype.class, (EObject)umlStereotype);
                if (stereotype != null) {
                    return stereotype;
                }
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        if (ePackage == PivotPackage.eINSTANCE && (typeName = eClassifier.getName()) != null && (asMetamodel = this.metaModelManager.getASMetamodel()) != null && (pivotType = (packageServer = this.metaModelManager.getPackageServer(asMetamodel)).getMemberType(typeName)) != null) {
            return pivotType;
        }
        try {
            Type pivotType2 = this.metaModelManager.getPivotOf(Type.class, (EObject)eType);
            if (pivotType2 != null) {
                return this.metaModelManager.getPrimaryType(pivotType2);
            }
        }
        catch (ParserException e) {
            logger.error((Object)("Failed to convert '" + eType + "'"), (Throwable)e);
        }
        return new DomainInvalidTypeImpl(this.standardLibrary, "No object created by Ecore2Pivot");
    }

    @NonNull
    public Type getType(@NonNull TypeId typeId, @Nullable Object context) {
        DomainElement type = (DomainElement)typeId.accept((IdVisitor)this);
        if (type instanceof TemplateParameter) {
            type = ((TemplateParameter)type).getParameteredElement();
        }
        assert (type != null);
        return (Type)type;
    }

    private synchronized void processCrossReferencedRoots() {
        if (this.crossReferencedRootsProcessed) {
            return;
        }
        this.crossReferencedRootsProcessed = true;
        new EcoreUtil.ExternalCrossReferencer(this.directRoots){
            private static final long serialVersionUID = 1L;
            private Set<EObject> moreRoots;
            {
                this.moreRoots = new HashSet<EObject>();
                this.findExternalCrossReferences();
            }

            protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
                EObject root = EcoreUtil.getRootContainer((EObject)crossReferencedEObject);
                if (this.moreRoots.add(root) && !PivotIdResolver.this.directRoots.contains(root)) {
                    if (root instanceof DomainRoot) {
                        PivotIdResolver.this.addPackages(((DomainRoot)root).getNestedPackage());
                    } else if (root instanceof DomainPackage) {
                        PivotIdResolver.this.addPackage((DomainPackage)root);
                    }
                }
                return false;
            }
        };
    }

    private synchronized void processDirectRoots() {
        if (this.directRootsProcessed) {
            return;
        }
        this.directRootsProcessed = true;
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        for (EObject eObject : this.directRoots) {
            if (eObject instanceof DomainRoot) {
                this.addPackages(((DomainRoot)eObject).getNestedPackage());
            }
            ePackages.add(eObject.eClass().getEPackage());
        }
        for (EPackage ePackage : ePackages) {
            if (ePackage == null) continue;
            this.addEPackage(ePackage);
        }
    }

    @Nullable
    public Object unboxedValueOf(@Nullable Object boxedValue) {
        if (boxedValue instanceof EnumerationLiteralId) {
            DomainEnumerationLiteral enumerationLiteral = this.visitEnumerationLiteralId((EnumerationLiteralId)boxedValue);
            if (enumerationLiteral instanceof PivotObjectImpl) {
                EObject eTarget = ((PivotObjectImpl)enumerationLiteral).getETarget();
                return eTarget;
            }
            return enumerationLiteral;
        }
        return super.unboxedValueOf(boxedValue);
    }

    @NonNull
    public Object unboxedValueOfUML(@NonNull EnumerationLiteralId enumerationLiteralId) {
        EObject eTarget;
        DomainEnumerationLiteral enumerationLiteral = (DomainEnumerationLiteral)enumerationLiteralId.accept((IdVisitor)this);
        if (enumerationLiteral instanceof EnumerationLiteral && (eTarget = ((EnumerationLiteral)enumerationLiteral).getETarget()) != null) {
            return eTarget;
        }
        throw new UnsupportedOperationException();
    }

    @NonNull
    public synchronized DomainPackage visitNsURIPackageId(@NonNull NsURIPackageId id) {
        EPackage ePackage;
        String nsURI = id.getNsURI();
        DomainPackage nsURIPackage = this.metaModelManager.getNsURIPackage(nsURI);
        if (nsURIPackage != null) {
            return nsURIPackage;
        }
        this.metaModelManager.setAutoLoadASMetamodel(true);
        DomainPackage asMetamodel = this.metaModelManager.getASMetamodel();
        if (asMetamodel != null && "http://www.eclipse.org/ocl/3.1.0/Pivot".equals(nsURI)) {
            return asMetamodel;
        }
        nsURIPackage = this.metaModelManager.getNsURIPackage(nsURI);
        if (nsURIPackage != null) {
            return nsURIPackage;
        }
        DomainPackage knownPackage = this.nsURI2package.get(nsURI);
        if (knownPackage != null) {
            return knownPackage;
        }
        DomainPackage libraryPackage = this.standardLibrary.getNsURIPackage(nsURI);
        if (libraryPackage != null) {
            this.nsURI2package.put(nsURI, libraryPackage);
            return libraryPackage;
        }
        if (!this.directRootsProcessed) {
            this.processDirectRoots();
            knownPackage = this.nsURI2package.get(nsURI);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        if (!this.crossReferencedRootsProcessed) {
            this.processCrossReferencedRoots();
            knownPackage = this.nsURI2package.get(nsURI);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        if ((ePackage = id.getEPackage()) != null) {
            DomainPackage asPackage = this.addEPackage(ePackage);
            return asPackage;
        }
        throw new UnsupportedOperationException();
    }

    @NonNull
    public DomainPackage visitRootPackageId(@NonNull RootPackageId id) {
        Orphanage orphanage;
        String completeURIorName = id.getName();
        DomainPackage rootPackage = this.standardLibrary.getRootPackage(completeURIorName);
        if (rootPackage == null && (rootPackage = (DomainPackage)DomainUtil.getNamedElement((orphanage = this.metaModelManager.getOrphanage()).getNestedPackage(), (String)completeURIorName)) == null) {
            throw new UnsupportedOperationException();
        }
        return rootPackage;
    }
}

