/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.internal.impl.TuplePartImpl;
import org.eclipse.ocl.examples.pivot.internal.impl.TupleTypeImpl;
import org.eclipse.ocl.examples.pivot.internal.impl.TypedElementImpl;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.manager.TemplateParameterReferenceVisitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleTypeManager {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @Nullable
    private Map<TupleTypeId, TupleType> tupleid2tuple = null;

    @NonNull
    protected static TemplateParameterReferenceVisitor createTemplateParameterReferenceVisitor(@NonNull List<TemplateParameter> allTemplateParameters) {
        return new TemplateParameterReferenceVisitor(allTemplateParameters);
    }

    @NonNull
    public static TemplateParameter[] getAllTemplateParameterReferences(@NonNull Iterable<? extends Type> partTypes) {
        ArrayList<TemplateParameter> allTemplateParameters = new ArrayList<TemplateParameter>();
        TemplateParameterReferenceVisitor referenceVisitor = TupleTypeManager.createTemplateParameterReferenceVisitor(allTemplateParameters);
        for (Type type : partTypes) {
            type.accept(referenceVisitor);
        }
        TemplateParameter[] templateParameterArray = allTemplateParameters.toArray(new TemplateParameter[allTemplateParameters.size()]);
        return templateParameterArray;
    }

    protected TupleTypeManager(@NonNull MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    public void dispose() {
        this.tupleid2tuple = null;
    }

    @Nullable
    public Type getCommonType(@NonNull TupleType leftType, @NonNull TupleType rightType, @Nullable Map<TemplateParameter, ParameterableElement> bindings) {
        List<Property> leftProperties = leftType.getOwnedAttribute();
        List<Property> rightProperties = rightType.getOwnedAttribute();
        int iSize = leftProperties.size();
        if (iSize != rightProperties.size()) {
            return null;
        }
        ArrayList<TuplePartId> commonPartIds = new ArrayList<TuplePartId>(iSize);
        int i = 0;
        while (i < iSize) {
            Property leftProperty = leftProperties.get(i);
            if (leftProperty == null) {
                return null;
            }
            String name = leftProperty.getName();
            if (name == null) {
                return null;
            }
            Property rightProperty = (Property)DomainUtil.getNamedElement(rightProperties, (String)name);
            if (rightProperty == null) {
                return null;
            }
            Type leftPropertyType = leftProperty.getType();
            if (leftPropertyType == null) {
                return null;
            }
            Type rightPropertyType = rightProperty.getType();
            if (rightPropertyType == null) {
                return null;
            }
            Type commonType = this.metaModelManager.getCommonType(leftPropertyType, rightPropertyType, bindings);
            TuplePartId commonPartId = IdManager.getTuplePartId((int)i, (String)name, (TypeId)commonType.getTypeId());
            commonPartIds.add(commonPartId);
            ++i;
        }
        TupleTypeId commonTupleTypeId = IdManager.getTupleTypeId((String)"Tuple", commonPartIds);
        return this.getTupleType((IdResolver)this.metaModelManager.getIdResolver(), commonTupleTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public TupleType getTupleType(@NonNull IdResolver idResolver, @NonNull TupleTypeId tupleTypeId) {
        TupleType tupleType;
        Map<TupleTypeId, TupleType> tupleid2tuple2 = this.tupleid2tuple;
        if (tupleid2tuple2 == null) {
            TupleTypeManager tupleTypeManager = this;
            synchronized (tupleTypeManager) {
                tupleid2tuple2 = this.tupleid2tuple;
                if (tupleid2tuple2 == null) {
                    tupleid2tuple2 = this.tupleid2tuple = new HashMap<TupleTypeId, TupleType>();
                }
            }
        }
        if ((tupleType = tupleid2tuple2.get(tupleTypeId)) == null) {
            Map<TupleTypeId, TupleType> map = tupleid2tuple2;
            synchronized (map) {
                tupleType = tupleid2tuple2.get(tupleTypeId);
                if (tupleType == null) {
                    tupleType = new TupleTypeImpl(tupleTypeId);
                    TuplePartId[] partIds = tupleTypeId.getPartIds();
                    List<Property> ownedAttributes = tupleType.getOwnedAttribute();
                    TuplePartId[] tuplePartIdArray = partIds;
                    int n = partIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TuplePartId partId = tuplePartIdArray[n2];
                        DomainType partType = idResolver.getType(partId.getTypeId(), (Object)tupleType);
                        Type partType2 = this.metaModelManager.getType(partType);
                        ownedAttributes.add(new TuplePartImpl(partId, partType2));
                        ++n2;
                    }
                    tupleType.getSuperClass().add(this.metaModelManager.getOclTupleType());
                    tupleid2tuple2.put(tupleTypeId, tupleType);
                    this.metaModelManager.addOrphanClass(tupleType);
                }
            }
        }
        return tupleType;
    }

    @NonNull
    public TupleType getTupleType(@NonNull String tupleName, @NonNull Collection<? extends DomainTypedElement> parts, @Nullable Map<TemplateParameter, ParameterableElement> usageBindings) {
        HashMap<String, Type> partMap = new HashMap<String, Type>();
        for (DomainTypedElement domainTypedElement : parts) {
            DomainType type1 = domainTypedElement.getType();
            if (type1 == null) continue;
            Type type2 = this.metaModelManager.getType(type1);
            Type type3 = this.metaModelManager.getSpecializedType(type2, usageBindings);
            partMap.put(domainTypedElement.getName(), type3);
        }
        return this.getTupleType(tupleName, partMap);
    }

    @NonNull
    public TupleType getTupleType(@NonNull String tupleName, @NonNull Map<String, ? extends Type> parts) {
        Collection<? extends Type> partValues = parts.values();
        final TemplateParameter[] allTemplateParameters = TupleTypeManager.getAllTemplateParameterReferences(partValues);
        int partsCount = parts.size();
        TuplePartId[] newPartIds = new TuplePartId[partsCount];
        ArrayList<String> sortedPartNames = new ArrayList<String>(parts.keySet());
        Collections.sort(sortedPartNames);
        int i = 0;
        while (i < partsCount) {
            String partName = (String)sortedPartNames.get(i);
            Type partType = parts.get(partName);
            if (partType != null) {
                TuplePartId tuplePartId;
                TypeId partTypeId = partType.getTypeId();
                newPartIds[i] = tuplePartId = IdManager.getTuplePartId((int)i, (String)partName, (TypeId)partTypeId);
            }
            ++i;
        }
        TupleTypeId tupleTypeId = IdManager.getOrderedTupleTypeId((String)tupleName, (TuplePartId[])newPartIds);
        PivotIdResolver pivotIdResolver = new PivotIdResolver(this.metaModelManager){

            @NonNull
            public DomainElement visitTemplateParameterId(@NonNull TemplateParameterId id) {
                TemplateParameter templateParameter;
                int index = id.getIndex();
                if (index < allTemplateParameters.length && (templateParameter = allTemplateParameters[index]) != null) {
                    return templateParameter;
                }
                return super.visitTemplateParameterId(id);
            }
        };
        TupleType tupleType = this.getTupleType((IdResolver)pivotIdResolver, tupleTypeId);
        return tupleType;
    }

    @NonNull
    public TupleType getTupleType(@NonNull TupleType type, @Nullable Map<TemplateParameter, ParameterableElement> usageBindings) {
        TupleType specializedTupleType = type;
        HashMap<String, Type> resolutions = null;
        List<Property> parts = specializedTupleType.getOwnedAttribute();
        for (Property part : parts) {
            Type resolvedPropertyType;
            Type propertyType;
            if (part == null || (propertyType = PivotUtil.getType(part)) == null || (resolvedPropertyType = this.metaModelManager.getSpecializedType(propertyType, usageBindings)) == propertyType) continue;
            if (resolutions == null) {
                resolutions = new HashMap<String, Type>();
            }
            resolutions.put(DomainUtil.getSafeName((Nameable)part), resolvedPropertyType);
        }
        if (resolutions != null) {
            ArrayList<TuplePartId> partIds = new ArrayList<TuplePartId>(parts.size());
            int i = 0;
            while (i < parts.size()) {
                Property part = parts.get(i);
                String partName = DomainUtil.getSafeName((Nameable)part);
                Type resolvedPropertyType = (Type)resolutions.get(partName);
                TypeId partTypeId = resolvedPropertyType != null ? resolvedPropertyType.getTypeId() : part.getTypeId();
                TuplePartId tuplePartId = IdManager.getTuplePartId((int)i, (String)partName, (TypeId)partTypeId);
                partIds.add(tuplePartId);
                ++i;
            }
            TupleTypeId tupleTypeId = IdManager.getTupleTypeId((String)((String)DomainUtil.nonNullModel((Object)type.getName())), partIds);
            specializedTupleType = this.getTupleType((IdResolver)this.metaModelManager.getIdResolver(), tupleTypeId);
            return specializedTupleType;
        }
        return this.getTupleType(DomainUtil.getSafeName((Nameable)type), type.getOwnedAttribute(), usageBindings);
    }

    public static class TuplePart
    extends TypedElementImpl {
        @NonNull
        protected final TuplePartId partId;

        public TuplePart(@NonNull TuplePartId partId) {
            this.partId = partId;
            this.setName(partId.getName());
        }

        @NonNull
        public TypeId getTypeId() {
            return this.partId.getTypeId();
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.name)) + " : " + String.valueOf(this.type);
        }
    }
}

