/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.TracingOption;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.utilities.StandaloneProjectMap;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.ProfileApplication;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Stereotype;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExtension;
import org.eclipse.ocl.examples.pivot.ecore.AbstractEcore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.uml.ModelAnalysis;
import org.eclipse.ocl.examples.pivot.uml.ProfileAnalysis;
import org.eclipse.ocl.examples.pivot.uml.UML2PivotDeclarationSwitch;
import org.eclipse.ocl.examples.pivot.uml.UML2PivotReferenceSwitch;
import org.eclipse.ocl.examples.pivot.uml.UML2PivotUseSwitch;
import org.eclipse.ocl.examples.pivot.uml.UMLASResourceFactory;
import org.eclipse.ocl.examples.pivot.utilities.AliasAdapter;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UML2Pivot
extends AbstractEcore2Pivot {
    @NonNull
    public static final TracingOption ADD_ELEMENT_EXTENSION = new TracingOption("org.eclipse.ocl.examples.pivot", "uml2pivot/addElementExtension");
    @NonNull
    public static final TracingOption ADD_IMPORTED_RESOURCE = new TracingOption("org.eclipse.ocl.examples.pivot", "uml2pivot/addImportedResource");
    @NonNull
    public static final TracingOption ADD_PROFILE_APPLICATION = new TracingOption("org.eclipse.ocl.examples.pivot", "uml2pivot/addProfileApplication");
    @NonNull
    public static final TracingOption ADD_STEREOTYPE_APPLICATION = new TracingOption("org.eclipse.ocl.examples.pivot", "uml2pivot/addStereotypeApplication");
    @NonNull
    public static final TracingOption ADD_TYPE_EXTENSION = new TracingOption("org.eclipse.ocl.examples.pivot", "uml2pivot/addTypeExtension");
    @NonNull
    public static final TracingOption APPLICABLE_STEREOTYPES = new TracingOption("org.eclipse.ocl.examples.pivot", "uml2pivot/applicableStereotypes");
    @NonNull
    public static final TracingOption CONVERT_RESOURCE = new TracingOption("org.eclipse.ocl.examples.pivot", "uml2pivot/convertResource");
    @NonNull
    public static final TracingOption TYPE_EXTENSIONS = new TracingOption("org.eclipse.ocl.examples.pivot", "uml2pivot/typeExtensions");
    @NonNull
    public static final String STEREOTYPE_BASE_PREFIX = "base_";
    @NonNull
    public static final String STEREOTYPE_EXTENSION_PREFIX = "extension_";
    private static final Logger logger = Logger.getLogger(UML2Pivot.class);
    @NonNull
    protected final Resource umlResource;
    protected Root pivotRoot = null;
    private URI umlURI = null;

    @Nullable
    public static UML2Pivot findAdapter(@NonNull Resource resource, @NonNull MetaModelManager metaModelManager) {
        for (Adapter adapter : resource.eAdapters()) {
            UML2Pivot uml2Pivot;
            if (!(adapter instanceof UML2Pivot) || (uml2Pivot = (UML2Pivot)adapter).getMetaModelManager() != metaModelManager) continue;
            return uml2Pivot;
        }
        return null;
    }

    @NonNull
    public static UML2Pivot getAdapter(@NonNull Resource resource, @Nullable MetaModelManager metaModelManager) {
        UML2Pivot adapter;
        if (metaModelManager == null) {
            metaModelManager = new MetaModelManager();
        } else {
            adapter = UML2Pivot.findAdapter(resource, metaModelManager);
            if (adapter != null) {
                return adapter;
            }
        }
        adapter = new Outer(resource, metaModelManager);
        return adapter;
    }

    public static Root importFromUML(@NonNull MetaModelManager metaModelManager, String alias, Resource umlResource) throws ParserException {
        if (umlResource == null) {
            return null;
        }
        UML2Pivot conversion = UML2Pivot.getAdapter(umlResource, metaModelManager);
        return conversion.getPivotRoot();
    }

    public static Element importFromUML(@NonNull MetaModelManager metaModelManager, String alias, EObject eObject) throws ParserException {
        if (eObject == null) {
            return null;
        }
        Resource umlResource = eObject.eResource();
        if (umlResource == null) {
            return null;
        }
        UML2Pivot conversion = UML2Pivot.getAdapter(umlResource, metaModelManager);
        Root pivotRoot = conversion.getPivotRoot();
        return conversion.getCreated(Element.class, eObject);
    }

    public static String initialize(@NonNull ResourceSet resourceSet) {
        UMLResourcesUtil.init((ResourceSet)resourceSet);
        String resourcesPluginId = "org.eclipse.uml2.uml.resources";
        String resourcesLocation = null;
        StandaloneProjectMap projectMap = StandaloneProjectMap.getAdapter((ResourceSet)resourceSet);
        URI locationURI = projectMap.getLocation("org.eclipse.uml2.uml.resources");
        if (locationURI != null) {
            resourcesLocation = locationURI.toString();
            while (resourcesLocation.endsWith("/")) {
                resourcesLocation = resourcesLocation.substring(0, resourcesLocation.length() - 1);
            }
        }
        if (resourcesLocation == null) {
            return "'org.eclipse.uml2.uml.resources' not found on class-path";
        }
        Map uriMap = resourceSet.getURIConverter().getURIMap();
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/profiles/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/metamodels/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/libraries/")));
        return null;
    }

    public static String initialize(@NonNull StandaloneProjectMap projectMap) {
        UMLResourcesUtil.init(null);
        String resourcesPluginId = "org.eclipse.uml2.uml.resources";
        String resourcesLocation = null;
        URI locationURI = projectMap.getLocation("org.eclipse.uml2.uml.resources");
        if (locationURI != null) {
            resourcesLocation = locationURI.toString();
            while (resourcesLocation.endsWith("/")) {
                resourcesLocation = resourcesLocation.substring(0, resourcesLocation.length() - 1);
            }
        }
        if (resourcesLocation == null) {
            return "'org.eclipse.uml2.uml.resources' not found on class-path";
        }
        Map uriMap = URIConverter.URI_MAP;
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/profiles/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/metamodels/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), URI.createURI((String)(String.valueOf(resourcesLocation) + "/libraries/")));
        return null;
    }

    public static boolean isUML(@NonNull Resource resource) {
        EList contents = resource.getContents();
        for (EObject content : contents) {
            if (!(content instanceof org.eclipse.uml2.uml.Package)) continue;
            return true;
        }
        return false;
    }

    public static UML2Pivot loadFromUML(@NonNull ASResource umlASResource, @NonNull URI umlURI) {
        MetaModelManager metaModelManager = PivotUtil.getMetaModelManager((Resource)umlASResource);
        Resource umlResource = metaModelManager.getExternalResourceSet().getResource(umlURI, true);
        if (umlResource == null) {
            return null;
        }
        UML2Pivot conversion = UML2Pivot.getAdapter(umlResource, metaModelManager);
        try {
            conversion.getPivotRoot();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return conversion;
    }

    protected UML2Pivot(@NonNull Resource umlResource, @NonNull MetaModelManager metaModelManager) {
        super(metaModelManager);
        if (CONVERT_RESOURCE.isActive()) {
            CONVERT_RESOURCE.println(umlResource.getURI().toString());
        }
        this.umlResource = umlResource;
        umlResource.eAdapters().add((Object)this);
        metaModelManager.addExternalResource(this);
        metaModelManager.addListener(this);
        PackageManager packageManager = metaModelManager.getPackageManager();
        packageManager.addPackageNsURISynonym((String)DomainUtil.nonNullEMF((Object)"http://www.eclipse.org/uml2/5.0.0/UML"), "$uml$");
        packageManager.addPackageNsURISynonym((String)DomainUtil.nonNullEMF((Object)"http://www.eclipse.org/uml2/5.0.0/Types"), "$types$");
    }

    public abstract void addCreated(@NonNull EObject var1, @NonNull Element var2);

    public void addImportedPackage(@NonNull org.eclipse.uml2.uml.Package importedPackage) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)importedPackage);
        Resource importedResource = (Resource)DomainUtil.nonNullEMF((Object)rootContainer.eResource());
        this.addImportedResource(importedResource);
    }

    public void addImportedPackages(@NonNull List<? extends org.eclipse.uml2.uml.Package> importedPackages) {
        for (org.eclipse.uml2.uml.Package package_ : importedPackages) {
            if (package_ == null) continue;
            this.addImportedPackage(package_);
        }
    }

    public abstract void addImportedResource(@NonNull Resource var1);

    public abstract void addProfileApplication(@NonNull ProfileApplication var1);

    public abstract void addProperty(@NonNull Type var1, @NonNull Property var2);

    public abstract void addStereotype(@NonNull Stereotype var1);

    public abstract void addStereotypeApplication(@NonNull EObject var1);

    public abstract void addTypeExtension(@NonNull TypeExtension var1);

    @NonNull
    protected URI createPivotURI() {
        URI uri = this.umlResource.getURI();
        if (uri == null) {
            throw new IllegalStateException("Missing resource URI");
        }
        return PivotUtil.getASURI(uri);
    }

    public void dispose() {
        this.metaModelManager.removeExternalResource(this);
        this.getTarget().eAdapters().remove((Object)this);
        this.metaModelManager.removeListener(this);
    }

    @Override
    public abstract void error(@NonNull String var1);

    @Nullable
    public abstract <T extends Element> T getCreated(@NonNull java.lang.Class<T> var1, @NonNull EObject var2);

    @NonNull
    public abstract UML2PivotDeclarationSwitch getDeclarationPass();

    @NonNull
    public abstract Root getPivotRoot() throws ParserException;

    @Nullable
    public abstract Type getPivotType(@NonNull EObject var1);

    @Override
    @NonNull
    public Resource getResource() {
        return this.umlResource;
    }

    @NonNull
    public abstract Outer getRoot();

    @NonNull
    public Notifier getTarget() {
        return this.umlResource;
    }

    @Override
    @NonNull
    public URI getURI() {
        return (URI)DomainUtil.nonNullState((Object)this.umlResource.getURI());
    }

    @NonNull
    protected Root installDeclarations(@NonNull Resource asResource) {
        URI pivotURI = asResource.getURI();
        Root pivotRoot2 = this.pivotRoot = this.metaModelManager.createRoot(this.umlURI != null ? this.umlURI.toString() : pivotURI.toString());
        asResource.getContents().add((Object)pivotRoot2);
        UML2PivotDeclarationSwitch declarationPass = this.getDeclarationPass();
        ArrayList<Package> rootPackages = new ArrayList<Package>();
        for (EObject eObject : this.umlResource.getContents()) {
            Object pivotElement = declarationPass.doSwitch(eObject);
            if (pivotElement instanceof Package) {
                rootPackages.add((Package)pivotElement);
                continue;
            }
            if (pivotElement == null) continue;
            this.error("Bad UML content : " + eObject.eClass().getName());
        }
        PivotUtil.refreshList(pivotRoot2.getNestedPackage(), rootPackages);
        return pivotRoot2;
    }

    @Override
    public boolean isAdapterFor(@NonNull MetaModelManager metaModelManager) {
        return this.metaModelManager == metaModelManager;
    }

    public boolean isAdapterForType(Object type) {
        return type == UML2Pivot.class;
    }

    protected boolean isPivot(@NonNull Collection<EObject> umlContents) {
        if (umlContents.size() != 1) {
            return false;
        }
        EObject umlRoot = umlContents.iterator().next();
        if (!(umlRoot instanceof EPackage)) {
            return false;
        }
        EPackage umlPackage = (EPackage)umlRoot;
        if (umlPackage.getEClassifier(PivotPackage.Literals.ENUMERATION_LITERAL.getName()) == null) {
            return false;
        }
        if (umlPackage.getEClassifier(PivotPackage.Literals.EXPRESSION_IN_OCL.getName()) == null) {
            return false;
        }
        if (umlPackage.getEClassifier(PivotPackage.Literals.OPERATION_CALL_EXP.getName()) == null) {
            return false;
        }
        return umlPackage.getEClassifier(PivotPackage.Literals.TEMPLATE_PARAMETER_SUBSTITUTION.getName()) != null;
    }

    @Override
    public void metaModelManagerDisposed(@NonNull MetaModelManager metaModelManager) {
        this.dispose();
    }

    public void notifyChanged(Notification notification) {
    }

    public abstract void queueUse(@NonNull EObject var1);

    protected <T extends Element> T refreshElement(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, @NonNull EObject umlElement) {
        assert (pivotEClass != null);
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        Element castElement = (Element)pivotElement;
        return (T)castElement;
    }

    @NonNull
    protected <T extends NamedElement> T refreshNamedElement(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, @NonNull org.eclipse.uml2.uml.NamedElement umlNamedElement) {
        assert (pivotEClass != null);
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        NamedElement castElement = (NamedElement)pivotElement;
        castElement.setName(umlNamedElement.getName());
        return (T)castElement;
    }

    @Nullable
    public Stereotype resolveStereotype(@NonNull EObject umlStereotypeApplication, @NonNull List<org.eclipse.uml2.uml.Element> umlStereotypedElements) {
        DomainUtil.nonNullState((Object)this.pivotRoot);
        EClass umlStereotypeEClass = umlStereotypeApplication.eClass();
        if (!(umlStereotypeApplication instanceof DynamicEObjectImpl)) {
            Stereotype asStereotype = this.metaModelManager.getPivotOfEcore(Stereotype.class, (EObject)umlStereotypeEClass);
            return asStereotype;
        }
        org.eclipse.uml2.uml.Package umlStereotypedPackage = null;
        Iterator<org.eclipse.uml2.uml.Element> iterator = umlStereotypedElements.iterator();
        block0: while (iterator.hasNext()) {
            org.eclipse.uml2.uml.Element umlStereotypedElement;
            org.eclipse.uml2.uml.Element eObject = umlStereotypedElement = iterator.next();
            while (eObject != null) {
                if (eObject instanceof org.eclipse.uml2.uml.Package) {
                    if (umlStereotypedPackage == null) {
                        umlStereotypedPackage = (org.eclipse.uml2.uml.Package)eObject;
                        continue block0;
                    }
                    if (umlStereotypedPackage == (org.eclipse.uml2.uml.Package)eObject) continue block0;
                    logger.error((Object)("Conflicting packages for stereotype application of " + umlStereotypeEClass.getName()));
                    continue block0;
                }
                eObject = eObject.eContainer();
            }
        }
        EPackage umlProfileEPackage = umlStereotypeEClass.getEPackage();
        if (umlStereotypedPackage != null) {
            String profileNsURI = umlProfileEPackage.getNsURI();
            org.eclipse.uml2.uml.Package umlPackage = umlStereotypedPackage;
            while (umlPackage != null) {
                for (org.eclipse.uml2.uml.ProfileApplication umlProfileApplication : umlPackage.getProfileApplications()) {
                    Profile umlProfile = umlProfileApplication.getAppliedProfile();
                    if (!profileNsURI.equals(umlProfile.getURI())) continue;
                    org.eclipse.uml2.uml.Stereotype umlStereotype = umlProfile.getOwnedStereotype(umlStereotypeEClass.getName());
                    return umlStereotype != null ? this.getCreated(Stereotype.class, (EObject)umlStereotype) : null;
                }
                umlPackage = umlPackage.getNestingPackage();
            }
            String profileName = umlProfileEPackage.getName();
            org.eclipse.uml2.uml.Package umlPackage2 = umlStereotypedPackage;
            while (umlPackage2 != null) {
                for (org.eclipse.uml2.uml.ProfileApplication umlProfileApplication : umlPackage2.getProfileApplications()) {
                    Profile umlProfile = umlProfileApplication.getAppliedProfile();
                    if (!profileName.equals(umlProfile.getName())) continue;
                    org.eclipse.uml2.uml.Stereotype umlStereotype = umlProfile.getOwnedStereotype(umlStereotypeEClass.getName());
                    return umlStereotype != null ? this.getCreated(Stereotype.class, (EObject)umlStereotype) : null;
                }
                umlPackage2 = umlPackage2.getNestingPackage();
            }
        }
        logger.error((Object)("Missing package for stereotype application of " + umlStereotypeEClass.getName()));
        return null;
    }

    @Nullable
    protected Type resolveType(@NonNull org.eclipse.uml2.uml.Type umlType) {
        Type pivotType = this.getCreated(Type.class, (EObject)umlType);
        if (pivotType != null) {
            return pivotType;
        }
        if (umlType instanceof PrimitiveType) {
            if (UMLUtil.isBoolean((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getBooleanType();
            }
            if (UMLUtil.isInteger((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getIntegerType();
            }
            if (UMLUtil.isReal((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getRealType();
            }
            if (UMLUtil.isString((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getStringType();
            }
            if (UMLUtil.isUnlimitedNatural((org.eclipse.uml2.uml.Type)umlType)) {
                return this.metaModelManager.getUnlimitedNaturalType();
            }
        }
        return pivotType;
    }

    @Nullable
    protected Type resolveTypeParameter(@NonNull EGenericType eGenericType) {
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        if (eTypeParameter != null) {
            EList eTypeArguments = eGenericType.getETypeArguments();
            assert (eClassifier == null);
            assert (eTypeArguments.isEmpty());
            Type pivotType = this.getCreated(Type.class, (EObject)eTypeParameter);
            return pivotType;
        }
        return null;
    }

    @Nullable
    protected Type resolveWildcardType(@NonNull EGenericType eGenericType) {
        EObject eContainer;
        List list;
        int index;
        assert (eGenericType.getETypeArguments().isEmpty());
        assert (eGenericType.getEClassifier() == null);
        EClassifier eClassifier = eGenericType.getERawType();
        assert (eClassifier == EcorePackage.Literals.EJAVA_OBJECT);
        Class pivotElement = PivotFactory.eINSTANCE.createClass();
        String name = "wildcard";
        EReference eFeature = eGenericType.eContainmentFeature();
        if (eFeature != null && eFeature.isMany() && (index = (list = (List)(eContainer = eGenericType.eContainer()).eGet(eGenericType.eContainingFeature())).indexOf(eGenericType)) != 0) {
            name = String.valueOf(name) + index;
        }
        pivotElement.setName(name);
        return pivotElement;
    }

    protected void setOriginalMapping(@NonNull Element pivotElement, @NonNull EObject umlElement) {
        ((PivotObjectImpl)((Object)pivotElement)).setTarget((Notifier)umlElement);
        this.addCreated(umlElement, pivotElement);
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == null || newTarget == this.umlResource);
    }

    public void setUMLURI(URI umlURI) {
        this.umlURI = umlURI;
    }

    public String toString() {
        return String.valueOf(this.umlResource.getURI());
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (oldTarget == this.umlResource);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Inner
    extends UML2Pivot {
        @NonNull
        protected final Outer root;

        protected Inner(@NonNull Resource umlResource, @NonNull Outer root) {
            super(umlResource, root.getMetaModelManager());
            this.root = root;
        }

        @Override
        public void addCreated(@NonNull EObject umlElement, @NonNull Element pivotElement) {
            this.root.addCreated(umlElement, pivotElement);
        }

        @Override
        public void addGenericType(@NonNull EGenericType eObject) {
            this.root.addGenericType(eObject);
        }

        @Override
        public void addImportedResource(@NonNull Resource importedResource) {
            this.root.addImportedResource(importedResource);
        }

        @Override
        public void addMapping(@NonNull EObject eObject, @NonNull Element pivotElement) {
            this.root.addMapping(eObject, pivotElement);
        }

        @Override
        public void addProfileApplication(@NonNull ProfileApplication asProfileApplication) {
            this.root.addProfileApplication(asProfileApplication);
        }

        @Override
        public void addProperty(@NonNull Type asType, @NonNull Property asProperty) {
            this.root.addProperty(asType, asProperty);
        }

        @Override
        public void addStereotype(@NonNull Stereotype asStereotype) {
            this.root.addStereotype(asStereotype);
        }

        @Override
        public void addStereotypeApplication(@NonNull EObject stereotypeApplication) {
            this.root.addStereotypeApplication(stereotypeApplication);
        }

        @Override
        public void addTypeExtension(@NonNull TypeExtension asTypeExtension) {
            this.root.addTypeExtension(asTypeExtension);
        }

        @Override
        public void error(@NonNull String message) {
            this.root.error(message);
        }

        @Override
        public <T extends Element> T getCreated(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
            return this.root.getCreated(requiredClass, eObject);
        }

        @Override
        @NonNull
        public UML2PivotDeclarationSwitch getDeclarationPass() {
            return this.root.getDeclarationPass();
        }

        @Override
        @NonNull
        public Root getPivotRoot() throws ParserException {
            Root pivotRoot2 = this.pivotRoot;
            if (pivotRoot2 == null) {
                pivotRoot2 = this.root.getPivotRoot();
                Resource asResource = this.pivotRoot.eResource();
                if (asResource == null) {
                    throw new IllegalStateException("Missing containing resource");
                }
                this.metaModelManager.installResource(asResource);
            }
            return pivotRoot2;
        }

        @Override
        @Nullable
        public Type getPivotType(@NonNull EObject eObject) {
            return this.root.getPivotType(eObject);
        }

        @Override
        @NonNull
        public Outer getRoot() {
            return this.root;
        }

        @Override
        public void queueReference(@NonNull EObject umlElement) {
            this.root.queueReference(umlElement);
        }

        @Override
        public void queueUse(@NonNull EObject umlElement) {
            this.root.queueUse(umlElement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Outer
    extends UML2Pivot {
        @NonNull
        private Map<EObject, Element> createMap = new HashMap<EObject, Element>();
        @NonNull
        private Set<EObject> referencers = new HashSet<EObject>();
        @NonNull
        private Set<EObject> users = new HashSet<EObject>();
        @NonNull
        private Set<UML2Pivot> allConverters = new HashSet<UML2Pivot>();
        private List<Resource.Diagnostic> errors = null;
        @NonNull
        protected final ProfileAnalysis profileAnalysis = new ProfileAnalysis(this);
        @NonNull
        protected final ModelAnalysis modelAnalysis = new ModelAnalysis(this, this.profileAnalysis);
        @NonNull
        protected final UML2PivotDeclarationSwitch declarationPass = new UML2PivotDeclarationSwitch(this);
        @NonNull
        protected final UML2PivotReferenceSwitch referencePass = new UML2PivotReferenceSwitch(this);
        @NonNull
        protected final UML2PivotUseSwitch usePass = new UML2PivotUseSwitch(this);
        private List<Resource> importedResources = null;
        @NonNull
        private Map<Type, List<Property>> type2properties = new HashMap<Type, List<Property>>();

        protected Outer(@NonNull Resource umlResource, @NonNull MetaModelManager metaModelManager) {
            super(umlResource, metaModelManager);
        }

        @Override
        public void addCreated(@NonNull EObject eObject, @NonNull Element pivotElement) {
            Element oldElement = this.createMap.put(eObject, pivotElement);
        }

        @Override
        public void addGenericType(@NonNull EGenericType eObject) {
        }

        @Override
        public void addImportedResource(@NonNull Resource importedResource) {
            if (importedResource != this.umlResource) {
                if (this.importedResources == null) {
                    this.importedResources = new ArrayList<Resource>();
                }
                if (!this.importedResources.contains(importedResource)) {
                    URI uri = importedResource.getURI();
                    if (ADD_IMPORTED_RESOURCE.isActive()) {
                        ADD_IMPORTED_RESOURCE.println(String.valueOf(uri));
                    }
                    if ("pathmap://UML_METAMODELS/UML.metamodel.uml".equals(uri.toString())) {
                        this.repairMetamodel(importedResource);
                    }
                    this.importedResources.add(importedResource);
                }
            }
        }

        private void repairMetamodel(Resource resource) {
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof OpaqueExpression)) continue;
                OpaqueExpression opaqueExpression = (OpaqueExpression)eObject;
                EObject eContainer1 = opaqueExpression.eContainer();
                EObject eContainer2 = eContainer1 != null ? eContainer1.eContainer() : null;
                String name1 = eContainer1 instanceof org.eclipse.uml2.uml.NamedElement ? ((org.eclipse.uml2.uml.NamedElement)eContainer1).getName() : "<null>";
                String name2 = eContainer2 instanceof org.eclipse.uml2.uml.NamedElement ? ((org.eclipse.uml2.uml.NamedElement)eContainer2).getName() : "<null>";
                String key = String.valueOf(name2) + "::" + name1;
                if (eContainer2 instanceof org.eclipse.uml2.uml.Type) continue;
                EObject eContainer3 = eContainer2 != null ? eContainer2.eContainer() : null;
                String name3 = eContainer3 instanceof org.eclipse.uml2.uml.NamedElement ? ((org.eclipse.uml2.uml.NamedElement)eContainer3).getName() : "<null>";
                key = String.valueOf(name3) + "::" + key;
            }
        }

        @Override
        public void addMapping(@NonNull EObject eObject, @NonNull Element pivotElement) {
            if (pivotElement instanceof PivotObjectImpl) {
                ((PivotObjectImpl)((Object)pivotElement)).setTarget((Notifier)eObject);
            }
            this.addCreated(eObject, pivotElement);
        }

        @Override
        public void addProfileApplication(@NonNull ProfileApplication asProfileApplication) {
            this.modelAnalysis.addProfileApplication(asProfileApplication);
        }

        @Override
        public void addProperty(@NonNull Type asType, @NonNull Property asProperty) {
            List<Property> asProperties = this.type2properties.get(asType);
            if (asProperties == null) {
                asProperties = new ArrayList<Property>();
                this.type2properties.put(asType, asProperties);
            }
            asProperties.add(asProperty);
        }

        @Override
        public void addStereotype(@NonNull Stereotype asStereotype) {
            this.profileAnalysis.addStereotype(asStereotype);
        }

        @Override
        public void addStereotypeApplication(@NonNull EObject stereotypeApplication) {
            this.modelAnalysis.addStereotypeApplication(stereotypeApplication);
        }

        @Override
        public void addTypeExtension(@NonNull TypeExtension asTypeExtension) {
            this.profileAnalysis.addTypeExtension(asTypeExtension);
        }

        @Override
        public void error(@NonNull String message) {
            if (this.errors == null) {
                this.errors = new ArrayList<Resource.Diagnostic>();
            }
            this.errors.add((Resource.Diagnostic)new XMIException(message));
        }

        @Override
        public <T extends Element> T getCreated(@NonNull java.lang.Class<T> requiredClass, @NonNull EObject eObject) {
            Element element = this.createMap.get(eObject);
            if (element == null) {
                Resource resource = eObject.eResource();
                if (resource == this.umlResource || this.importedResources != null && this.importedResources.contains(resource)) {
                    return null;
                }
                try {
                    return this.metaModelManager.getPivotOf(requiredClass, eObject);
                }
                catch (ParserException e) {
                    return null;
                }
            }
            if (!requiredClass.isAssignableFrom(element.getClass())) {
                logger.error((Object)("UML " + element.getClass().getName() + "' element is not a '" + requiredClass.getName() + "'"));
                return null;
            }
            Element castElement = element;
            return (T)castElement;
        }

        @Override
        @NonNull
        public final UML2PivotDeclarationSwitch getDeclarationPass() {
            return this.declarationPass;
        }

        @Nullable
        public List<Resource> getImportedResources() {
            return this.importedResources;
        }

        @Override
        @NonNull
        public Root getPivotRoot() throws ParserException {
            Root pivotRoot2 = this.pivotRoot;
            if (pivotRoot2 == null) {
                URI pivotURI = this.createPivotURI();
                ASResource asResource = this.metaModelManager.getResource(pivotURI, "org.eclipse.ocl.examples.oclas.uml");
                try {
                    pivotRoot2 = this.installDeclarations((Resource)asResource);
                    this.installImports();
                    this.installReferencers();
                    this.modelAnalysis.installStereotypes();
                    this.installProperties();
                    this.installUsers();
                }
                catch (Exception e) {
                    throw new ParserException("Failed to load '" + pivotURI + "' : " + e.getMessage(), e);
                }
                if (this.errors != null) {
                    asResource.getErrors().addAll(this.errors);
                }
                this.installAliases((Resource)asResource);
                this.metaModelManager.installResource((Resource)asResource);
                ResourceSet resourceSet = this.umlResource.getResourceSet();
                if (resourceSet != null) {
                    this.metaModelManager.addExternalResources(resourceSet);
                }
            }
            return pivotRoot2;
        }

        @Override
        public Type getPivotType(@NonNull EObject eObject) {
            Element pivotElement = this.createMap.get(eObject);
            if (pivotElement == null) {
                UML2Pivot converter;
                Resource resource = eObject.eResource();
                if (resource != this.umlResource && resource != null && this.allConverters.add(converter = Outer.getAdapter(resource, this.metaModelManager))) {
                    try {
                        converter.getPivotRoot();
                    }
                    catch (ParserException e) {
                        String message = e.getMessage();
                        this.error(message);
                    }
                }
                pivotElement = this.createMap.get(eObject);
            }
            if (pivotElement == null) {
                this.error("Unresolved " + eObject);
            } else if (!(pivotElement instanceof Type)) {
                this.error("Incompatible " + eObject);
            } else {
                return (Type)pivotElement;
            }
            return null;
        }

        @Override
        @NonNull
        public Outer getRoot() {
            return this;
        }

        protected void installAliases(@NonNull Resource asResource) {
            AliasAdapter umlAdapter = AliasAdapter.findAdapter(this.umlResource);
            if (umlAdapter != null) {
                Map<EObject, String> umlAliasMap = umlAdapter.getAliasMap();
                AliasAdapter pivotAdapter = AliasAdapter.getAdapter(asResource);
                Map<EObject, String> pivotAliasMap = pivotAdapter.getAliasMap();
                for (EObject eObject : umlAliasMap.keySet()) {
                    String alias = umlAliasMap.get(eObject);
                    Element element = this.createMap.get(eObject);
                    pivotAliasMap.put(element, alias);
                }
            }
        }

        protected void installImports() throws ParserException {
            if (this.importedResources != null) {
                int i = 0;
                while (i < this.importedResources.size()) {
                    Resource importedResource = this.importedResources.get(i);
                    if (importedResource != null) {
                        if (UMLASResourceFactory.INSTANCE.getHandlerPriority(importedResource) != 100) {
                            this.metaModelManager.loadResource(importedResource, null);
                        } else {
                            UML2Pivot adapter = UML2Pivot.findAdapter(importedResource, this.metaModelManager);
                            if (adapter == null) {
                                Inner importedAdapter = new Inner(importedResource, this);
                                URI pivotURI = importedAdapter.createPivotURI();
                                ASResource asResource = this.metaModelManager.getResource(pivotURI, "org.eclipse.ocl.examples.oclas.uml");
                                importedAdapter.installDeclarations((Resource)asResource);
                                adapter = importedAdapter;
                                this.metaModelManager.installResource((Resource)asResource);
                            } else if (adapter instanceof Outer) {
                                this.createMap.putAll(((Outer)adapter).createMap);
                            } else if (adapter instanceof Inner) {
                                this.createMap.putAll(((Inner)adapter).root.createMap);
                            }
                        }
                    }
                    ++i;
                }
            }
        }

        protected void installProperties() {
            for (Type pivotType : this.type2properties.keySet()) {
                List<Property> asProperties = this.type2properties.get(pivotType);
                Collections.sort(asProperties, DomainUtil.NAMEABLE_COMPARATOR);
                this.refreshList((List)DomainUtil.nonNullEMF(pivotType.getOwnedAttribute()), asProperties);
            }
        }

        protected void installReferencers() {
            for (EObject eObject : this.referencers) {
                this.referencePass.doSwitch(eObject);
            }
        }

        protected void installUsers() {
            for (EObject eObject : this.users) {
                this.usePass.doSwitch(eObject);
            }
        }

        @Override
        public void queueReference(@NonNull EObject umlElement) {
            this.referencers.add(umlElement);
        }

        @Override
        public void queueUse(@NonNull EObject umlElement) {
            this.users.add(umlElement);
        }
    }
}

