/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.export.ValidityExporterRegistry;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneCommandAnalyzer;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.examples.xtext.completeocl.CompleteOCLStandaloneSetup;

public class StandaloneApplication
implements IApplication {
    private static final String ARGS_KEY = "application.args";
    private ResourceSet resourceSet = null;
    @NonNull
    private final StandaloneCommandAnalyzer commandAnalyzer = new StandaloneCommandAnalyzer(this);

    public StandaloneApplication() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ValidityExporterRegistry.initialize((ValidityExporterRegistry)ValidityExporterRegistry.INSTANCE);
        }
    }

    public void doCompleteOCLSetup() {
        this.getResourceSet();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            CompleteOCLStandaloneSetup.doSetup();
        }
        OCLDelegateDomain.initialize((ResourceSet)this.resourceSet);
    }

    @NonNull
    public StandaloneResponse execute(@NonNull String[] args) {
        StandaloneCommand command = this.commandAnalyzer.parse(args);
        if (command == null) {
            return StandaloneResponse.FAIL;
        }
        Map<StandaloneCommand.CommandToken, List<String>> token2strings = command.parse(args);
        if (token2strings == null) {
            return StandaloneResponse.FAIL;
        }
        boolean isOk = command.check(token2strings);
        if (!isOk) {
            return StandaloneResponse.FAIL;
        }
        return command.execute(token2strings);
    }

    @NonNull
    public Collection<StandaloneCommand> getCommands() {
        return this.commandAnalyzer.getCommands();
    }

    @NonNull
    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    public Resource loadModelFile(URI fileUri) {
        Resource loadedResource = this.resourceSet.getResource(fileUri, true);
        if (!loadedResource.isLoaded()) {
            return null;
        }
        return loadedResource;
    }

    public Resource loadOCLFile(URI oclUri) {
        Resource loadedResource = this.getResourceSet().getResource(oclUri, true);
        if (!loadedResource.isLoaded()) {
            return null;
        }
        return loadedResource;
    }

    public Object start(IApplicationContext context) {
        String[] args = (String[])context.getArguments().get(ARGS_KEY);
        StandaloneResponse applicationCodeResponse = this.execute(args);
        if (StandaloneResponse.OK.equals((Object)applicationCodeResponse)) {
            return IApplication.EXIT_OK;
        }
        return IApplication.EXIT_RELAUNCH;
    }

    public void stop() {
    }
}

