/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone.validity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultSet;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.EClassConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.EClassifierConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.EValidatorConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.standalone.validity.StandaloneValidityModel;
import org.eclipse.ocl.examples.validity.locator.PivotConstraintLocator;
import org.eclipse.ocl.examples.validity.locator.UMLConstraintLocator;

public class StandaloneValidityManager
extends ValidityManager {
    private boolean runOCLConstraints = false;
    private boolean runJavaConstraints = false;
    private boolean runUMLConstraints = false;

    @NonNull
    protected ValidityModel createModel(@NonNull Collection<Resource> newResources) {
        return new StandaloneValidityModel(this, newResources);
    }

    @NonNull
    private static List<ConstrainingNode> getConstrainingNodeAncestors(@NonNull ConstrainingNode constraining) {
        ConstrainingNode ancestor = constraining.getParent();
        ArrayList<ConstrainingNode> ancestors = new ArrayList<ConstrainingNode>();
        while (ancestor != null) {
            ancestors.add(ancestor);
            ancestor = ancestor.getParent();
        }
        return ancestors;
    }

    @NonNull
    public List<ConstraintLocator> getInUseConstraintLocators(@NonNull String nsURI) {
        ArrayList<ConstraintLocator> list = new ArrayList<ConstraintLocator>();
        if (this.runOCLConstraints) {
            PivotConstraintLocator pivotConstraintsLocator = new PivotConstraintLocator();
            list.add((ConstraintLocator)pivotConstraintsLocator);
        }
        if (this.runJavaConstraints) {
            EClassConstraintLocator eClassConstraintsLocator = new EClassConstraintLocator();
            list.add((ConstraintLocator)eClassConstraintsLocator);
            EClassifierConstraintLocator eClassifierConstraintsLocator = new EClassifierConstraintLocator();
            list.add((ConstraintLocator)eClassifierConstraintsLocator);
            EValidatorConstraintLocator eValidatorConstraintsLocator = new EValidatorConstraintLocator();
            list.add((ConstraintLocator)eValidatorConstraintsLocator);
        }
        if (this.runUMLConstraints) {
            UMLConstraintLocator umlConstraintsLocator = new UMLConstraintLocator();
            list.add((ConstraintLocator)umlConstraintsLocator);
        }
        return list;
    }

    public void runValidation() {
        ResultSet resultSet = this.createResultSet((IProgressMonitor)new NullProgressMonitor());
        List results = this.installResultSet(resultSet, (IProgressMonitor)new NullProgressMonitor());
        for (Result result : results) {
            try {
                ValidatableNode validatable = result.getValidatableNode();
                ValidatableNode validatableParent = validatable.getParent();
                LeafConstrainingNode constraint = result.getLeafConstrainingNode();
                if (constraint != null) {
                    List<ConstrainingNode> constrainingAncestors = StandaloneValidityManager.getConstrainingNodeAncestors((ConstrainingNode)constraint);
                    boolean isConstrainingNodeEnabled = true;
                    for (ConstrainingNode constrainingAncestor : constrainingAncestors) {
                        if (constrainingAncestor.isEnabled()) continue;
                        isConstrainingNodeEnabled = false;
                        break;
                    }
                    boolean isEnabledForValidation = false;
                    if (isConstrainingNodeEnabled) {
                        if (validatable instanceof ResultValidatableNode) {
                            if (validatableParent != null && validatableParent.isEnabled()) {
                                isEnabledForValidation = true;
                            }
                        } else {
                            isEnabledForValidation = true;
                        }
                    }
                    if (isEnabledForValidation) {
                        ConstraintLocator constraintLocator = constraint.getConstraintLocator();
                        constraintLocator.validate(result, (ValidityManager)this, null);
                        continue;
                    }
                    result.setSeverity(Severity.UNKNOWN);
                    continue;
                }
                result.setSeverity(Severity.UNKNOWN);
            }
            catch (Exception e) {
                result.setException((Throwable)e);
                result.setSeverity(Severity.FATAL);
            }
        }
    }

    public void setRunJavaConstraints(boolean runJavaConstraints) {
        this.runJavaConstraints = runJavaConstraints;
    }

    public void setRunOCLConstraints(boolean runOCLConstraints) {
        this.runOCLConstraints = runOCLConstraints;
    }

    public void setRunUMLConstraints(boolean runUMLConstraints) {
        this.runUMLConstraints = runUMLConstraints;
    }
}

