/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.ConstraintEvaluator;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;

public abstract class AbstractPivotConstraintLocator
extends org.eclipse.ocl.examples.emf.validation.validity.locator.AbstractConstraintLocator {
    @NonNull
    protected EvaluationVisitor createEvaluationVisitor(@NonNull MetaModelManager metaModelManager, @NonNull ExpressionInOCL query, @Nullable Object contextObject, @Nullable Monitor monitor) {
        PivotEnvironmentFactory environmentFactory = new PivotEnvironmentFactory(null, metaModelManager);
        PivotEnvironment rootEnvironment = environmentFactory.createEnvironment();
        EvaluationVisitor evaluationVisitor = environmentFactory.createEvaluationVisitor((Environment)rootEnvironment, contextObject, query, null);
        evaluationVisitor.setMonitor(monitor);
        return evaluationVisitor;
    }

    @NonNull
    protected ExpressionInOCL getQuery(@NonNull Constraint constraint) throws ParserException {
        OpaqueExpression specification = constraint.getSpecification();
        assert (specification != null);
        ExpressionInOCL query = specification.getExpressionInOCL();
        if (query == null) {
            throw new ParserException("Missing constraint");
        }
        return query;
    }

    protected static abstract class AbstractConstraintLocator
    extends ConstraintEvaluator<Diagnostic> {
        @NonNull
        protected final MetaModelManager metaModelManager;
        @Nullable
        protected final Object object;

        protected AbstractConstraintLocator(@NonNull MetaModelManager metaModelManager, @NonNull ExpressionInOCL expression, @Nullable Object object) {
            super(expression);
            this.metaModelManager = metaModelManager;
            this.object = object;
        }

        protected Diagnostic handleExceptionResult(@NonNull Throwable e) {
            String message = DomainUtil.bind((String)OCLMessages.ValidationConstraintException_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e});
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{this.object});
        }

        protected Diagnostic handleFailureResult(@Nullable Object result) {
            String message = this.getConstraintResultMessage(result);
            int severity = this.getConstraintResultSeverity(result);
            return new BasicDiagnostic(severity, "org.eclipse.emf.ecore", 0, message, new Object[]{this.object});
        }

        protected Diagnostic handleInvalidExpression(@NonNull String message) {
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{this.object});
        }

        protected Diagnostic handleInvalidResult(@NonNull InvalidValueException e) {
            String message = DomainUtil.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object[])new Object[]{this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel(), e.getLocalizedMessage()});
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, message, new Object[]{this.object});
        }

        protected Diagnostic handleSuccessResult() {
            return null;
        }
    }
}

