/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.validity.locator.AbstractPivotConstraintLocator;
import org.eclipse.ocl.examples.validity.plugin.OCLValidityPlugin;

public class DelegateConstraintLocator
extends AbstractPivotConstraintLocator {
    @NonNull
    public static DelegateConstraintLocator INSTANCE = new DelegateConstraintLocator();

    @Nullable
    protected Constraint getConstraint(@NonNull MetaModelManager metaModelManager, @NonNull ResultConstrainingNode resultConstrainingNode) throws ParserException {
        Type asType;
        EObject eClassifier;
        EStringToStringMapEntryImpl eEntry;
        EObject eAnnotation;
        Object constrainingObject = resultConstrainingNode.getParent().getConstrainingObject();
        if (constrainingObject instanceof EAnnotation) {
            EObject eObject = ((EAnnotation)constrainingObject).eContainer();
            if (eObject instanceof EOperation) {
                return (Constraint)metaModelManager.getPivotOf(Constraint.class, eObject);
            }
        } else if (constrainingObject instanceof EStringToStringMapEntryImpl && (eAnnotation = (eEntry = (EStringToStringMapEntryImpl)constrainingObject).eContainer()) instanceof EAnnotation && (eClassifier = ((EAnnotation)eAnnotation).eContainer()) instanceof EClassifier && (asType = (Type)metaModelManager.getPivotOf(Type.class, eClassifier)) != null) {
            return (Constraint)DomainUtil.getNamedElement((Iterable)asType.getOwnedInvariant(), (String)eEntry.getKey());
        }
        return null;
    }

    @NonNull
    protected EObject getConstrainedObject(@NonNull ResultConstrainingNode resultConstrainingNode) {
        ValidatableNode validatableNode = resultConstrainingNode.getResultValidatableNode().getParent();
        assert (validatableNode != null);
        return validatableNode.getConstrainedObject();
    }

    @Nullable
    public Map<EObject, List<LeafConstrainingNode>> getConstraints(@NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull Set<Resource> resources, @NonNull Monitor monitor) {
        Map map = null;
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            String constraintName;
            if (monitor.isCanceled()) {
                return null;
            }
            EAnnotation oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eClassifier);
            if (oclAnnotation != null) {
                EMap details = oclAnnotation.getDetails();
                for (Map.Entry constraint : details.entrySet()) {
                    constraintName = (String)constraint.getKey();
                    if (constraintName == null) continue;
                    map = this.createLeafConstrainingNode(map, validityModel, (EObject)eClassifier, constraint, constraintName);
                }
            }
            if (!(eClassifier instanceof EClass)) continue;
            for (EOperation eOperation : ((EClass)eClassifier).getEOperations()) {
                String constraintBody;
                if (!EcoreUtil.isInvariant((EOperation)eOperation) || (oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)eOperation)) == null || (constraintBody = (String)oclAnnotation.getDetails().get((Object)"body")) == null || (constraintName = eOperation.getName()) == null) continue;
                map = this.createLeafConstrainingNode(map, validityModel, (EObject)eClassifier, oclAnnotation, constraintName);
            }
        }
        return map;
    }

    public Object getImage() {
        return OCLValidityPlugin.INSTANCE.getImage("OCLModelFile.gif");
    }

    @NonNull
    public String getName() {
        return "Delegated OCL constraints";
    }

    @Nullable
    public String getSourceExpression(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (constrainingObject instanceof EAnnotation) {
            return (String)((EAnnotation)constrainingObject).getDetails().get((Object)"body");
        }
        if (constrainingObject instanceof EStringToStringMapEntryImpl) {
            return ((EStringToStringMapEntryImpl)constrainingObject).getValue();
        }
        return null;
    }

    @NonNull
    protected String print(@NonNull Map<EClassifier, List<LeafConstrainingNode>> map) {
        StringBuilder s = new StringBuilder();
        ArrayList<EClassifier> sortedList = new ArrayList<EClassifier>(map.keySet());
        Collections.sort(sortedList, new Comparator<EClassifier>(){

            @Override
            public int compare(EClassifier o1, EClassifier o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (EClassifier eClassifier : sortedList) {
            s.append("\t" + eClassifier.getName() + ":");
            for (LeafConstrainingNode constraint : map.get(eClassifier)) {
                s.append(" '" + constraint.getLabel() + "'");
            }
            s.append("\n");
        }
        String string = s.toString();
        return string;
    }

    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        EObject constrainedObject = result.getValidatableNode().getConstrainedObject();
        Resource eResource = constrainedObject.eResource();
        if (eResource == null) {
            return;
        }
        ResultConstrainingNode resultConstrainingNode = result.getResultConstrainingNode();
        if (resultConstrainingNode == null) {
            return;
        }
        MetaModelManager metaModelManager = PivotUtil.getMetaModelManager((Resource)eResource);
        Constraint asConstraint = null;
        try {
            asConstraint = this.getConstraint(metaModelManager, resultConstrainingNode);
        }
        catch (ParserException e1) {
            e1.printStackTrace();
        }
        Severity severity = Severity.UNKNOWN;
        try {
            try {
                if (asConstraint == null) {
                    throw new ParserException("Failed to create pivot Constraint");
                }
                final Constraint finalConstraint = asConstraint;
                ExpressionInOCL query = this.getQuery(asConstraint);
                EvaluationVisitor evaluationVisitor = this.createEvaluationVisitor(metaModelManager, query, constrainedObject, monitor);
                AbstractPivotConstraintLocator.AbstractConstraintLocator constraintEvaluator = new AbstractPivotConstraintLocator.AbstractConstraintLocator(metaModelManager, query, constrainedObject){

                    protected String getObjectLabel() {
                        Type type = PivotUtil.getContainingType((EObject)finalConstraint);
                        Type primaryType = type != null ? this.metaModelManager.getPrimaryType((DomainType)type) : null;
                        EClassifier classifier = primaryType != null ? (EClassifier)primaryType.getETarget() : null;
                        return classifier != null ? classifier.getName() : "??";
                    }
                };
                Diagnostic diagnostic = (Diagnostic)constraintEvaluator.evaluate(evaluationVisitor);
                result.setDiagnostic((Object)diagnostic);
                severity = diagnostic != null ? this.getSeverity(diagnostic) : Severity.OK;
            }
            catch (Throwable e) {
                result.setException(e);
                severity = Severity.FATAL;
                result.setSeverity(severity);
            }
        }
        finally {
            result.setSeverity(severity);
        }
    }
}

