/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.ui.locator.ConstraintUILocator;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityView;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.validity.locator.UMLConstraintLocator;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.ocl.examples.xtext.console.XtextConsolePlugin;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Constraint;

public class UMLUIConstraintLocator
extends UMLConstraintLocator
implements ConstraintUILocator {
    @NonNull
    public static UMLUIConstraintLocator INSTANCE = new UMLUIConstraintLocator();

    public boolean debug(@NonNull ResultConstrainingNode resultConstrainingNode, @NonNull ValidityView validityView, @NonNull IProgressMonitor monitor) throws CoreException {
        Object object = resultConstrainingNode.getParent().getConstrainingObject();
        if (!(object instanceof Constraint)) {
            throw new IllegalStateException("non-UML Constraint " + object);
        }
        Constraint umlConstraint = (Constraint)object;
        MetaModelManager metaModelManager = PivotUtil.getMetaModelManager((Resource)umlConstraint.eResource());
        org.eclipse.ocl.examples.pivot.Constraint constraint = null;
        try {
            constraint = (org.eclipse.ocl.examples.pivot.Constraint)metaModelManager.getPivotOf(org.eclipse.ocl.examples.pivot.Constraint.class, (EObject)umlConstraint);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (constraint == null) {
            throw new IllegalStateException("non-UML Constraint " + object);
        }
        OpaqueExpression specification = constraint.getSpecification();
        String expression = specification != null ? PrettyPrinter.print((Element)specification) : "";
        ValidatableNode parent = resultConstrainingNode.getResultValidatableNode().getParent();
        if (parent == null) {
            return false;
        }
        EObject eObject = parent.getConstrainedObject();
        Shell shell = validityView.getSite().getShell();
        DebugStarter runnable = new DebugStarter(shell, metaModelManager, eObject, expression);
        runnable.run(monitor);
        return runnable.getLaunch() != null;
    }

    protected static class DebugStarter
    implements IRunnableWithProgress {
        @NonNull
        protected final Shell shell;
        @NonNull
        protected final MetaModelManager metaModelManager;
        @Nullable
        protected final EObject contextObject;
        @NonNull
        protected final String expression;
        @Nullable
        private ILaunch launch = null;

        public DebugStarter(@NonNull Shell shell, @NonNull MetaModelManager metaModelManager, @Nullable EObject contextObject, @NonNull String expression) {
            this.shell = shell;
            this.metaModelManager = metaModelManager;
            this.contextObject = contextObject;
            this.expression = expression;
        }

        @NonNull
        protected URI createDocument(IProgressMonitor monitor) throws IOException, CoreException {
            PivotIdResolver idResolver = this.metaModelManager.getIdResolver();
            DomainType staticType = idResolver.getStaticTypeOf((Object)this.contextObject);
            Type contextType = this.metaModelManager.getType(staticType);
            if (contextType instanceof Metaclass) {
                contextType = ((Metaclass)contextType).getInstanceType();
            }
            Package contextPackage = contextType.getPackage();
            IPath documentPath = XtextConsolePlugin.getInstance().getStateLocation().append("debug" + EcoreUtil.generateUUID() + ".ocl");
            IFileStore documentStore = EFS.getLocalFileSystem().getStore(documentPath);
            OutputStream documentStream = documentStore.openOutputStream(0, monitor);
            PrettyPrintOptions.Global printOptions = PrettyPrinter.createOptions(null);
            printOptions.addReservedNames((Iterable)PrettyPrinter.restrictedNameList);
            OutputStreamWriter s = new OutputStreamWriter(documentStream);
            String externalURI = null;
            if (contextPackage != null) {
                Root containingRoot = PivotUtil.getContainingRoot((EObject)contextPackage);
                if (containingRoot == null) {
                    externalURI = contextPackage.getNsURI();
                } else if (containingRoot != PivotUtil.getContainingRoot((EObject)this.metaModelManager.getOclAnyType()) && PivotUtil.isASURI((String)(externalURI = containingRoot.getExternalURI()))) {
                    URI uri = URI.createURI((String)externalURI);
                    externalURI = PivotUtil.getNonASURI((URI)uri).toString();
                }
                if (externalURI != null) {
                    ((Writer)s).append("import '" + externalURI + "'\n\n");
                }
            }
            ((Writer)s).append("context ");
            if (externalURI == null) {
                ((Writer)s).append("ocl::");
            }
            ((Writer)s).append(String.valueOf(PrettyPrinter.printName((Element)contextType, (PrettyPrintOptions)printOptions)) + "\n");
            ((Writer)s).append("def: oclDebuggerExpression() : OclAny = \n\t");
            ((Writer)s).append(this.expression.replace("\n", "\n\t"));
            ((Writer)s).append("\n");
            ((Writer)s).close();
            java.net.URI documentURI1 = documentStore.toURI();
            URI documentURI2 = URI.createURI((String)documentURI1.toString());
            return documentURI2;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        protected ILaunch launchDebugger(IProgressMonitor monitor, @Nullable EObject contextObject, @NonNull ExpressionInOCL expressionInOCL) throws CoreException {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.ocl.examples.debug.launching.OCLLaunchConfigurationDelegate");
            ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance(null, "test");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("expressionObject", expressionInOCL);
            attributes.put("contextObject", contextObject);
            launchConfiguration.setAttributes(attributes);
            return launchConfiguration.launch("debug", monitor);
        }

        @Nullable
        protected BaseCSResource loadDocument(IProgressMonitor monitor, @NonNull URI documentURI) throws Exception {
            Resource resource;
            ResourceSet resourceSet;
            Resource contextResource = this.contextObject != null ? this.contextObject.eResource() : null;
            ResourceSet resourceSet2 = resourceSet = contextResource != null ? contextResource.getResourceSet() : null;
            if (resourceSet == null) {
                resourceSet = new ResourceSetImpl();
            }
            if ((resource = resourceSet.getResource(documentURI, true)) instanceof BaseCSResource) {
                return (BaseCSResource)resource;
            }
            return null;
        }

        @Nullable
        protected ExpressionInOCL loadExpression(IProgressMonitor monitor, BaseCSResource csResource) {
            CS2PivotResourceAdapter cs2asAdapter = csResource.findCS2ASAdapter();
            if (cs2asAdapter != null) {
                ASResource asResource = cs2asAdapter.getASResource(csResource);
                for (EObject eRoot : asResource.getContents()) {
                    if (!(eRoot instanceof Root)) continue;
                    for (Package asPackage : ((Root)eRoot).getNestedPackage()) {
                        for (Type asType : asPackage.getOwnedType()) {
                            ExpressionInOCL expressionInOCL;
                            for (org.eclipse.ocl.examples.pivot.Constraint asConstraint : asType.getOwnedInvariant()) {
                                OpaqueExpression specification = asConstraint.getSpecification();
                                if (specification == null || (expressionInOCL = specification.getExpressionInOCL()) == null) continue;
                                return expressionInOCL;
                            }
                            for (Operation asOperation : asType.getOwnedOperation()) {
                                OpaqueExpression bodyExpression = asOperation.getBodyExpression();
                                if (bodyExpression == null || (expressionInOCL = bodyExpression.getExpressionInOCL()) == null) continue;
                                return expressionInOCL;
                            }
                        }
                    }
                }
            }
            return null;
        }

        protected void openError(final String message) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)DebugStarter.this.shell, (String)ConsoleMessages.Debug_Starter, (String)message);
                }
            });
        }

        protected void openError(final String message, final @NonNull Exception e) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Status status = new Status(4, "org.eclipse.ocl.examples.xtext.console", e.getLocalizedMessage(), (Throwable)e);
                    ErrorDialog.openError((Shell)DebugStarter.this.shell, (String)ConsoleMessages.Debug_Starter, (String)message, (IStatus)status);
                }
            });
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(NLS.bind((String)ConsoleMessages.Debug_Starter, (Object)this.expression), 3);
            try {
                BaseCSResource csResource;
                URI documentURI;
                monitor.subTask(ConsoleMessages.Debug_ProgressCreate);
                try {
                    documentURI = this.createDocument(monitor);
                }
                catch (Exception e) {
                    this.openError(ConsoleMessages.Debug_FailCreate, e);
                    monitor.done();
                    return;
                }
                monitor.worked(1);
                monitor.subTask(ConsoleMessages.Debug_ProgressLoad);
                String debug_FailLoad = ConsoleMessages.Debug_FailLoad;
                try {
                    csResource = this.loadDocument(monitor, documentURI);
                }
                catch (Exception e) {
                    this.openError(debug_FailLoad, e);
                    monitor.done();
                    return;
                }
                if (csResource == null) {
                    this.openError(debug_FailLoad);
                    return;
                }
                String message = PivotUtil.formatResourceDiagnostics((List)((List)DomainUtil.nonNullEMF((Object)csResource.getErrors())), (String)debug_FailLoad, (String)"\n\t");
                if (message != null) {
                    this.openError(message);
                    return;
                }
                ExpressionInOCL expressionInOCL = this.loadExpression(monitor, csResource);
                if (expressionInOCL == null) {
                    this.openError(debug_FailLoad);
                    return;
                }
                monitor.worked(1);
                monitor.subTask(ConsoleMessages.Debug_ProgressLoad);
                try {
                    this.launch = this.launchDebugger(monitor, this.contextObject, expressionInOCL);
                }
                catch (CoreException e) {
                    this.openError(ConsoleMessages.Debug_FailLaunch, (Exception)((Object)e));
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
    }
}

