/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.ui.utilities;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.EStructuralFeatureNode;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class BaseUIUtil {
    @Nullable
    public static IXtextDocument getActiveDocument(@Nullable IWorkbenchSite site) {
        IEditorPart activeEditor;
        block9: {
            IWorkbenchPage activePage;
            block8: {
                IWorkbenchWindow workbenchWindow;
                block7: {
                    block6: {
                        try {
                            if (site != null) break block6;
                            return null;
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                    workbenchWindow = site.getWorkbenchWindow();
                    if (workbenchWindow != null) break block7;
                    return null;
                }
                activePage = workbenchWindow.getActivePage();
                if (activePage != null) break block8;
                return null;
            }
            activeEditor = activePage.getActiveEditor();
            if (activeEditor instanceof XtextEditor) break block9;
            return null;
        }
        IXtextDocument xtextDocument = ((XtextEditor)activeEditor).getDocument();
        return xtextDocument;
    }

    @Nullable
    public static ISelection getActiveSelection(@Nullable IWorkbenchSite site) {
        ISelectionProvider selectionProvider;
        block13: {
            IEditorSite editorSite;
            block12: {
                IEditorPart activeEditor;
                block11: {
                    IWorkbenchPage activePage;
                    block10: {
                        IWorkbenchWindow workbenchWindow;
                        block9: {
                            block8: {
                                try {
                                    if (site != null) break block8;
                                    return null;
                                }
                                catch (Exception e) {
                                    return null;
                                }
                            }
                            workbenchWindow = site.getWorkbenchWindow();
                            if (workbenchWindow != null) break block9;
                            return null;
                        }
                        activePage = workbenchWindow.getActivePage();
                        if (activePage != null) break block10;
                        return null;
                    }
                    activeEditor = activePage.getActiveEditor();
                    if (activeEditor != null) break block11;
                    return null;
                }
                editorSite = activeEditor.getEditorSite();
                if (editorSite != null) break block12;
                return null;
            }
            selectionProvider = editorSite.getSelectionProvider();
            if (selectionProvider != null) break block13;
            return null;
        }
        return selectionProvider.getSelection();
    }

    @Nullable
    public static Object getSelectedObject(@Nullable ISelection sel, @Nullable IWorkbenchSite site) {
        Object selectedObject = null;
        if (sel instanceof ITextSelection) {
            selectedObject = BaseUIUtil.getXtextTextSelection((ITextSelection)sel, site);
        } else {
            IStructuredSelection ssel;
            if (sel instanceof IStructuredSelection && !(ssel = (IStructuredSelection)sel).isEmpty()) {
                selectedObject = ssel.getFirstElement();
            }
            if (selectedObject instanceof IOutlineNode) {
                selectedObject = BaseUIUtil.getXtextOutlineSelection((IOutlineNode)selectedObject, site);
            }
        }
        return selectedObject;
    }

    @Nullable
    public static Object getXtextOutlineSelection(@NonNull IOutlineNode outlineNodeSelection, @Nullable IWorkbenchSite site) {
        if (outlineNodeSelection instanceof EObjectNode) {
            URI eObjectURI;
            EObjectNode selectedObjectNode = (EObjectNode)outlineNodeSelection;
            IXtextDocument xtextDocument = BaseUIUtil.getActiveDocument(site);
            if (xtextDocument != null && (eObjectURI = selectedObjectNode.getEObjectURI()) != null) {
                return xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

                    public EObject exec(@Nullable XtextResource resource) throws Exception {
                        if (resource == null) {
                            return null;
                        }
                        String fragment = eObjectURI.fragment();
                        if (fragment == null) {
                            return null;
                        }
                        return resource.getEObject(fragment);
                    }
                });
            }
        } else {
            boolean cfr_ignored_0 = outlineNodeSelection instanceof EStructuralFeatureNode;
        }
        return null;
    }

    @Nullable
    public static Object getXtextTextSelection(final @NonNull ITextSelection textSelection, @Nullable IWorkbenchSite site) {
        IXtextDocument xtextDocument = BaseUIUtil.getActiveDocument(site);
        if (xtextDocument == null) {
            return null;
        }
        return xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

            public EObject exec(@Nullable XtextResource resource) throws Exception {
                if (resource == null) {
                    return null;
                }
                if (resource.getContents().size() <= 0) {
                    return null;
                }
                EObject rootObject = (EObject)resource.getContents().get(0);
                ICompositeNode rootNode = NodeModelUtils.getNode((EObject)rootObject);
                if (rootNode == null) {
                    return null;
                }
                ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)textSelection.getOffset());
                if (leafNode == null) {
                    return null;
                }
                return leafNode.getSemanticElement();
            }
        });
    }
}

