/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagedAdapter;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerListener;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.BaseCSPackage;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.RootCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.basecs.util.BaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2as.ExceptionAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CSI2PivotMapping;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CS2Pivot
extends AbstractConversion
implements MetaModelManagedAdapter {
    private static Map<EReference, UnresolvedProxyMessageProvider> unresolvedProxyMessageProviderMap = new HashMap<EReference, UnresolvedProxyMessageProvider>();
    public static boolean showContext = false;
    private static MessageBinder messageBinder = DefaultMessageBinder.INSTANCE;
    private static long startTime = System.currentTimeMillis();
    @NonNull
    private static Map<Thread, Long> threadRunTimes = new HashMap<Thread, Long>();
    private static long[] indentRunTimes = new long[100];
    @NonNull
    private static Integer indentation = 0;
    @NonNull
    private static String indents = ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>";
    @NonNull
    protected final Set<? extends BaseCSResource> csResources;
    @NonNull
    protected final CSI2PivotMapping cs2PivotMapping;

    public static EList<EObject> computeRootContainmentFeatures(RootCS csRoot) {
        BasicEList containmentsList = new BasicEList();
        for (EStructuralFeature eStructuralFeature : csRoot.eClass().getEAllStructuralFeatures()) {
            EReference eReference;
            if (!(eStructuralFeature instanceof EReference) || !(eReference = (EReference)eStructuralFeature).isContainment()) continue;
            containmentsList.add((Object)eReference);
        }
        int index = containmentsList.indexOf((Object)BaseCSPackage.Literals.ROOT_CS__OWNED_IMPORT);
        if (index > 0) {
            containmentsList.move(0, index);
        }
        if ((index = containmentsList.indexOf((Object)BaseCSPackage.Literals.ROOT_CS__OWNED_LIBRARY)) > 0) {
            containmentsList.move(0, index);
        }
        return new EContentsEList((EObject)csRoot, (List)containmentsList);
    }

    public static void addUnresolvedProxyMessageProvider(UnresolvedProxyMessageProvider unresolvedProxyMessageProvider) {
        unresolvedProxyMessageProviderMap.put(unresolvedProxyMessageProvider.getEReference(), unresolvedProxyMessageProvider);
    }

    public static Element basicGetType(TypedTypeRefCS csTypedRef) {
        EList<PathElementCS> path = csTypedRef.getPathName().getPath();
        int iLast = path.size() - 1;
        int i = 0;
        while (i < iLast) {
            Element element = ((PathElementCS)path.get(i)).basicGetElement();
            if (element == null) {
                return null;
            }
            ++i;
        }
        Element element = ((PathElementCS)path.get(iLast)).basicGetElement();
        if (element == null) {
            return null;
        }
        return element;
    }

    @Nullable
    public static DiagnosticMessage getUnresolvedProxyMessage(@NonNull EReference eReference, @NonNull EObject csContext, @NonNull String linkText) {
        String message = CS2Pivot.getUnresolvedProxyText(eReference, csContext, linkText);
        return message != null ? new DiagnosticMessage(message, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]) : null;
    }

    @Nullable
    public static String getUnresolvedProxyText(@NonNull EReference eReference, @NonNull EObject csContext, @NonNull String linkText) {
        ExceptionAdapter exceptionAdapter = (ExceptionAdapter)((Object)PivotUtil.getAdapter(ExceptionAdapter.class, (Notifier)csContext));
        if (exceptionAdapter != null) {
            return exceptionAdapter.getErrorMessage();
        }
        UnresolvedProxyMessageProvider unresolvedProxyMessageProvider = unresolvedProxyMessageProviderMap.get(eReference);
        if (unresolvedProxyMessageProvider != null) {
            return unresolvedProxyMessageProvider.getMessage(csContext, linkText);
        }
        String messageTemplate = OCLMessages.Unresolved_ERROR_;
        String errorContext = "Unknown";
        EClass referenceType = eReference.getEReferenceType();
        if (referenceType != null) {
            errorContext = referenceType.getName();
        }
        return messageBinder.bind(csContext, messageTemplate, errorContext, linkText);
    }

    @Nullable
    public static CS2Pivot findAdapter(@NonNull ResourceSet resourceSet) {
        return (CS2Pivot)((Object)PivotUtil.getAdapter(CS2Pivot.class, (Notifier)resourceSet));
    }

    public static List<ILeafNode> getDocumentationNodes(@NonNull ICompositeNode node) {
        ArrayList<ILeafNode> documentationNodes = null;
        for (ILeafNode leafNode : node.getLeafNodes()) {
            EObject grammarElement = leafNode.getGrammarElement();
            if (!(grammarElement instanceof TerminalRule)) break;
            TerminalRule terminalRule = (TerminalRule)grammarElement;
            String name = terminalRule.getName();
            if ("WS".equals(name) || "SL_COMMENT".equals(name)) continue;
            if (!"ML_COMMENT".equals(name)) break;
            if (documentationNodes == null) {
                documentationNodes = new ArrayList<ILeafNode>();
            }
            documentationNodes.add(leafNode);
        }
        return documentationNodes;
    }

    public static MessageBinder getMessageBinder() {
        return messageBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDiagnostic(@NonNull String message, boolean dispose, int indent) {
        Integer n = indentation;
        synchronized (n) {
            if (indent < 0) {
                indentation = indentation - 1;
            }
            long currentTimeMillis = System.currentTimeMillis();
            Thread currentThread = Thread.currentThread();
            Long threadStartTime = threadRunTimes.get(currentThread);
            if (threadStartTime == null) {
                threadStartTime = currentTimeMillis;
                threadRunTimes.put(currentThread, threadStartTime);
            }
            if (indent > 0) {
                System.out.printf("%s %8.3f %s -- %6.3f %s\n", indents.substring(0, Math.min(indentation, indents.length() - 1)), (double)(currentTimeMillis - startTime) * 0.001, currentThread.getName(), (double)(currentTimeMillis - threadStartTime) * 0.001, message);
            } else {
                System.out.printf("%s %8.3f %s -- %6.3f %6.3f %s\n", indents.substring(0, Math.min(indentation, indents.length() - 1)), (double)(currentTimeMillis - startTime) * 0.001, currentThread.getName(), (double)(currentTimeMillis - threadStartTime) * 0.001, (double)(currentTimeMillis - indentRunTimes[indentation]) * 0.001, message);
            }
            if (dispose) {
                threadRunTimes.remove(currentThread);
            }
            if (indent > 0) {
                CS2Pivot.indentRunTimes[CS2Pivot.indentation.intValue()] = currentTimeMillis;
                indentation = indentation + 1;
            }
        }
    }

    public static void refreshContext(@NonNull PathNameCS pathNameCS, ElementCS csContext) {
        if (pathNameCS.getContext() != csContext) {
            pathNameCS.setContext(csContext);
        }
    }

    public static void refreshElementType(PathElementCS pathElementCS, EClassifier elementType) {
        if (pathElementCS != null && pathElementCS.getElementType() != elementType) {
            pathElementCS.setElementType(elementType);
        }
    }

    public static void refreshScopeFilter(@NonNull PathNameCS pathNameCS, ScopeFilter scopeFilter) {
        if (pathNameCS.getScopeFilter() != scopeFilter) {
            pathNameCS.setScopeFilter(scopeFilter);
        }
    }

    public static void setElementType(@NonNull PathNameCS pathNameCS, EClass elementType, @NonNull ElementCS csContext, @Nullable ScopeFilter scopeFilter) {
        assert (elementType != null);
        CS2Pivot.refreshContext(pathNameCS, csContext);
        CS2Pivot.refreshScopeFilter(pathNameCS, scopeFilter);
        EList<PathElementCS> path = pathNameCS.getPath();
        int iMax = path.size() - 1;
        CS2Pivot.refreshElementType((PathElementCS)path.get(iMax), (EClassifier)elementType);
        if (PivotPackage.Literals.FEATURE.isSuperTypeOf(elementType) && iMax > 0) {
            CS2Pivot.refreshElementType((PathElementCS)path.get(--iMax), (EClassifier)PivotPackage.Literals.TYPE);
        }
        int i = 0;
        while (i < iMax) {
            CS2Pivot.refreshElementType((PathElementCS)path.get(i), (EClassifier)PivotPackage.Literals.NAMESPACE);
            ++i;
        }
    }

    public static MessageBinder setMessageBinder(MessageBinder messageBinder) {
        MessageBinder savedMessageBinder = CS2Pivot.messageBinder;
        CS2Pivot.messageBinder = messageBinder;
        return savedMessageBinder;
    }

    public CS2Pivot(@NonNull Map<? extends BaseCSResource, ? extends ASResource> cs2asResourceMap, @NonNull MetaModelManager metaModelManager) {
        super(metaModelManager);
        this.cs2PivotMapping = CSI2PivotMapping.getAdapter(metaModelManager);
        this.cs2PivotMapping.add(cs2asResourceMap);
        this.csResources = (Set)DomainUtil.nonNullState(cs2asResourceMap.keySet());
        metaModelManager.addListener((MetaModelManagerListener)this);
        metaModelManager.getASResourceSet().eAdapters().add((Object)this);
    }

    protected CS2Pivot(@NonNull CS2Pivot aConverter) {
        super(aConverter.metaModelManager);
        this.csResources = aConverter.csResources;
        this.cs2PivotMapping = CSI2PivotMapping.getAdapter(this.metaModelManager);
    }

    @NonNull
    public String bind(@NonNull EObject csContext, String messageTemplate, Object ... bindings) {
        assert (messageTemplate != null);
        return messageBinder.bind(csContext, messageTemplate, bindings);
    }

    @NonNull
    protected abstract BaseCSVisitor<Continuation<?>> createContainmentVisitor(@NonNull CS2PivotConversion var1);

    @NonNull
    protected CS2PivotConversion createConversion(@NonNull IDiagnosticConsumer diagnosticsConsumer, @NonNull Collection<? extends BaseCSResource> csResources) {
        return new CS2PivotConversion(this, diagnosticsConsumer, csResources);
    }

    @NonNull
    protected abstract BaseCSVisitor<Element> createLeft2RightVisitor(@NonNull CS2PivotConversion var1);

    @NonNull
    protected abstract BaseCSVisitor<Continuation<?>> createPostOrderVisitor(@NonNull CS2PivotConversion var1);

    @NonNull
    protected abstract BaseCSVisitor<Continuation<?>> createPreOrderVisitor(@NonNull CS2PivotConversion var1);

    public void dispose() {
        this.cs2PivotMapping.removeCSResources(this.csResources);
        this.csResources.clear();
        this.metaModelManager.getASResourceSet().eAdapters().remove((Object)this);
        this.metaModelManager.removeListener((MetaModelManagerListener)this);
    }

    @Nullable
    public ModelElementCS getCSElement(@NonNull Element pivotElement) {
        return this.cs2PivotMapping.getCSElement(pivotElement);
    }

    @NonNull
    public Collection<? extends BaseCSResource> getCSResources() {
        return this.csResources;
    }

    public Element getPivotElement(@NonNull ModelElementCS csElement) {
        return this.cs2PivotMapping.get(csElement);
    }

    @Nullable
    public <T extends Element> T getPivotElement(@NonNull Class<T> pivotClass, @NonNull ModelElementCS csElement) {
        Element pivotElement = this.cs2PivotMapping.get(csElement);
        if (pivotElement == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException(String.valueOf(pivotElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    public ASResource getPivotResource(@NonNull BaseCSResource csResource) {
        return this.cs2PivotMapping.getASResource(csResource);
    }

    public Collection<? extends Resource> getPivotResources() {
        return this.metaModelManager.getASResourceSet().getResources();
    }

    public Notifier getTarget() {
        return this.metaModelManager.getASResourceSet();
    }

    public void installPivotDefinition(@NonNull ModelElementCS csElement, @NonNull Element newPivotElement) {
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement != newPivotElement) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
        this.cs2PivotMapping.put(csElement, newPivotElement);
    }

    public void installPivotReference(@NonNull ElementRefCS csElement, @NonNull Element newPivotElement, @NonNull EReference eReference) {
        assert (eReference.getEContainingClass().isSuperTypeOf(csElement.eClass()));
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement != newPivotElement) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
    }

    public void installPivotUsage(@NonNull ModelElementCS csElement, @NonNull Element newPivotElement) {
        Element oldPivotElement = csElement.getPivot();
        if (oldPivotElement != newPivotElement) {
            assert (!newPivotElement.eIsProxy());
            csElement.setPivot(newPivotElement);
        }
    }

    public boolean isAdapterForType(Object type) {
        if (type instanceof Class) {
            return ((Class)type).isAssignableFrom(((Object)((Object)this)).getClass());
        }
        return false;
    }

    public boolean isAdapterFor(@NonNull MetaModelManager metaModelManager) {
        return this.metaModelManager == metaModelManager;
    }

    public void metaModelManagerDisposed(@NonNull MetaModelManager metaModelManager) {
        this.dispose();
    }

    public void notifyChanged(Notification notification) {
    }

    @NonNull
    public <T extends Element> T refreshModelElement(@NonNull Class<T> pivotClass, @NonNull EClass pivotEClass, @Nullable ModelElementCS csElement) {
        Element pivotElement3;
        Element pivotElement;
        Element element = pivotElement = csElement != null ? this.getPivotElement(csElement) : null;
        if (pivotElement != null && pivotClass.isAssignableFrom(pivotElement.getClass())) {
            PivotUtil.resetContainer((EObject)pivotElement);
        }
        Element pivotElement2 = pivotElement == null || pivotEClass != pivotElement.eClass() ? (pivotElement3 = (Element)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass)) : pivotElement;
        if (csElement != null) {
            this.installPivotDefinition(csElement, pivotElement2);
        }
        Element castElement = pivotElement2;
        return (T)castElement;
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == this.metaModelManager.getASResourceSet());
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (oldTarget == this.metaModelManager.getASResourceSet());
    }

    public synchronized void update(@NonNull IDiagnosticConsumer diagnosticsConsumer) {
        Map<String, Element> oldCSI2Pivot = this.cs2PivotMapping.getMapping();
        Set<String> newCSIs = this.cs2PivotMapping.computeCSIs(this.csResources);
        Collection<? extends BaseCSResource> csResources = this.getCSResources();
        CS2PivotConversion conversion = this.createConversion(diagnosticsConsumer, csResources);
        conversion.update();
        HashMap<BaseCSResource, ASResource> cs2asResourceMap = new HashMap<BaseCSResource, ASResource>();
        for (BaseCSResource baseCSResource : csResources) {
            ASResource asResource = this.cs2PivotMapping.getASResource(baseCSResource);
            cs2asResourceMap.put(baseCSResource, asResource);
        }
        conversion.garbageCollect(cs2asResourceMap);
        this.cs2PivotMapping.update();
    }

    public static abstract class AbstractUnresolvedProxyMessageProvider
    implements UnresolvedProxyMessageProvider {
        @NonNull
        protected final EReference eReference;

        public AbstractUnresolvedProxyMessageProvider(EReference eReference) {
            assert (eReference != null);
            this.eReference = eReference;
        }

        @NonNull
        public EReference getEReference() {
            return this.eReference;
        }

        @Nullable
        public abstract String getMessage(@NonNull EObject var1, @NonNull String var2);
    }

    public static class DefaultMessageBinder
    implements MessageBinder {
        @NonNull
        public static final MessageBinder INSTANCE = new DefaultMessageBinder();

        @NonNull
        public String bind(@NonNull EObject csContext, @NonNull String messageTemplate, Object ... bindings) {
            return DomainUtil.bind((String)messageTemplate, (Object[])bindings);
        }
    }

    public static interface MessageBinder {
        @NonNull
        public String bind(@NonNull EObject var1, @NonNull String var2, Object ... var3);
    }

    public static class MessageBinderWithLineContext
    implements MessageBinder {
        public static final MessageBinder INSTANCE = new MessageBinderWithLineContext();

        @NonNull
        public String bind(@NonNull EObject csContext, @NonNull String messageTemplate, Object ... bindings) {
            String message = DomainUtil.bind((String)messageTemplate, (Object[])bindings);
            ICompositeNode node = NodeModelUtils.getNode((EObject)csContext);
            if (node != null) {
                int startLine = node.getStartLine();
                String uri = csContext.eResource().getURI().toString();
                return String.valueOf(uri) + ":" + startLine + " " + message;
            }
            return message;
        }
    }

    public static interface UnresolvedProxyMessageProvider {
        @NonNull
        public EReference getEReference();

        @Nullable
        public String getMessage(@NonNull EObject var1, @NonNull String var2);
    }
}

