/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.services;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.parser.BaseEPackageAccess;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.service.GrammarProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CompatibilityGrammarProvider
extends GrammarProvider {
    private final String languageName;
    private volatile Grammar grammar;
    private final Provider<XtextResourceSet> resourceSetProvider;
    @Inject(optional=true)
    private ClassLoader classLoader;

    @Inject
    public CompatibilityGrammarProvider(@Named(value="languageName") String languageName, Provider<XtextResourceSet> resourceSetProvider) {
        super(languageName, resourceSetProvider);
        this.languageName = languageName;
        this.resourceSetProvider = resourceSetProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grammar getGrammar(Object requestor) {
        if (this.grammar == null) {
            try {
                this.grammar = super.getGrammar(requestor);
            }
            catch (WrappedException e) {
                CompatibilityGrammarProvider compatibilityGrammarProvider = this;
                synchronized (compatibilityGrammarProvider) {
                    if (this.grammar == null) {
                        XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
                        if (!resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().containsKey("xtextbin")) {
                            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xtextbin", BinaryGrammarResourceFactoryImpl.INSTANCE);
                        }
                        if (this.classLoader != null) {
                            resourceSet.setClasspathURIContext((Object)this.classLoader);
                        } else {
                            ClassLoader classLoaderToUse = requestor == null ? ((Object)((Object)this)).getClass().getClassLoader() : requestor.getClass().getClassLoader();
                            resourceSet.setClasspathURIContext((Object)classLoaderToUse);
                        }
                        this.grammar = (Grammar)BaseEPackageAccess.loadGrammarFile((String)("classpath:/" + this.languageName.replace('.', '/') + ".xtextbin"), (XtextResourceSet)resourceSet);
                    }
                }
            }
        }
        return this.grammar;
    }

    public static class BinaryGrammarResourceFactoryImpl
    implements Resource.Factory {
        @NonNull
        public static final BinaryGrammarResourceFactoryImpl INSTANCE = new BinaryGrammarResourceFactoryImpl();

        public Resource createResource(URI uri) {
            XMIResourceImpl resource = new XMIResourceImpl(uri);
            resource.getDefaultLoadOptions().put("BINARY", Boolean.TRUE);
            resource.getDefaultSaveOptions().put("BINARY", Boolean.TRUE);
            XMLResource.URIHandler uriHandler = new XMLResource.URIHandler(){

                public void setBaseURI(URI uri) {
                }

                public URI resolve(URI uri) {
                    return uri;
                }

                public URI deresolve(URI uri) {
                    return uri;
                }
            };
            resource.getDefaultLoadOptions().put("URI_HANDLER", uriHandler);
            resource.getDefaultSaveOptions().put("URI_HANDLER", uriHandler);
            return resource;
        }
    }
}

