/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.pivot2cs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.ClassUtils;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.util.PivotSwitch;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

public class CompleteOCLSplitter {
    @Nullable
    public static ASResource separate(@NonNull MetaModelManager metaModelManager, @NonNull Resource resource) {
        ArrayList<Constraint> allConstraints = new ArrayList<Constraint>();
        ArrayList<OpaqueExpression> allOpaqueExpressions = new ArrayList<OpaqueExpression>();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            OpaqueExpression bodyExpression;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof Constraint) {
                allConstraints.add((Constraint)eObject);
                continue;
            }
            if (eObject instanceof Operation) {
                bodyExpression = ((Operation)eObject).getBodyExpression();
                if (bodyExpression == null) continue;
                allOpaqueExpressions.add(bodyExpression);
                continue;
            }
            if (eObject instanceof Property) {
                bodyExpression = ((Property)eObject).getDefaultExpression();
                if (bodyExpression == null) continue;
                allOpaqueExpressions.add(bodyExpression);
                continue;
            }
            if (!(eObject instanceof Annotation)) continue;
            tit.prune();
        }
        if (allConstraints.isEmpty()) {
            return null;
        }
        URI uri = resource.getURI();
        URI oclURI = PivotUtil.getNonASURI((URI)uri).appendFileExtension("ocl");
        URI oclASuri = PivotUtil.getASURI((URI)oclURI);
        ASResource oclResource = (ASResource)resource.getResourceSet().createResource(oclASuri, "org.eclipse.ocl.examples.oclas.ocl");
        if (oclResource != null) {
            Separator separator = new Separator(metaModelManager, (Resource)oclResource);
            for (Constraint constraint : allConstraints) {
                separator.doSwitch((EObject)constraint);
            }
            for (OpaqueExpression opaqueExpression : allOpaqueExpressions) {
                separator.doSwitch((EObject)opaqueExpression);
            }
            metaModelManager.installResource((Resource)oclResource);
        }
        return oclResource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Separator
    extends PivotSwitch<EObject> {
        @NonNull
        protected final MetaModelManager metaModelManager;
        @NonNull
        protected final Resource separateResource;
        @NonNull
        private final Map<NamedElement, NamedElement> map = new HashMap<NamedElement, NamedElement>();

        public Separator(@NonNull MetaModelManager metaModelManager, @NonNull Resource separateResource) {
            this.metaModelManager = metaModelManager;
            this.separateResource = separateResource;
        }

        public EObject caseConstraint(Constraint object) {
            NamedElement parent = (NamedElement)object.eContainer();
            NamedElement separateParent = this.getSeparate(parent);
            EStructuralFeature eContainingFeature = object.eContainingFeature();
            PivotUtil.resetContainer((EObject)object);
            if (!eContainingFeature.isMany()) {
                separateParent.eSet(eContainingFeature, (Object)object);
            } else {
                List eGet = (List)separateParent.eGet(eContainingFeature);
                eGet.add(object);
            }
            return object;
        }

        public EObject caseOpaqueExpression(OpaqueExpression object) {
            NamedElement parent = (NamedElement)object.eContainer();
            NamedElement separateParent = this.getSeparate(parent);
            if (separateParent instanceof Operation) {
                PivotUtil.resetContainer((EObject)object);
                ((Operation)separateParent).setBodyExpression(object);
            }
            if (separateParent instanceof Property) {
                PivotUtil.resetContainer((EObject)object);
                ((Property)separateParent).setDefaultExpression(object);
            }
            return object;
        }

        public EObject caseOperation(Operation object) {
            Type parent = object.getOwningType();
            Type separateParent = this.getSeparate(parent);
            List separateSiblings = separateParent.getOwnedOperation();
            EcoreUtil.Copier copier = new EcoreUtil.Copier(false, true){

                protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
                    if (eReference == PivotPackage.Literals.OPERATION__OWNED_PARAMETER) {
                        super.copyContainment(eReference, eObject, copyEObject);
                    }
                }
            };
            Operation clone = (Operation)copier.copy((EObject)object);
            copier.copyReferences();
            separateSiblings.add(clone);
            return clone;
        }

        public EObject casePackage(Package object) {
            List separateSiblings;
            Package separateObject;
            String name = object.getName();
            EObject container = object.eContainer();
            assert (container instanceof Namespace);
            Namespace parent = (Namespace)container;
            Namespace separateParent = (Namespace)this.map.get(parent);
            if (separateParent == null) {
                separateParent = (Namespace)this.doSwitch((EObject)parent);
                this.map.put((NamedElement)parent, (NamedElement)separateParent);
            }
            if ((separateObject = (Package)DomainUtil.getNamedElement((Iterable)(separateSiblings = separateParent instanceof Root ? ((Root)separateParent).getNestedPackage() : ((Package)separateParent).getNestedPackage()), (String)name)) == null) {
                separateObject = (Package)object.eClass().getEPackage().getEFactoryInstance().create(object.eClass());
                separateObject.setName(name);
                separateObject.setNsURI(object.getNsURI());
                separateObject.setNsPrefix(object.getNsPrefix());
                separateSiblings.add(separateObject);
            }
            return separateObject;
        }

        public EObject caseProperty(Property object) {
            Type parent = object.getOwningType();
            Type separateParent = this.getSeparate(parent);
            List separateSiblings = separateParent.getOwnedAttribute();
            EcoreUtil.Copier copier = new EcoreUtil.Copier(false, true){

                protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
                }
            };
            Property clone = (Property)copier.copy((EObject)object);
            copier.copyReferences();
            separateSiblings.add(clone);
            return clone;
        }

        public EObject caseRoot(Root object) {
            String name = object.getName();
            EObject container = object.eContainer();
            assert (container == null);
            EList separateSiblings = this.separateResource.getContents();
            Root separateObject = (Root)this.getElementByName((Iterable<? extends EObject>)separateSiblings, name);
            if (separateObject == null) {
                separateObject = PivotFactory.eINSTANCE.createRoot();
                separateObject.setExternalURI(this.separateResource.getURI().toString());
                separateSiblings.add(separateObject);
            }
            return separateObject;
        }

        public EObject caseType(Type object) {
            Package parent = object.getPackage();
            Package separateParent = this.getSeparate(parent);
            List separateSiblings = separateParent.getOwnedType();
            return this.cloneNamedElement(separateSiblings, object);
        }

        protected <T extends NamedElement> T cloneNamedElement(List<T> separateSiblings, T object) {
            String name = object.getName();
            NamedElement separateObject = (NamedElement)DomainUtil.getNamedElement(separateSiblings, (String)name);
            if (separateObject == null) {
                NamedElement castObject;
                separateObject = castObject = (NamedElement)object.eClass().getEPackage().getEFactoryInstance().create(object.eClass());
                separateObject.setName(name);
                separateSiblings.add(separateObject);
            }
            return (T)separateObject;
        }

        public NamedElement getElementByName(Iterable<? extends EObject> elements, String name) {
            if (elements == null) {
                return null;
            }
            for (EObject eObject : elements) {
                if (!(eObject instanceof NamedElement) || !ClassUtils.equals((Object)name, (Object)((NamedElement)eObject).getName())) continue;
                return (NamedElement)eObject;
            }
            return null;
        }

        protected <T extends NamedElement> T getSeparate(T element) {
            NamedElement separate = this.map.get(element);
            if (separate == null) {
                separate = (NamedElement)this.doSwitch((EObject)element);
                this.map.put(element, separate);
            }
            NamedElement castSeparate = separate;
            return (T)castSeparate;
        }

        protected Package getSeparatePackage(Package element) {
            Package separate = (Package)this.map.get(element);
            if (separate == null) {
                separate = (Package)this.doSwitch((EObject)element);
                this.map.put((NamedElement)element, (NamedElement)separate);
            }
            return separate;
        }
    }
}

