/*******************************************************************************
 * Copyright (c) 2008 Zeligsoft Inc., and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zeligsoft - Initial API and implementation
 *******************************************************************************/
package org.eclipse.ocl.types.operations;

import org.eclipse.emf.common.util.EList;

import org.eclipse.ocl.types.InvalidType;

/**
 * <!-- begin-user-doc -->
 * A static utility class that provides operations related to '<em><b>Invalid Type</b></em>' model objects.
 * @since 1.3
 * <!-- end-user-doc -->
 *
 * <p>
 * The following operations are supported:
 * <ul>
 *   <li>{@link org.eclipse.ocl.utilities.PredefinedType#getName() <em>Get Name</em>}</li>
 *   <li>{@link org.eclipse.ocl.utilities.PredefinedType#oclOperations() <em>Ocl Operations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class InvalidTypeOperations {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvalidTypeOperations() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public static <O> String getName(InvalidType<O> invalidType) {
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public static <O> EList<O> oclOperations(InvalidType<O> invalidType) {
		throw new UnsupportedOperationException();
	}

} // InvalidTypeOperations