/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.editor.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.StaticSelectionCommandAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.customization.properties.editor.actions.CompoundCommandActionDelegate;
import org.eclipse.papyrus.customization.properties.editor.actions.CreateResourceCommand;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.ui.CompositeWidget;
import org.eclipse.papyrus.views.properties.ui.Layout;
import org.eclipse.papyrus.views.properties.ui.UiFactory;
import org.eclipse.papyrus.views.properties.ui.ValueAttribute;

public class CreateSectionWidgetAction
extends StaticSelectionCommandAction {
    private Section section;

    public CreateSectionWidgetAction(ISelection selection) {
        IStructuredSelection sSelection;
        Object selectedElement;
        if (selection instanceof IStructuredSelection && (selectedElement = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Section) {
            this.section = (Section)selectedElement;
        }
        this.configureAction(selection);
    }

    protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
        if (this.section == null) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeWidget newWidget = this.createWidget();
        CompoundCommandActionDelegate createActionCommand = new CompoundCommandActionDelegate();
        createActionCommand.setImage(Activator.getDefault().getImage("org.eclipse.papyrus.views.properties.model.edit", "icons/full/obj16/CompositeWidget.gif"));
        createActionCommand.append(this.getCreateResourceCommand(newWidget));
        createActionCommand.append(this.getSetWidgetCommand(newWidget));
        return createActionCommand;
    }

    private CompositeWidget createWidget() {
        CompositeWidget newWidget = UiFactory.eINSTANCE.createCompositeWidget();
        for (Map.Entry<String, String> entry : this.getNamespaces().entrySet()) {
            ValueAttribute attribute = UiFactory.eINSTANCE.createValueAttribute();
            attribute.setName(entry.getKey());
            attribute.setValue(entry.getValue());
            newWidget.getAttributes().add((Object)attribute);
        }
        newWidget.setWidgetType(ConfigurationManager.getInstance().getDefaultCompositeType());
        Layout layout = UiFactory.eINSTANCE.createLayout();
        layout.setLayoutType(ConfigurationManager.getInstance().getDefaultLayoutType());
        newWidget.setLayout(layout);
        return newWidget;
    }

    private Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xmlns", "http://www.eclipse.org/xwt/presentation");
        namespaces.put("xmlns:x", "http://www.eclipse.org/xwt");
        namespaces.put("xmlns:ppe", "clr-namespace:org.eclipse.papyrus.views.properties.widgets");
        namespaces.put("xmlns:ppel", "clr-namespace:org.eclipse.papyrus.views.properties.widgets.layout");
        return namespaces;
    }

    private Command getCreateResourceCommand(CompositeWidget newWidget) {
        if (this.section.getSectionFile() == null || this.section.getSectionFile().equals("")) {
            this.section.setSectionFile(String.valueOf(this.section.getName()) + ".xwt");
        }
        URI widgetURI = URI.createURI((String)this.section.getSectionFile());
        widgetURI = widgetURI.resolve(this.section.eResource().getURI());
        CreateResourceCommand createWidget = new CreateResourceCommand((EObject)newWidget, widgetURI, this.section.eResource().getResourceSet());
        return createWidget;
    }

    private Command getSetWidgetCommand(CompositeWidget newWidget) {
        if (this.section.getWidget() == null) {
            return SetCommand.create((EditingDomain)this.editingDomain, (Object)this.section, (Object)this.section.eClass().getEStructuralFeature("widget"), (Object)newWidget);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

