/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;

public class ActivePageTracker {
    private List<IActiveEditorChangedListener> activeEditorChangedListeners = new ArrayList<IActiveEditorChangedListener>();
    private List<IPageChangedListener> publicPageChangedListeners;
    protected PagePart activeEditor;

    public PagePart getActiveEditor() {
        return this.activeEditor;
    }

    public void setActiveEditor(PagePart editor) {
        if (this.activeEditor == editor) {
            return;
        }
        PagePart oldEditor = this.activeEditor;
        this.activeEditor = editor;
        this.fireEditorChangeEvent(oldEditor, editor);
    }

    public void addActiveEditorChangedListener(IActiveEditorChangedListener listener) {
        if (this.activeEditorChangedListeners.contains(listener)) {
            return;
        }
        this.activeEditorChangedListeners.add(listener);
    }

    public void removeActiveEditorChangedListener(IActiveEditorChangedListener listener) {
        this.activeEditorChangedListeners.remove(listener);
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        if (this.publicPageChangedListeners == null) {
            this.publicPageChangedListeners = new ArrayList<IPageChangedListener>();
        }
        if (this.publicPageChangedListeners.contains(listener)) {
            return;
        }
        this.publicPageChangedListeners.add(listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        if (this.publicPageChangedListeners == null) {
            return;
        }
        this.publicPageChangedListeners.remove(listener);
    }

    private void fireEditorChangeEvent(PagePart oldEditor, PagePart newEditor) {
        for (IActiveEditorChangedListener iActiveEditorChangedListener : this.activeEditorChangedListeners) {
            iActiveEditorChangedListener.activeEditorChanged(oldEditor, newEditor);
        }
        if (this.publicPageChangedListeners != null) {
            for (IPageChangedListener iPageChangedListener : this.publicPageChangedListeners) {
                iPageChangedListener.pageChanged(newEditor);
            }
        }
    }

    public static interface IActiveEditorChangedListener {
        public void activeEditorChanged(PagePart var1, PagePart var2);
    }
}

